/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diff;

import com.intellij.database.datagrid.CellColors;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridListener;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.diff.DiffSupport;
import com.intellij.database.diff.SpinnerAction;
import com.intellij.database.diff.TableDiffAdapter;
import com.intellij.database.diff.TableDiffBuilder;
import com.intellij.database.diff.TableDiffDividerDrawUtil;
import com.intellij.database.diff.TableDiffEditor;
import com.intellij.database.diff.TableDiffSettingsHolder;
import com.intellij.database.diff.TableDiffSupport;
import com.intellij.database.diff.TableEditorHolder;
import com.intellij.database.diff.TableSyncScrollSupport;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.CellAttributes;
import com.intellij.database.run.ui.grid.CellAttributesKey;
import com.intellij.database.run.ui.grid.GridColorsScheme;
import com.intellij.database.run.ui.grid.GridScrollPane;
import com.intellij.database.util.DbUIUtil;
import com.intellij.diff.DiffContext;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.holders.EditorHolderFactory;
import com.intellij.diff.tools.util.BaseSyncScrollable;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.DiffSplitter;
import com.intellij.diff.tools.util.PrevNextDifferenceIterable;
import com.intellij.diff.tools.util.StatusPanel;
import com.intellij.diff.tools.util.SyncScrollSupport;
import com.intellij.diff.tools.util.side.TwosideDiffViewer;
import com.intellij.diff.util.DiffDividerDrawUtil;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.Side;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ex.CheckboxAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.JBColor;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SpinnerNumberModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TableDiffViewer
extends TwosideDiffViewer<TableEditorHolder> {
    private TableDiffSettingsHolder.Settings mySettings;
    private List<Pair<TableDiffBuilder.RowDiffRange, Boolean>> myFuzzyRowDifferences = Collections.emptyList();
    private List<TableDiffBuilder.CellDiff> myCellDifferences = Collections.emptyList();
    private VisibleAreaListener myScrollListener;
    private TableSyncScrollSupport.TableViewerSyncScrollSupport mySyncScrollListener;
    private final PrevNextDifferenceIterable myPrevNextDifferenceIterable;
    @NotNull
    private final StatusPanel myStatusPanel;
    private final Alarm myAlarm = new Alarm((Disposable)this);

    public TableDiffViewer(DiffContext context, DiffRequest request) {
        super(context, (ContentDiffRequest)request, (EditorHolderFactory)TableEditorHolder.TableEditorHolderFactory.INSTANCE);
        TableDiffSettingsHolder service = context.getProject() == null ? null : (TableDiffSettingsHolder)ServiceManager.getService((Project)context.getProject(), TableDiffSettingsHolder.class);
        this.mySettings = service == null ? new TableDiffSettingsHolder.Settings() : service.getState();
        this.myStatusPanel = new StatusPanel();
        this.myPrevNextDifferenceIterable = new MyPrevNextDifferenceIterable();
        MySyncScrollable scrollable = new MySyncScrollable();
        this.mySyncScrollListener = new TableSyncScrollSupport.TableViewerSyncScrollSupport(this.getEditor1(), this.getEditor2(), (SyncScrollSupport.SyncScrollable)scrollable);
        this.myContentPanel.repaint();
    }

    @NotNull
    TableDiffEditor getEditor2() {
        TableDiffEditor tableDiffEditor = ((TableEditorHolder)((Object)this.getEditorHolders().get(1))).getEditor();
        if (tableDiffEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/TableDiffViewer", "getEditor2"));
        }
        return tableDiffEditor;
    }

    @NotNull
    TableDiffEditor getEditor1() {
        TableDiffEditor tableDiffEditor = ((TableEditorHolder)((Object)this.getEditorHolders().get(0))).getEditor();
        if (tableDiffEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/TableDiffViewer", "getEditor1"));
        }
        return tableDiffEditor;
    }

    @Nullable
    protected List<AnAction> createToolbarActions() {
        List actions = super.createToolbarActions();
        if (actions == null) {
            actions = ContainerUtil.newArrayList();
        }
        actions.add(new CheckboxAction("Detect column insertion", "Detect column insertion", null){

            public boolean isSelected(AnActionEvent e) {
                return ((TableDiffViewer)TableDiffViewer.this).mySettings.detectColumnInsertion;
            }

            public void setSelected(AnActionEvent e, boolean state) {
                ((TableDiffViewer)TableDiffViewer.this).mySettings.detectColumnInsertion = state;
                TableDiffViewer.this.rediff();
            }
        });
        actions.add(new SpinnerAction(new SpinnerNumberModel(this.mySettings.columnMismatchThreshold, 0, Integer.MAX_VALUE, 1), "Tolerance:", "Number of allowed column mismatches", null){

            @Override
            public void update(AnActionEvent e) {
                int columns2 = Math.min(TableDiffViewer.this.getEditor1().getDataGrid().getVisibleColumnCount(), TableDiffViewer.this.getEditor2().getDataGrid().getVisibleColumnCount());
                SpinnerNumberModel model = (SpinnerNumberModel)this.myField.getModel();
                if (!model.getMaximum().equals(columns2)) {
                    if (((Number)model.getValue()).intValue() > columns2) {
                        model.setValue(columns2);
                    }
                    model.setMaximum(Integer.valueOf(columns2));
                }
                super.update(e);
            }

            @Override
            public Object getValue() {
                return ((TableDiffViewer)TableDiffViewer.this).mySettings.columnMismatchThreshold;
            }

            @Override
            public void setValue(Object value) {
                Number val = (Number)value;
                ((TableDiffViewer)TableDiffViewer.this).mySettings.columnMismatchThreshold = val.intValue();
                TableDiffViewer.this.rediff();
            }
        });
        return actions;
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/diff/TableDiffViewer", "canShowRequest"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/database/diff/TableDiffViewer", "canShowRequest"));
        }
        return TwosideDiffViewer.canShowRequest((DiffContext)context, (DiffRequest)request, (EditorHolderFactory)TableEditorHolder.TableEditorHolderFactory.INSTANCE);
    }

    protected void onInit() {
        super.onInit();
        GridScrollPane scrollPane = (GridScrollPane)((Object)ObjectUtils.tryCast((Object)this.getEditor1().getDataGrid().getScrollPane(), GridScrollPane.class));
        if (scrollPane != null) {
            scrollPane.setFlipControls(true);
        }
        MyDividerPainter painter = new MyDividerPainter();
        this.myContentPanel.setPainter((DiffSplitter.Painter)painter);
        this.myScrollListener = new VisibleAreaListener(){

            public void visibleAreaChanged(VisibleAreaEvent e) {
                TableDiffViewer.this.mySyncScrollListener.visibleAreaChanged(e);
                TableDiffViewer.this.myContentPanel.repaint();
            }
        };
        this.getEditor1().getScrollingModel().addVisibleAreaListener(this.myScrollListener);
        this.getEditor2().getScrollingModel().addVisibleAreaListener(this.myScrollListener);
        this.getEditor1().getDataGrid().addDataGridListener(new MyDataGridListener(), (Disposable)this.getEditor1());
        this.getEditor2().getDataGrid().addDataGridListener(new MyDataGridListener(), (Disposable)this.getEditor2());
    }

    public void onDispose() {
        this.getEditor1().getScrollingModel().removeVisibleAreaListener(this.myScrollListener);
        this.getEditor2().getScrollingModel().removeVisibleAreaListener(this.myScrollListener);
        super.onDispose();
    }

    protected void onSlowRediff() {
        super.onSlowRediff();
        this.myStatusPanel.setBusy(true);
    }

    @NotNull
    protected Runnable performRediff(@NotNull ProgressIndicator indicator) {
        Runnable runnable;
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/diff/TableDiffViewer", "performRediff"));
        }
        try {
            indicator.checkCanceled();
            TableDiffEditor.DiffTablePanel g1 = this.getEditor1().getDataGrid();
            TableDiffEditor.DiffTablePanel g2 = this.getEditor2().getDataGrid();
            TableDiffBuilder.TableDiffResult diffResult = TableDiffAdapter.process(g1, g1.getInactiveRows(), g1.getInactiveCols(), g2, g2.getInactiveRows(), g2.getInactiveCols(), this.mySettings, indicator);
            runnable = () -> {
                this.clearDiffPresentation();
                if (diffResult.isEqual()) {
                    this.myPanel.addNotification((JComponent)DiffNotifications.createEqualContents());
                }
                this.myFuzzyRowDifferences = diffResult.rowDiff;
                this.myCellDifferences = diffResult.cellDiff;
                TableDiffEditor.DiffTablePanel g11 = this.getEditor1().getDataGrid();
                TableDiffEditor.DiffTablePanel g21 = this.getEditor2().getDataGrid();
                for (Pair<TableDiffBuilder.RowDiffRange, Boolean> pair : this.myFuzzyRowDifferences) {
                    CellAttributesKey attributes1;
                    TableDiffBuilder.RowDiffRange diff = (TableDiffBuilder.RowDiffRange)pair.first;
                    CellAttributesKey cellAttributesKey = (Boolean)pair.second != false ? CellColors.FM_MATCHED : (attributes1 = TableDiffViewer.getAttributeKeys(diff.getType(), diff.begin1 == diff.end1));
                    CellAttributesKey attributes2 = (Boolean)pair.second != false ? CellColors.FM_MATCHED : TableDiffViewer.getAttributeKeys(diff.getType(), diff.begin2 == diff.end2);
                    g11.highlightRowOrCol(diff.begin1, diff.end1, attributes1, true);
                    g21.highlightRowOrCol(diff.begin2, diff.end2, attributes2, true);
                }
                for (TableDiffBuilder.CellDiff diff : this.myCellDifferences) {
                    g11.highlightCell(diff.row1, diff.col1, CellColors.FM_MISMATCHED);
                    g21.highlightCell(diff.row2, diff.col2, CellColors.FM_MISMATCHED);
                }
                g11.highlightRowsOrCols(diffResult.skippedCols1, CellColors.EXCLUDE_COLUMN, false);
                g21.highlightRowsOrCols(diffResult.skippedCols2, CellColors.EXCLUDE_COLUMN, false);
                g11.highlightRowsOrCols(diffResult.skippedRows1, CellColors.EXCLUDE_COLUMN, true);
                g21.highlightRowsOrCols(diffResult.skippedRows2, CellColors.EXCLUDE_COLUMN, true);
                this.getComponent().repaint();
            };
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            Runnable runnable2 = () -> {
                this.clearDiffPresentation();
                this.myPanel.addNotification((JComponent)DiffNotifications.createError());
            };
            if (runnable2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/TableDiffViewer", "performRediff"));
            }
            return runnable2;
        }
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/TableDiffViewer", "performRediff"));
        }
        return runnable;
    }

    private void clearDiffPresentation() {
        this.myStatusPanel.setBusy(false);
        this.myPanel.resetNotifications();
        this.myFuzzyRowDifferences = Collections.emptyList();
        this.myCellDifferences = Collections.emptyList();
        this.getEditor1().getDataGrid().clearHighlighting();
        this.getEditor2().getDataGrid().clearHighlighting();
    }

    @NotNull
    protected JComponent getStatusPanel() {
        StatusPanel statusPanel = this.myStatusPanel;
        if (statusPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/TableDiffViewer", "getStatusPanel"));
        }
        return statusPanel;
    }

    @Nullable
    TableDiffEditor getCurrentEditor() {
        return ((TableEditorHolder)this.getCurrentEditorHolder()).getEditor();
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return "reference.dialogs.diff.table";
        }
        if (DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE.is(dataId)) {
            return this.myPrevNextDifferenceIterable;
        }
        return super.getData(dataId);
    }

    @NotNull
    public static CellAttributesKey getAttributeKeys(TableDiffBuilder.DiffType type, boolean underlined) {
        if (type == TableDiffBuilder.DiffType.INSERT) {
            CellAttributesKey cellAttributesKey = underlined ? CellColors.INSERT_UNDERLINED : CellColors.INSERT;
            if (cellAttributesKey == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/TableDiffViewer", "getAttributeKeys"));
            }
            return cellAttributesKey;
        }
        if (type == TableDiffBuilder.DiffType.REMOVE) {
            CellAttributesKey cellAttributesKey = underlined ? CellColors.REMOVE_UNDERLINED : CellColors.REMOVE;
            if (cellAttributesKey == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/TableDiffViewer", "getAttributeKeys"));
            }
            return cellAttributesKey;
        }
        CellAttributesKey cellAttributesKey = underlined ? CellColors.REPLACE_UNDERLINED : CellColors.REPLACE;
        if (cellAttributesKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/TableDiffViewer", "getAttributeKeys"));
        }
        return cellAttributesKey;
    }

    private class MyDataGridListener
    implements DataGridListener {
        private boolean myUpdating;

        private MyDataGridListener() {
        }

        @Override
        public void onSelectionChanged(DataGrid dataGrid) {
        }

        @Override
        public void onContentChanged(DataGrid dataGrid) {
            if (this.myUpdating) {
                return;
            }
            DbUIUtil.invokeLater(() -> {
                try {
                    this.myUpdating = true;
                    ((TableDiffEditor.DiffTablePanel)dataGrid).updateStates();
                }
                finally {
                    this.myUpdating = false;
                }
                TableDiffViewer.this.myAlarm.addRequest(() -> ((TableDiffViewer)TableDiffViewer.this).rediff(), 500);
            });
        }
    }

    private class MyPrevNextDifferenceIterable
    implements PrevNextDifferenceIterable {
        private MyPrevNextDifferenceIterable() {
        }

        private int getCurrentRow() {
            TableDiffEditor editor = TableDiffViewer.this.getCurrentEditor();
            if (editor == null) {
                return -1;
            }
            ViewIndex<DataConsumer.Row> row = editor.getDataGrid().getSelectionModel().getSelectedRow().toView(editor.getDataGrid());
            return row.isValid(editor.getDataGrid()) ? row.asInteger() : 0;
        }

        private void setCurrentRow(int row) {
            TableDiffEditor editor = TableDiffViewer.this.getCurrentEditor();
            if (editor == null) {
                return;
            }
            row = Math.min(row, editor.getDataGrid().getVisibleRows().size() - 1);
            editor.getDataGrid().getSelectionModel().setRowSelection(ViewIndex.forRow(editor.getDataGrid(), row).toModel(editor.getDataGrid()));
            editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        }

        private int getNumberOfRows() {
            TableDiffEditor editor = TableDiffViewer.this.getCurrentEditor();
            if (editor == null) {
                return 0;
            }
            return editor.getDataGrid().getVisibleRows().size();
        }

        public boolean canGoNext() {
            int row = this.getCurrentRow();
            if (row == -1 || row >= this.getNumberOfRows() - 1) {
                return false;
            }
            TableDiffBuilder.RowDiffRange diff = this.getLastMismatch();
            return diff != null && TableDiffViewer.this.getCurrentSide().select(diff.begin1, diff.begin2) > row;
        }

        public void goNext() {
            int row = this.getCurrentRow();
            int nextRow = -1;
            for (Pair pair : TableDiffViewer.this.myFuzzyRowDifferences) {
                if (((Boolean)pair.second).booleanValue()) continue;
                TableDiffBuilder.RowDiffRange diff = (TableDiffBuilder.RowDiffRange)pair.first;
                int currentRow = TableDiffViewer.this.getCurrentSide().select(diff.begin1, diff.begin2);
                if (currentRow <= row) continue;
                nextRow = currentRow;
                break;
            }
            if (nextRow != -1) {
                this.setCurrentRow(nextRow);
            }
        }

        @Nullable
        private TableDiffBuilder.RowDiffRange getLastMismatch() {
            for (int i2 = TableDiffViewer.this.myFuzzyRowDifferences.size() - 1; i2 >= 0; --i2) {
                Pair pair = (Pair)TableDiffViewer.this.myFuzzyRowDifferences.get(i2);
                if (((Boolean)pair.second).booleanValue()) continue;
                return (TableDiffBuilder.RowDiffRange)pair.first;
            }
            return null;
        }

        public boolean canGoPrev() {
            if (TableDiffViewer.this.myFuzzyRowDifferences.isEmpty()) {
                return false;
            }
            int row = this.getCurrentRow();
            if (row == -1) {
                return false;
            }
            TableDiffBuilder.RowDiffRange diff = this.getLastMismatch();
            return diff != null && TableDiffViewer.this.getCurrentSide().select(diff.end1, diff.end2) < row;
        }

        public void goPrev() {
            int row = this.getCurrentRow();
            int prevRow = -1;
            boolean found = false;
            for (Pair pair : TableDiffViewer.this.myFuzzyRowDifferences) {
                if (((Boolean)pair.second).booleanValue()) continue;
                TableDiffBuilder.RowDiffRange diff = (TableDiffBuilder.RowDiffRange)pair.first;
                int currentRowEnd = TableDiffViewer.this.getCurrentSide().select(diff.end1, diff.end2);
                if (currentRowEnd > row) {
                    found = true;
                    break;
                }
                prevRow = TableDiffViewer.this.getCurrentSide().select(diff.begin1, diff.begin2);
            }
            if (found) {
                this.setCurrentRow(prevRow);
            }
        }
    }

    private class MyDividerPainter
    implements DiffSplitter.Painter,
    TableDiffDividerDrawUtil.DividerPaintable {
        private final DiffSupport[] myDiffSupports;

        MyDividerPainter() {
            this.myDiffSupports = new DiffSupport[]{new TableDiffSupport(TableDiffViewer.this.getEditor1()), new TableDiffSupport(TableDiffViewer.this.getEditor2())};
        }

        public void paint(@NotNull Graphics g, @NotNull JComponent divider) {
            if (g == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/database/diff/TableDiffViewer$MyDividerPainter", "paint"));
            }
            if (divider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "divider", "com/intellij/database/diff/TableDiffViewer$MyDividerPainter", "paint"));
            }
            Graphics2D gg = DiffDividerDrawUtil.getDividerGraphics((Graphics)g, (Component)divider, (Component)TableDiffViewer.this.getEditor1().getComponent());
            gg.setColor(DiffDrawUtil.getDividerColorFromScheme((EditorColorsScheme)this.myDiffSupports[0].getEditorColorsScheme()));
            gg.fill(gg.getClipBounds());
            TableDiffDividerDrawUtil.paintPolygons(gg, divider.getWidth(), this.myDiffSupports[0], this.myDiffSupports[1], this);
            gg.dispose();
        }

        @Override
        public void process(@NotNull TableDiffDividerDrawUtil.DividerPaintable.Handler handler) {
            if (handler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/database/diff/TableDiffViewer$MyDividerPainter", "process"));
            }
            GridColorsScheme scheme = TableDiffViewer.this.getEditor1().getDataGrid().getColorsScheme();
            for (Pair pair : TableDiffViewer.this.myFuzzyRowDifferences) {
                TableDiffBuilder.RowDiffRange rg = (TableDiffBuilder.RowDiffRange)pair.first;
                CellAttributes attrs = scheme.getAttributes((Boolean)pair.second != false ? CellColors.FM_MATCHED : TableDiffViewer.getAttributeKeys(rg.getType(), false));
                Color bg = (Color)ObjectUtils.chooseNotNull((Object)attrs.getBackgroundColor(), (Object)JBColor.WHITE);
                if (handler.process(rg.begin1, rg.end1, rg.begin2, rg.end2, bg)) continue;
                return;
            }
        }
    }

    private class MySyncScrollable
    extends BaseSyncScrollable {
        private MySyncScrollable() {
        }

        public boolean isSyncScrollEnabled() {
            return true;
        }

        public int transfer(@NotNull Side side, int line) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/database/diff/TableDiffViewer$MySyncScrollable", "transfer"));
            }
            if (TableDiffViewer.this.myFuzzyRowDifferences.isEmpty()) {
                return line;
            }
            return super.transfer(side, line);
        }

        protected void processHelper(@NotNull BaseSyncScrollable.ScrollHelper helper) {
            if (helper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/database/diff/TableDiffViewer$MySyncScrollable", "processHelper"));
            }
            if (!helper.process(0, 0)) {
                return;
            }
            for (Pair pair : TableDiffViewer.this.myFuzzyRowDifferences) {
                if (((Boolean)pair.second).booleanValue()) continue;
                TableDiffBuilder.RowDiffRange diff = (TableDiffBuilder.RowDiffRange)pair.first;
                if (!helper.process(diff.begin1, diff.begin2)) {
                    return;
                }
                if (helper.process(diff.end1, diff.end2)) continue;
                return;
            }
            GridModel<DataConsumer.Row, DataConsumer.Column> model1 = TableDiffViewer.this.getEditor1().getDataGrid().getDataModel(DataAccessType.DATABASE_DATA);
            GridModel<DataConsumer.Row, DataConsumer.Column> model2 = TableDiffViewer.this.getEditor2().getDataGrid().getDataModel(DataAccessType.DATABASE_DATA);
            helper.process(model1.getRowCount(), model2.getRowCount());
        }
    }
}

