/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.extractors.CustomSeparatedExtractor;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.JdbcUtil;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.TIntObjectHashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtractorsUtil {
    private ExtractorsUtil() {
    }

    @NotNull
    public static String getPresentableSize(long length) {
        String string = StringUtil.formatFileSize((long)length);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/ExtractorsUtil", "getPresentableSize"));
        }
        return string;
    }

    public static int guessJdbcType(@NotNull DataConsumer.Column column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/extractors/ExtractorsUtil", "guessJdbcType"));
        }
        if (column.type != 1111) {
            return column.type;
        }
        int byType = JdbcUtil.guessJdbcTypeByName((String)column.typeName);
        if (byType == -6 && column.clazz.equals("java.lang.Boolean")) {
            return 16;
        }
        if (byType != 0 || column.clazz == null) {
            return byType;
        }
        if (column.clazz.equals("java.lang.Boolean")) {
            return 16;
        }
        if (column.clazz.equals("java.lang.String")) {
            return 12;
        }
        if (column.clazz.equals("java.lang.Integer")) {
            return 4;
        }
        if (column.clazz.equals("java.lang.Double")) {
            return 8;
        }
        if (column.clazz.equals("java.lang.Float")) {
            return 6;
        }
        if (column.clazz.endsWith(".Date")) {
            return 91;
        }
        if (column.clazz.endsWith(".Time")) {
            return 92;
        }
        if (column.clazz.endsWith(".Timestamp")) {
            return 93;
        }
        if (column.clazz.endsWith(".UUID")) {
            return 12;
        }
        return byType;
    }

    @NotNull
    public static CharOut extract(@NotNull CharOut out, DatabaseDialectEx dialect, boolean forceSkipHeader, List<DataConsumer.Column> allColumns, DataExtractor extractor, List<DataConsumer.Row> rows, int ... selectedColumns) {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/database/extractors/ExtractorsUtil", "extract"));
        }
        DataExtractor.Extraction e = extractor.startExtraction(out, dialect, forceSkipHeader, allColumns, selectedColumns);
        e.addData(rows);
        e.complete();
        CharOut charOut = out;
        if (charOut == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/ExtractorsUtil", "extract"));
        }
        return charOut;
    }

    public static DataExtractor getSingleValueExtractor(@NotNull ObjectFormatter converter) {
        if (converter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converter", "com/intellij/database/extractors/ExtractorsUtil", "getSingleValueExtractor"));
        }
        return new CustomSeparatedExtractor(converter){

            @Override
            protected boolean isStringLiteral(@NotNull DatabaseDialect dialect, @NotNull String value, @Nullable DataConsumer.Row row, @Nullable DataConsumer.Column column) {
                if (dialect == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/extractors/ExtractorsUtil$1", "isStringLiteral"));
                }
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/extractors/ExtractorsUtil$1", "isStringLiteral"));
                }
                return false;
            }
        };
    }

    static TIntObjectHashMap<DataConsumer.Column> getColumnNumsToColumnsMapping(@NotNull List<DataConsumer.Column> columns2) {
        if (columns2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/extractors/ExtractorsUtil", "getColumnNumsToColumnsMapping"));
        }
        TIntObjectHashMap m = new TIntObjectHashMap(columns2.size());
        for (DataConsumer.Column column : columns2) {
            m.put(column.columnNum, (Object)column);
        }
        return m;
    }

    static int[] getNonEmptySelection(@NotNull List<DataConsumer.Column> allColumns, int[] providedSelection) {
        if (allColumns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allColumns", "com/intellij/database/extractors/ExtractorsUtil", "getNonEmptySelection"));
        }
        if (providedSelection.length != 0) {
            return providedSelection;
        }
        int[] selection = new int[allColumns.size()];
        for (int i2 = 0; i2 < allColumns.size(); ++i2) {
            selection[i2] = allColumns.get((int)i2).columnNum;
        }
        return selection;
    }
}

