/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.TranspositionAwareDefaultExtractor;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.CharOut;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlValuesExtractor
extends TranspositionAwareDefaultExtractor<DatabaseSettings.StdState> {
    public HtmlValuesExtractor(ObjectFormatter converter) {
        this(new DatabaseSettings.StdState(), converter);
    }

    public HtmlValuesExtractor(DatabaseSettings.StdState state, ObjectFormatter converter) {
        super(state, converter);
    }

    @NotNull
    public String getDataPrefix() {
        if ("<table border=\"1\" style=\"border-collapse:collapse\">" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/HtmlValuesExtractor", "getDataPrefix"));
        }
        return "<table border=\"1\" style=\"border-collapse:collapse\">";
    }

    @NotNull
    public String getDataSuffix() {
        if ("</table>" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/HtmlValuesExtractor", "getDataSuffix"));
        }
        return "</table>";
    }

    @Override
    @NotNull
    public String getLinePrefix() {
        if ("<tr>" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/HtmlValuesExtractor", "getLinePrefix"));
        }
        return "<tr>";
    }

    @Override
    @NotNull
    public String getLineSuffix() {
        if ("</tr>" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/HtmlValuesExtractor", "getLineSuffix"));
        }
        return "</tr>";
    }

    @Override
    @NotNull
    public String getValuePrefix() {
        if ("<td>" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/HtmlValuesExtractor", "getValuePrefix"));
        }
        return "<td>";
    }

    @Override
    @NotNull
    public String getValueSuffix() {
        if ("</td>" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/HtmlValuesExtractor", "getValueSuffix"));
        }
        return "</td>";
    }

    @Override
    public String getColumnName(DataConsumer.Column column) {
        return "<th>" + column.name + "</th>";
    }

    @Override
    public String getValueSeparator() {
        return "";
    }

    @Override
    @Nullable
    protected String getValueAsString(@NotNull DataConsumer.Row row, @NotNull DataConsumer.Column column, @NotNull DatabaseDialect dialect, boolean forDisplay) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/extractors/HtmlValuesExtractor", "getValueAsString"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/extractors/HtmlValuesExtractor", "getValueAsString"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/extractors/HtmlValuesExtractor", "getValueAsString"));
        }
        return this.getValueAsString(row, column, dialect, forDisplay, true);
    }

    @Nullable
    protected String getValueAsString(@NotNull DataConsumer.Row row, @NotNull DataConsumer.Column column, @NotNull DatabaseDialect dialect, boolean forDisplay, boolean escape) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/extractors/HtmlValuesExtractor", "getValueAsString"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/extractors/HtmlValuesExtractor", "getValueAsString"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/extractors/HtmlValuesExtractor", "getValueAsString"));
        }
        String repr = super.getValueAsString(row, column, dialect, forDisplay);
        return escape ? this.escapeChars(repr) : repr;
    }

    @Nullable
    protected String escapeChars(@Nullable String s) {
        return s != null ? StringUtil.escapeXml((String)s.replaceAll("\t|\b|\\f", "")).replaceAll("\\r|\\n|\\r\\n", "<br/>") : null;
    }

    @Override
    @NotNull
    public String getFileExtension() {
        if ("html" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/HtmlValuesExtractor", "getFileExtension"));
        }
        return "html";
    }

    @Override
    protected TranspositionAwareDefaultExtractor.TranspositionAwareExtractionBase startExtraction(CharOut out, DatabaseDialectEx dialect, boolean forceSkipHeader, boolean transposedMode, List<DataConsumer.Column> allColumns, int ... selectedColumns) {
        return new HtmlExtraction(out, dialect, forceSkipHeader, transposedMode, allColumns, selectedColumns);
    }

    protected class HtmlExtraction
    extends TranspositionAwareDefaultExtractor.TranspositionAwareExtractionBase {
        public HtmlExtraction(CharOut output, DatabaseDialectEx dialect, boolean forceSkipHeader, boolean transpose, List<DataConsumer.Column> allColumns, int[] selectedColumnIndices) {
            super(HtmlValuesExtractor.this, output, dialect, forceSkipHeader, transpose, allColumns, selectedColumnIndices);
        }

        @Override
        protected void doAppendHeader(boolean appendNewLine) {
            this.myOutput.append("<!DOCTYPE html>\n<html>\n<head>\n  <title></title>\n</head>\n<body>\n").append(HtmlValuesExtractor.this.getDataPrefix()).append("\n");
            super.doAppendHeader(appendNewLine);
        }

        @Override
        protected void doAppendFooter() {
            this.myOutput.append(HtmlValuesExtractor.this.getDataSuffix()).append("\n</body>\n</html>");
        }
    }
}

