/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.intellij.database.introspection.IntrospectionScope;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IntrospectionScopes {
    @NotNull
    public static IntrospectionScope scopeOf(@NotNull Collection<Couple<String>> databasesAndSchemas) {
        if (databasesAndSchemas == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databasesAndSchemas", "com/intellij/database/introspection/IntrospectionScopes", "scopeOf"));
        }
        IntrospectionScope introspectionScope = IntrospectionScopes.scopeOf(IntrospectionScopes.pairsToMap(databasesAndSchemas));
        if (introspectionScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/IntrospectionScopes", "scopeOf"));
        }
        return introspectionScope;
    }

    @NotNull
    private static MultiMap<String, String> pairsToMap(@NotNull Collection<Couple<String>> databasesAndSchemas) {
        if (databasesAndSchemas == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databasesAndSchemas", "com/intellij/database/introspection/IntrospectionScopes", "pairsToMap"));
        }
        MultiMap result2 = MultiMap.create();
        for (Pair p : ContainerUtil.sorted(databasesAndSchemas, (a, b) -> Comparing.compare((Comparable)((Comparable)a.second), (Comparable)((Comparable)b.second)))) {
            result2.putValue(p.first, p.second);
        }
        MultiMap multiMap = result2;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/IntrospectionScopes", "pairsToMap"));
        }
        return multiMap;
    }

    @NotNull
    public static IntrospectionScope collapse(@NotNull MultiMap<String, String> databasesAndSchemas) {
        if (databasesAndSchemas == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databasesAndSchemas", "com/intellij/database/introspection/IntrospectionScopes", "collapse"));
        }
        if (databasesAndSchemas.get((Object)"*").contains("*")) {
            IntrospectionScope introspectionScope = IntrospectionScope.ALL_SCOPE;
            if (introspectionScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/IntrospectionScopes", "collapse"));
            }
            return introspectionScope;
        }
        for (String d : databasesAndSchemas.keySet()) {
            if (!databasesAndSchemas.get((Object)d).contains("*")) continue;
            Collection modifiable = databasesAndSchemas.getModifiable((Object)d);
            modifiable.clear();
            modifiable.add("*");
        }
        IntrospectionScope introspectionScope = IntrospectionScopes.scopeOf(databasesAndSchemas);
        if (introspectionScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/IntrospectionScopes", "collapse"));
        }
        return introspectionScope;
    }

    @NotNull
    public static IntrospectionScope scopeOf(@NotNull MultiMap<String, String> databasesAndSchemas) {
        if (databasesAndSchemas == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databasesAndSchemas", "com/intellij/database/introspection/IntrospectionScopes", "scopeOf"));
        }
        Set databases = databasesAndSchemas.keySet();
        if (databases.size() == 1) {
            String database = (String)databases.iterator().next();
            Collection schemas = databasesAndSchemas.get((Object)database);
            IntrospectionScope introspectionScope = schemas.contains("*") ? IntrospectionScope.scopeOf(database, "*") : IntrospectionScope.scopeOf(database, schemas);
            if (introspectionScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/IntrospectionScopes", "scopeOf"));
            }
            return introspectionScope;
        }
        ImmutableMap.Builder b = ImmutableMap.builder();
        Iterator iterator = databases.iterator();
        while (iterator.hasNext()) {
            String database;
            Collection schemas = databasesAndSchemas.get((Object)(database = (String)iterator.next()));
            b.put((Object)database, (Object)(schemas.size() > 1 && schemas.contains("*") ? ImmutableSet.of((Object)"*") : ImmutableSet.copyOf((Collection)schemas)));
        }
        IntrospectionScope introspectionScope = IntrospectionScope.scopeOf((ImmutableMap<String, ImmutableSet<String>>)b.build());
        if (introspectionScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/IntrospectionScopes", "scopeOf"));
        }
        return introspectionScope;
    }

    @NotNull
    @Contract(pure=true)
    public static IntrospectionScope importScope(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/database/introspection/IntrospectionScopes", "importScope"));
        }
        if (string.isEmpty()) {
            IntrospectionScope introspectionScope = IntrospectionScope.EMPTY_SCOPE;
            if (introspectionScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/IntrospectionScopes", "importScope"));
            }
            return introspectionScope;
        }
        if (string.equals("@") || string.equals("@:@")) {
            IntrospectionScope introspectionScope = IntrospectionScope.CURRENT_SCOPE;
            if (introspectionScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/IntrospectionScopes", "importScope"));
            }
            return introspectionScope;
        }
        if (string.equals("*") || string.equals("*:*")) {
            IntrospectionScope introspectionScope = IntrospectionScope.ALL_SCOPE;
            if (introspectionScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/IntrospectionScopes", "importScope"));
            }
            return introspectionScope;
        }
        IntrospectionScope introspectionScope = IntrospectionScope.importState(string);
        if (introspectionScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/IntrospectionScopes", "importScope"));
        }
        return introspectionScope;
    }

    @NotNull
    public static IntrospectionScope fromSchemaPattern(@Nullable String schemaPattern) {
        if (StringUtil.isEmpty((String)schemaPattern)) {
            IntrospectionScope introspectionScope = IntrospectionScope.EMPTY_SCOPE;
            if (introspectionScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/IntrospectionScopes", "fromSchemaPattern"));
            }
            return introspectionScope;
        }
        String[] strings = IntrospectionScopes.splitSchemaPattern(schemaPattern);
        ArrayList list = ContainerUtil.newArrayListWithCapacity((int)strings.length);
        for (String string : strings) {
            if ("*".equals(string)) {
                IntrospectionScope introspectionScope = IntrospectionScope.ALL_SCOPE;
                if (introspectionScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/IntrospectionScopes", "fromSchemaPattern"));
                }
                return introspectionScope;
            }
            List split = StringUtil.split((String)string, (String)".");
            if (split.size() == 1) {
                split.add(string.startsWith(".") ? 0 : 1, "");
            }
            if (split.size() != 2) continue;
            list.add(Couple.of(split.get(0), split.get(1)));
        }
        IntrospectionScope introspectionScope = IntrospectionScopes.scopeOf(list);
        if (introspectionScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/IntrospectionScopes", "fromSchemaPattern"));
        }
        return introspectionScope;
    }

    @NotNull
    public static IntrospectionScope invertIf(@NotNull IntrospectionScope scope, boolean invert) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/database/introspection/IntrospectionScopes", "invertIf"));
        }
        if (!invert) {
            IntrospectionScope introspectionScope = scope;
            if (introspectionScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/IntrospectionScopes", "invertIf"));
            }
            return introspectionScope;
        }
        if (scope.isEmpty()) {
            IntrospectionScope introspectionScope = IntrospectionScope.EMPTY_SCOPE;
            if (introspectionScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/IntrospectionScopes", "invertIf"));
            }
            return introspectionScope;
        }
        if (scope == IntrospectionScope.ALL_SCOPE) {
            IntrospectionScope introspectionScope = IntrospectionScope.ALL_SCOPE;
            if (introspectionScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/IntrospectionScopes", "invertIf"));
            }
            return introspectionScope;
        }
        Set<String> all = scope.allSchemas();
        if (all.size() != 1 || !all.contains("*")) {
            IntrospectionScope introspectionScope = scope;
            if (introspectionScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/IntrospectionScopes", "invertIf"));
            }
            return introspectionScope;
        }
        IntrospectionScope introspectionScope = IntrospectionScope.scopeOf("*", (Collection<String>)ImmutableSet.copyOf(scope.databases()));
        if (introspectionScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/IntrospectionScopes", "invertIf"));
        }
        return introspectionScope;
    }

    @NotNull
    public static String[] splitSchemaPattern(@NotNull String schemaPattern) {
        String[] stringArray;
        if (schemaPattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaPattern", "com/intellij/database/introspection/IntrospectionScopes", "splitSchemaPattern"));
        }
        if (StringUtil.isEmptyOrSpaces((String)schemaPattern)) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "*";
        } else {
            stringArray = schemaPattern.split("[\\s,]+");
        }
        String[] strings = stringArray;
        for (int i2 = 0; i2 < strings.length; ++i2) {
            strings[i2] = strings[i2].replaceAll("&nbsp;", " ").replaceAll("&amp;", "&");
        }
        if (strings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/IntrospectionScopes", "splitSchemaPattern"));
        }
        return strings;
    }

    public static IntrospectionScope union(IntrospectionScope s1, IntrospectionScope s2) {
        MultiMap map = MultiMap.createLinkedSet();
        for (String db : s1.databases()) {
            map.getModifiable((Object)db).addAll(s1.schemas(db));
        }
        boolean added = false;
        for (String db : s2.databases()) {
            added |= !map.containsKey((Object)db);
            added |= map.getModifiable((Object)db).addAll(s2.schemas(db));
        }
        return added ? IntrospectionScopes.scopeOf((MultiMap<String, String>)map) : s1;
    }
}

