/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.database.introspection.BaseIntrospectionFunctions;
import com.intellij.database.introspection.BaseIntrospector;
import com.intellij.database.introspection.BaseMultiDatabaseIntrospector;
import com.intellij.database.introspection.CollectionAggregator;
import com.intellij.database.introspection.ForeignKeyInfo;
import com.intellij.database.introspection.LongIdName;
import com.intellij.database.introspection.MsIntroQueries;
import com.intellij.database.introspection.MsIntrospectionException;
import com.intellij.database.introspection.MsIntrospector;
import com.intellij.database.introspection.MsIntrospector$MsSchemaRetriever$retrieveSources$;
import com.intellij.database.introspection.MsIntrospectorKt;
import com.intellij.database.introspection.MsMinorIdentity;
import com.intellij.database.introspection.MsRoutineTypes;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModArrangedElement;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.ModIdentifyingFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.mssql.MsDatabase;
import com.intellij.database.model.mssql.MsKey;
import com.intellij.database.model.mssql.MsLikeTable;
import com.intellij.database.model.mssql.MsModAliasType;
import com.intellij.database.model.mssql.MsModArgument;
import com.intellij.database.model.mssql.MsModCheck;
import com.intellij.database.model.mssql.MsModDatabase;
import com.intellij.database.model.mssql.MsModForeignKey;
import com.intellij.database.model.mssql.MsModIndex;
import com.intellij.database.model.mssql.MsModKey;
import com.intellij.database.model.mssql.MsModLikeColumn;
import com.intellij.database.model.mssql.MsModLikeMajorTable;
import com.intellij.database.model.mssql.MsModLikeStoredColumn;
import com.intellij.database.model.mssql.MsModLikeTable;
import com.intellij.database.model.mssql.MsModModel;
import com.intellij.database.model.mssql.MsModRoot;
import com.intellij.database.model.mssql.MsModRoutine;
import com.intellij.database.model.mssql.MsModSchema;
import com.intellij.database.model.mssql.MsModSchemaObject;
import com.intellij.database.model.mssql.MsModSourceAware;
import com.intellij.database.model.mssql.MsModSynonym;
import com.intellij.database.model.mssql.MsModTable;
import com.intellij.database.model.mssql.MsModTableType;
import com.intellij.database.model.mssql.MsModTrigger;
import com.intellij.database.model.mssql.MsModView;
import com.intellij.database.model.mssql.MsRoutine;
import com.intellij.database.model.mssql.MsSchema;
import com.intellij.database.model.mssql.MsTable;
import com.intellij.database.model.properties.MsRoutineType;
import com.intellij.database.model.properties.MsServerType;
import com.intellij.database.model.properties.TrigTurn;
import com.intellij.database.queryRewriting.QueryRewriters;
import com.intellij.database.scripting.CompositeText;
import gnu.trove.TIntHashSet;
import gnu.trove.TLongHashSet;
import gnu.trove.TLongObjectHashMap;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.Mssql;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.core.DBTransaction;
import org.jetbrains.dekaf.core.Layouts;
import org.jetbrains.dekaf.sql.SqlQuery;
import org.jetbrains.dekaf.util.StringOperator;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002&\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0001:\u0003\"#$B\u0005\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\u0010\u001a\u00060\u0011R\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004H\u0014J\u001c\u0010\u0015\u001a\u00060\u0016R\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0005H\u0014J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u001a\u001a\u00020\u0019H\u0014J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000bH\u0014J\u0010\u0010 \u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0004H\u0014J\u0010\u0010!\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0013H\u0014R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/database/introspection/MsIntrospector;", "Lcom/intellij/database/introspection/BaseMultiDatabaseIntrospector;", "Lcom/intellij/database/model/mssql/MsModModel;", "Lcom/intellij/database/model/mssql/MsModRoot;", "Lcom/intellij/database/model/mssql/MsDatabase;", "Lcom/intellij/database/model/mssql/MsSchema;", "Lcom/intellij/database/model/mssql/MsModDatabase;", "Lcom/intellij/database/model/mssql/MsModSchema;", "()V", "databasesToReResolveForeignKeys", "Ljava/util/HashSet;", "Lcom/intellij/database/model/basic/BasicDatabase;", "myQueries", "Lcom/intellij/database/introspection/MsIntroQueries;", "myVer10", "", "createDatabaseRetriever", "Lcom/intellij/database/introspection/MsIntrospector$MsDatabaseRetriever;", "tran", "Lorg/jetbrains/dekaf/core/DBTransaction;", "database", "createSchemaRetriever", "Lcom/intellij/database/introspection/MsIntrospector$MsSchemaRetriever;", "schema", "getServerType", "", "initConnectionRelatedState", "introspectNamespacesInTran", "listDatabases", "", "Lcom/intellij/database/introspection/LongIdName;", "listSchemas", "postProcessDatabase", "retrieveSessionBriefInfo", "MsDatabaseRetriever", "MsSchemaRetriever", "VERSION", "database-introspection"})
public final class MsIntrospector
extends BaseMultiDatabaseIntrospector<MsModModel, MsModRoot, MsDatabase, MsSchema, MsModDatabase, MsModSchema> {
    private final MsIntroQueries myQueries;
    private boolean myVer10;
    private final HashSet<BasicDatabase> databasesToReResolveForeignKeys;

    @Override
    protected void initConnectionRelatedState() {
        super.initConnectionRelatedState();
        this.myVer10 = this.getServerVersion().isOrGreater(new int[]{10});
    }

    @NotNull
    protected MsDatabaseRetriever createDatabaseRetriever(@NotNull DBTransaction tran, @NotNull MsDatabase database) {
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        return new MsDatabaseRetriever(tran, database);
    }

    @NotNull
    protected MsSchemaRetriever createSchemaRetriever(@NotNull DBTransaction tran, @NotNull MsSchema schema) {
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        return new MsSchemaRetriever(tran, schema);
    }

    @Override
    protected void introspectNamespacesInTran(@NotNull DBTransaction tran) {
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        if (Intrinsics.areEqual((Object)((Object)((MsModModel)this.getModel()).getRoot().getServerType()), (Object)((Object)MsServerType.UNKNOWN))) {
            this.getServerType(tran);
        }
        super.introspectNamespacesInTran(tran);
    }

    private final void getServerType(DBTransaction tran) {
        String info;
        String string;
        String string2 = string = (info = (String)tran.query(this.myQueries.queryServerInfo).run());
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        MsServerType serverType = StringsKt.contains$default((CharSequence)string3, (CharSequence)"azure", (boolean)false, (int)2, null) ? MsServerType.AZURE : MsServerType.STANDALONE;
        MsIntrospector this_$iv = this;
        this_$iv.getModel().modify(BaseMultiDatabaseIntrospector.access$getModRootClass$p(this_$iv), new ModelModifier<MR>(serverType){
            final /* synthetic */ MsServerType $serverType$inlined;
            {
                this.$serverType$inlined = msServerType;
            }

            public final void perform(MR root2) {
                MR MR = root2;
                Intrinsics.checkExpressionValueIsNotNull(MR, (String)"root");
                MsModRoot root3 = (MsModRoot)MR;
                root3.setServerType(this.$serverType$inlined);
            }
        });
    }

    @Override
    protected void retrieveSessionBriefInfo(@NotNull DBTransaction tran) {
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        MsIntroQueries.CurrentSessionInfo currentSessionInfo = (MsIntroQueries.CurrentSessionInfo)tran.query(this.myQueries.queryCurrentSessionInfo).run();
        if (currentSessionInfo == null) {
            throw (Throwable)new MsIntrospectionException("Failed to obtain session info");
        }
        MsIntroQueries.CurrentSessionInfo sessionInfo = currentSessionInfo;
        MsIntrospector this_$iv = this;
        this_$iv.getModel().modify(BaseMultiDatabaseIntrospector.access$getModRootClass$p(this_$iv), new ModelModifier<MR>(sessionInfo){
            final /* synthetic */ MsIntroQueries.CurrentSessionInfo $sessionInfo$inlined;
            {
                this.$sessionInfo$inlined = currentSessionInfo;
            }

            public final void perform(MR root2) {
                MR MR = root2;
                Intrinsics.checkExpressionValueIsNotNull(MR, (String)"root");
                MsModRoot root3 = (MsModRoot)MR;
                root3.setServerType(this.$sessionInfo$inlined.is_azure ? MsServerType.AZURE : MsServerType.STANDALONE);
                MsModDatabase currentDatabase = (MsModDatabase)root3.getDatabases().renew(this.$sessionInfo$inlined.db_id, this.$sessionInfo$inlined.db_name);
                currentDatabase.setCollation(this.$sessionInfo$inlined.collation_name);
                currentDatabase.setCurrent(true);
                if (this.$sessionInfo$inlined.schema_name != null) {
                    MsModSchema currentSchema = (MsModSchema)currentDatabase.getSchemas().renew(this.$sessionInfo$inlined.schema_id, this.$sessionInfo$inlined.schema_name);
                    currentSchema.setCurrent(true);
                }
            }
        });
    }

    @Override
    @NotNull
    protected List<LongIdName> listDatabases(@NotNull DBTransaction tran) {
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        Object object = tran.query(this.myQueries.listDatabases).run();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"tran.query(myQueries.listDatabases).run()");
        return (List)object;
    }

    @Override
    @NotNull
    protected List<LongIdName> listSchemas(@NotNull DBTransaction tran, @NotNull BasicDatabase database) {
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        Object object = tran.query(this.myQueries.listSchemas.rewrite(new StringOperator(database){
            final /* synthetic */ BasicDatabase $database;

            @NotNull
            public final String apply(String it) {
                return StringsKt.replace$default((String)it, (String)"#CAT", (String)('[' + this.$database.getName() + "].sys"), (boolean)false, (int)4, null);
            }
            {
                this.$database = basicDatabase;
            }
        })).run();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"tran.query(myQueries.lis\u2026base.name}].sys\")}).run()");
        return (List)object;
    }

    @Override
    protected void postProcessDatabase(@NotNull MsDatabase database) {
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        if (this.databasesToReResolveForeignKeys.contains(database)) {
            Collection collection = this.databasesToReResolveForeignKeys;
            collection.remove(database);
            ((MsModModel)this.getModel()).modify(database, MsModDatabase.class, postProcessDatabase.1.INSTANCE);
        }
    }

    public MsIntrospector() {
        Rdbms rdbms = Mssql.RDBMS;
        Intrinsics.checkExpressionValueIsNotNull((Object)rdbms, (String)"Mssql.RDBMS");
        super(rdbms, MsModModel.class, MsModRoot.class, MsModDatabase.class, MsModSchema.class);
        MsIntroQueries msIntroQueries = MsIntroQueries.QUERIES;
        Intrinsics.checkExpressionValueIsNotNull((Object)msIntroQueries, (String)"MsIntroQueries.QUERIES");
        this.myQueries = msIntroQueries;
        this.databasesToReResolveForeignKeys = new HashSet();
    }

    public static final /* synthetic */ void access$setMyVer10$p(MsIntrospector $this, boolean bl) {
        $this.myVer10 = bl;
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0084\u0004\u0018\u00002*0\u0001R&\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0002B\u0017\b\u0010\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0014\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/introspection/MsIntrospector$MsDatabaseRetriever;", "Lcom/intellij/database/introspection/BaseMultiDatabaseIntrospector$DatabaseRetriever;", "Lcom/intellij/database/introspection/BaseMultiDatabaseIntrospector;", "Lcom/intellij/database/model/mssql/MsModModel;", "Lcom/intellij/database/model/mssql/MsModRoot;", "Lcom/intellij/database/model/mssql/MsDatabase;", "Lcom/intellij/database/model/mssql/MsSchema;", "Lcom/intellij/database/model/mssql/MsModDatabase;", "Lcom/intellij/database/model/mssql/MsModSchema;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "database", "(Lcom/intellij/database/introspection/MsIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;Lcom/intellij/database/model/mssql/MsDatabase;)V", "listSchemas", "", "Lcom/intellij/database/introspection/LongIdName;", "prepareParameters", "", "database-introspection"})
    protected final class MsDatabaseRetriever
    extends BaseMultiDatabaseIntrospector.DatabaseRetriever {
        @Override
        protected void prepareParameters() {
            this.setQueryParameter("CAT", MsIntrospectorKt.access$catalogPrefix((MsDatabase)this.getDatabase()));
            this.setQueryParameter("ISTABLETYPE", MsIntrospector.this.myVer10 ? "is_table_type" : "0");
        }

        @Override
        @NotNull
        protected List<LongIdName> listSchemas() {
            SqlQuery<List<LongIdName>> sqlQuery = ((MsIntrospector)MsIntrospector.this).myQueries.listSchemas;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.listSchemas");
            return this.performQuery(sqlQuery);
        }

        public MsDatabaseRetriever(@NotNull DBTransaction transaction, MsDatabase database) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
            super((BaseMultiDatabaseIntrospector)MsIntrospector.this, transaction, (BasicDatabase)database);
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u0084\u0004\u0018\u00002\u001e0\u0001R\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0002B\u0017\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0016H\u0014J\b\u0010\u0018\u001a\u00020\u0016H\u0014J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0016\u0010\u001c\u001a\u00020\u00162\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002J\u0016\u0010 \u001a\u00020\u00162\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001eH\u0002J$\u0010#\u001a\u00020\u00162\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u001e2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u001eH\u0002J\u0016\u0010(\u001a\u00020\u00162\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u001eH\u0002J\u0010\u0010+\u001a\u00020\u00162\u0006\u0010,\u001a\u00020\u001bH\u0002J\u0010\u0010-\u001a\u00020\u00162\u0006\u0010.\u001a\u00020/H\u0002J\u0018\u00100\u001a\u00020\u00162\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0002J\u0018\u00100\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\u00062\u0006\u00103\u001a\u000204H\u0002J\u0018\u00105\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\u00062\u0006\u00106\u001a\u000207H\u0002J\b\u00108\u001a\u00020\u0016H\u0002J\b\u00109\u001a\u00020\u0016H\u0002J\b\u0010:\u001a\u00020\u0016H\u0002J\b\u0010;\u001a\u00020\u0016H\u0002J\b\u0010<\u001a\u00020\u0016H\u0002J\b\u0010=\u001a\u00020\u0016H\u0002J\b\u0010>\u001a\u00020\u0016H\u0002J\b\u0010?\u001a\u00020\u0016H\u0002J\b\u0010@\u001a\u00020\u0016H\u0014J\b\u0010A\u001a\u00020\u0016H\u0014J\b\u0010B\u001a\u00020\u0016H\u0002J\b\u0010C\u001a\u00020\u0016H\u0002J\b\u0010D\u001a\u00020\u0016H\u0002J\b\u0010E\u001a\u00020\u0016H\u0002J\b\u0010F\u001a\u00020\u0016H\u0002J\b\u0010G\u001a\u00020\u0016H\u0002J\b\u0010H\u001a\u00020\u0016H\u0002J\b\u0010I\u001a\u00020\u0016H\u0002R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lcom/intellij/database/introspection/MsIntrospector$MsSchemaRetriever;", "Lcom/intellij/database/introspection/BaseIntrospector$SchemaRetriever;", "Lcom/intellij/database/introspection/BaseIntrospector;", "Lcom/intellij/database/model/mssql/MsModModel;", "Lcom/intellij/database/model/mssql/MsModRoot;", "Lcom/intellij/database/model/mssql/MsSchema;", "Lcom/intellij/database/model/mssql/MsModSchema;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "schema", "(Lcom/intellij/database/introspection/MsIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;Lcom/intellij/database/model/mssql/MsSchema;)V", "myTouchedRoutines", "Ljava/util/HashSet;", "Lcom/intellij/database/model/mssql/MsRoutine;", "myTouchedTables", "Ljava/util/ArrayList;", "Lcom/intellij/database/model/mssql/MsLikeTable;", "rewriter", "Lorg/jetbrains/dekaf/util/StringOperator;", "schemaId", "", "analyzeBriefInfo", "", "analyzeCurrentContent", "finishSchema", "processAliasTypes", "aliasTypesCheckSum", "", "processCheckConstraints", "cs", "", "Lcom/intellij/database/introspection/MsIntroQueries$OneCheckConstraints;", "processColumns", "cols", "Lcom/intellij/database/introspection/MsIntroQueries$OneColumn;", "processIndices", "inds", "Lcom/intellij/database/introspection/MsIntroQueries$OneIndex;", "ics", "Lcom/intellij/database/introspection/MsIntroQueries$OneIndexColumn;", "processKeys", "ks", "Lcom/intellij/database/introspection/MsIntroQueries$OneKey;", "processTableTypes", "tableTypesCheckSum", "progress", "what", "", "removeUnexistentIndices", "table", "Lcom/intellij/database/model/mssql/MsModLikeTable;", "existentIndicesCombies", "Lgnu/trove/TLongHashSet;", "removeUnexistentSchemaObjects", "existentObjectIds", "Lgnu/trove/TIntHashSet;", "retrieveArguments", "retrieveCheckConstraints", "retrieveColumns", "retrieveCustomTypes", "retrieveDescription", "retrieveForeignKeys", "retrieveIndices", "retrieveKeys", "retrieveMainContent", "retrieveMajorNames", "retrieveMajorObjects", "retrieveSources", "retrieveSynonyms", "retrieveTriggers", "retrieveTypeCheckConstraints", "retrieveTypeColumns", "retrieveTypeIndices", "retrieveTypeKeys", "database-introspection"})
    protected final class MsSchemaRetriever
    extends BaseIntrospector.SchemaRetriever {
        private final int schemaId;
        private final ArrayList<MsLikeTable> myTouchedTables;
        private final HashSet<MsRoutine> myTouchedRoutines;
        private final StringOperator rewriter;

        @Override
        protected void analyzeBriefInfo() {
            this.setIntrospectionBeginTimestamp((Timestamp)this.getTransaction().query("select current_timestamp", Layouts.singleOf(Timestamp.class)).run());
        }

        @Override
        protected void analyzeCurrentContent() {
            this.progress("determining dropped objects");
            int[] existentObjectsArray = (int[])this.getTransaction().query(((MsIntrospector)MsIntrospector.this).myQueries.listExistentObjects.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId}).run();
            TIntHashSet existentObjectIds = new TIntHashSet(existentObjectsArray);
            MsSchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, existentObjectIds){
                final /* synthetic */ MsSchemaRetriever this$0;
                final /* synthetic */ TIntHashSet $existentObjectIds$inlined;
                {
                    this.this$0 = msSchemaRetriever;
                    this.$existentObjectIds$inlined = tIntHashSet;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    MsModSchema schema2 = (MsModSchema)MS;
                    MsSchemaRetriever.access$removeUnexistentSchemaObjects(this.this$0, schema2, this.$existentObjectIds$inlined);
                }
            });
            if (((MsSchema)this.getSchema()).getTableTypes().isEmpty() && ((MsSchema)this.getSchema()).getTables().isEmpty()) {
                return;
            }
            long[] existentIndicesArray = (long[])this.getTransaction().query(((MsIntrospector)MsIntrospector.this).myQueries.listExistentIndices.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId}).run();
            TLongHashSet existentIndicesCombies = new TLongHashSet(existentIndicesArray);
            MsSchemaRetriever this_$iv2 = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv2).modify((BasicElement)this_$iv2.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv2).this$0), new ModelModifier<MS>(this, existentIndicesCombies){
                final /* synthetic */ MsSchemaRetriever this$0;
                final /* synthetic */ TLongHashSet $existentIndicesCombies$inlined;
                {
                    this.this$0 = msSchemaRetriever;
                    this.$existentIndicesCombies$inlined = tLongHashSet;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    MsModSchema schema2 = (MsModSchema)MS;
                    MsSchemaRetriever.access$removeUnexistentIndices(this.this$0, schema2, this.$existentIndicesCombies$inlined);
                }
            });
        }

        private final void removeUnexistentSchemaObjects(MsModSchema schema, TIntHashSet existentObjectIds) {
            NamingIdentifyingFamily namingIdentifyingFamily = schema.getSynonyms();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.synonyms");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily)), existentObjectIds);
            NamingIdentifyingFamily namingIdentifyingFamily2 = schema.getRoutines();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily2, (String)"schema.routines");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily2)), existentObjectIds);
            NamingIdentifyingFamily namingIdentifyingFamily3 = schema.getViews();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily3, (String)"schema.views");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily3)), existentObjectIds);
            NamingIdentifyingFamily namingIdentifyingFamily4 = schema.getTables();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily4, (String)"schema.tables");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily4)), existentObjectIds);
            for (MsModTable table : schema.getTables()) {
                NamingIdentifyingFamily namingIdentifyingFamily5 = table.getKeys();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily5, (String)"table.keys");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily5)), existentObjectIds);
                NamingIdentifyingFamily namingIdentifyingFamily6 = table.getForeignKeys();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily6, (String)"table.foreignKeys");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily6)), existentObjectIds);
                NamingIdentifyingFamily namingIdentifyingFamily7 = table.getChecks();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily7, (String)"table.checks");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily7)), existentObjectIds);
                NamingIdentifyingFamily namingIdentifyingFamily8 = table.getTriggers();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily8, (String)"table.triggers");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily8)), existentObjectIds);
            }
            for (MsModView view2 : schema.getViews()) {
                NamingIdentifyingFamily namingIdentifyingFamily9 = view2.getKeys();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily9, (String)"view.keys");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily9)), existentObjectIds);
                NamingIdentifyingFamily namingIdentifyingFamily10 = view2.getChecks();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily10, (String)"view.checks");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily10)), existentObjectIds);
                NamingIdentifyingFamily namingIdentifyingFamily11 = view2.getTriggers();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily11, (String)"view.triggers");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily11)), existentObjectIds);
            }
        }

        private final void removeUnexistentIndices(MsModSchema schema, TLongHashSet existentIndicesCombies) {
            MsModLikeTable table;
            Iterator iterator = schema.getTableTypes().iterator();
            while (iterator.hasNext()) {
                MsModTableType msModTableType = table = (MsModTableType)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)msModTableType, (String)"table");
                this.removeUnexistentIndices(msModTableType, existentIndicesCombies);
            }
            iterator = schema.getTables().iterator();
            while (iterator.hasNext()) {
                MsModLikeTable msModLikeTable = table = (MsModTable)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)msModLikeTable, (String)"table");
                this.removeUnexistentIndices(msModLikeTable, existentIndicesCombies);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void removeUnexistentIndices(MsModLikeTable table, TLongHashSet existentIndicesCombies) {
            void $receiver$iv$iv;
            Iterable $receiver$iv22;
            Iterable iterable = $receiver$iv22 = (Iterable)table.getIndices();
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                MsModIndex it = (MsModIndex)element$iv$iv;
                if (!(existentIndicesCombies.contains(table.getObjectId() * 100000L + (long)it.getPosition()) ^ true)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List droppedIndices = (List)destination$iv$iv;
            int $receiver$iv22 = droppedIndices.size() - 1;
            boolean bl = false;
            if ($receiver$iv22 >= 0) {
                while (true) {
                    void i2;
                    ((BasicModArrangedElement)droppedIndices.get((int)i2)).drop();
                    if (i2 == false) break;
                    --i2;
                }
            }
        }

        @Override
        protected void retrieveMajorNames() {
        }

        @Override
        protected void retrieveMainContent() {
            this.retrieveCustomTypes();
            this.retrieveMajorObjects();
            this.retrieveColumns();
            this.retrieveIndices();
            this.retrieveKeys();
            this.retrieveForeignKeys();
            this.retrieveCheckConstraints();
            this.retrieveArguments();
            this.retrieveTriggers();
            this.retrieveSynonyms();
            this.retrieveDescription();
            this.retrieveSources();
        }

        private final void retrieveCustomTypes() {
            Object v0;
            List checkSums;
            block4: {
                if (Intrinsics.areEqual((Object)((MsSchema)this.getSchema()).getName(), (Object)"sys") && this.getMode().increment) {
                    return;
                }
                this.progress("retrieving user defined types");
                checkSums = (List)this.getTransaction().query(((MsIntrospector)MsIntrospector.this).myQueries.calculateCustomTypesCheckSums.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId}).run();
                Iterable $receiver$iv = checkSums;
                for (Object element$iv : $receiver$iv) {
                    MsIntroQueries.OneCustomTypesCheckSum it = (MsIntroQueries.OneCustomTypesCheckSum)element$iv;
                    if (!(it.type_kind == 1)) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            MsIntroQueries.OneCustomTypesCheckSum oneCustomTypesCheckSum = v0;
            long aliasTypesCheckSum = oneCustomTypesCheckSum != null ? oneCustomTypesCheckSum.check_sum : 0L;
            this.processAliasTypes(aliasTypesCheckSum);
            if (MsIntrospector.this.myVer10) {
                Object v2;
                block5: {
                    Iterable $receiver$iv = checkSums;
                    for (Object element$iv : $receiver$iv) {
                        MsIntroQueries.OneCustomTypesCheckSum it = (MsIntroQueries.OneCustomTypesCheckSum)element$iv;
                        if (!(it.type_kind == 2)) continue;
                        v2 = element$iv;
                        break block5;
                    }
                    v2 = null;
                }
                MsIntroQueries.OneCustomTypesCheckSum oneCustomTypesCheckSum2 = v2;
                long tableTypesCheckSum = oneCustomTypesCheckSum2 != null ? oneCustomTypesCheckSum2.check_sum : 0L;
                this.processTableTypes(tableTypesCheckSum);
            }
        }

        private final void processAliasTypes(long aliasTypesCheckSum) {
            if (aliasTypesCheckSum == 0L) {
                MsSchemaRetriever this_$iv = this;
                BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(){

                    public final void perform(MS schema) {
                        MS MS = schema;
                        Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                        MsModSchema schema2 = (MsModSchema)MS;
                        schema2.getAliasTypes().clear();
                        schema2.setAliasTypesCheckSum(0L);
                    }
                });
                return;
            }
            if (((MsSchema)this.getSchema()).getAliasTypesCheckSum() == aliasTypesCheckSum) {
                return;
            }
            List cas = (List)this.getTransaction().query(((MsIntrospector)MsIntrospector.this).myQueries.retrieveAliasTypes.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId}).run();
            MsSchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(cas){
                final /* synthetic */ List $cas$inlined;
                {
                    this.$cas$inlined = list;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    MsModSchema schema2 = (MsModSchema)MS;
                    schema2.getAliasTypes().markChildrenAsSyncPending();
                    for (MsIntroQueries.OneAliasType at : this.$cas$inlined) {
                        NamingIdentifyingFamily namingIdentifyingFamily = schema2.getAliasTypes();
                        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.aliasTypes");
                        ModNamingFamily modNamingFamily = (ModNamingFamily)((Object)namingIdentifyingFamily);
                        int n = at.type_id;
                        String string = at.name;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"at.name");
                        MsModAliasType aliasType = (MsModAliasType)MsIntrospectorKt.access$renewType(modNamingFamily, n, string);
                        aliasType.setNotNull(!at.is_nullable);
                        if (at.base_name != null) {
                            DataType dt = MsIntrospectorKt.access$makeDataType(at.base_name, at.max_length, at.precision, at.scale);
                            aliasType.setDataType(dt);
                            continue;
                        }
                        aliasType.setDataType(DataType.UNKNOWN);
                    }
                    schema2.getAliasTypes().removeSyncPendingChildren();
                    schema2.getAliasTypes().sort();
                }
            });
        }

        private final void processTableTypes(long tableTypesCheckSum) {
            if (tableTypesCheckSum == 0L) {
                MsSchemaRetriever this_$iv = this;
                BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(){

                    public final void perform(MS schema) {
                        MS MS = schema;
                        Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                        MsModSchema schema2 = (MsModSchema)MS;
                        schema2.getTableTypes().clear();
                        schema2.setTableTypesCheckSum(0L);
                    }
                });
                return;
            }
            if (((MsSchema)this.getSchema()).getTableTypesCheckSum() == tableTypesCheckSum) {
                return;
            }
            List tts = (List)this.getTransaction().query(((MsIntrospector)MsIntrospector.this).myQueries.retrieveTableTypes.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId}).run();
            MsSchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(tts){
                final /* synthetic */ List $tts$inlined;
                {
                    this.$tts$inlined = list;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    MsModSchema schema2 = (MsModSchema)MS;
                    schema2.getTableTypes().markChildrenAsSyncPending();
                    for (MsIntroQueries.OneTableType tt : this.$tts$inlined) {
                        NamingIdentifyingFamily namingIdentifyingFamily = schema2.getTableTypes();
                        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.tableTypes");
                        ModNamingFamily modNamingFamily = (ModNamingFamily)((Object)namingIdentifyingFamily);
                        int n = tt.type_id;
                        String string = tt.name;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"tt.name");
                        MsModTableType tableType = (MsModTableType)MsIntrospectorKt.access$renewType(modNamingFamily, n, string);
                        tableType.setObjectId(tt.object_id);
                        MsIntrospectorKt.access$setCreatedAndModifiedTimestamps(tableType, tt.create_date, tt.modify_date);
                    }
                    schema2.getTableTypes().removeSyncPendingChildren();
                    schema2.getTableTypes().sort();
                }
            });
            this.retrieveTypeColumns();
            this.retrieveTypeIndices();
            this.retrieveTypeKeys();
            this.retrieveTypeCheckConstraints();
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveMajorObjects() {
            void tableTypesWereTouched;
            void viewsWereTouched;
            void tablesWereTouched;
            this.progress("retrieving tables, views, procedures and functions");
            List os = (List)this.getTransaction().query(((MsIntrospector)MsIntrospector.this).myQueries.retrieveObjects.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId, this.getFromTimestamp()}).run();
            if (os.isEmpty()) {
                return;
            }
            Ref.BooleanRef booleanRef = new Ref.BooleanRef();
            booleanRef.element = false;
            Ref.BooleanRef booleanRef2 = new Ref.BooleanRef();
            booleanRef2.element = false;
            Ref.BooleanRef booleanRef3 = new Ref.BooleanRef();
            booleanRef3.element = false;
            MsSchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, os, (Ref.BooleanRef)tablesWereTouched, (Ref.BooleanRef)viewsWereTouched, (Ref.BooleanRef)tableTypesWereTouched){
                final /* synthetic */ MsSchemaRetriever this$0;
                final /* synthetic */ List $os$inlined;
                final /* synthetic */ Ref.BooleanRef $tablesWereTouched$inlined;
                final /* synthetic */ Ref.BooleanRef $viewsWereTouched$inlined;
                final /* synthetic */ Ref.BooleanRef $tableTypesWereTouched$inlined;
                {
                    this.this$0 = msSchemaRetriever;
                    this.$os$inlined = list;
                    this.$tablesWereTouched$inlined = booleanRef;
                    this.$viewsWereTouched$inlined = booleanRef2;
                    this.$tableTypesWereTouched$inlined = booleanRef3;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    MsModSchema schema2 = (MsModSchema)MS;
                    for (MsIntroQueries.OneObject o : this.$os$inlined) {
                        MsModSchemaObject obj;
                        if (o.type == null) continue;
                        if (Intrinsics.areEqual((Object)o.type, (Object)"U") || Intrinsics.areEqual((Object)o.type, (Object)"S") || Intrinsics.areEqual((Object)o.type, (Object)"IT")) {
                            E e = schema2.getTables().renew(o.object_id, o.name);
                            Intrinsics.checkExpressionValueIsNotNull(e, (String)"schema.tables.renew(o.object_id.toLong(), o.name)");
                            obj = (MsModSchemaObject)e;
                            this.$tablesWereTouched$inlined.element = true;
                        } else if (Intrinsics.areEqual((Object)o.type, (Object)"V")) {
                            E e = schema2.getViews().renew(o.object_id, o.name);
                            Intrinsics.checkExpressionValueIsNotNull(e, (String)"schema.views.renew(o.object_id.toLong(), o.name)");
                            obj = (MsModSchemaObject)e;
                            this.$viewsWereTouched$inlined.element = true;
                        } else if (Intrinsics.areEqual((Object)o.type, (Object)"TT")) {
                            E e = schema2.getTableTypes().renew(o.object_id, o.name);
                            Intrinsics.checkExpressionValueIsNotNull(e, (String)"schema.tableTypes.renew(\u2026ject_id.toLong(), o.name)");
                            obj = (MsModSchemaObject)e;
                            this.$tableTypesWereTouched$inlined.element = true;
                        } else {
                            if (!MsRoutineTypes.MS_ROUTINE_TYPES.keySet().contains(o.type)) continue;
                            MsModRoutine routine2 = (MsModRoutine)schema2.getRoutines().renew(o.object_id, o.name);
                            MsRoutineType routineType = MsRoutineTypes.MS_ROUTINE_TYPES.get(o.type);
                            routine2.setRoutineType(routineType);
                            Object object = routineType;
                            routine2.setRoutineKind(CollectionsKt.contains((Iterable)MsRoutineTypes.MS_FUNCTION_TYPES.values(), (Object)object) ? DasRoutine.Kind.FUNCTION : (CollectionsKt.contains((Iterable)MsRoutineTypes.MS_PROCEDURE_TYPES.values(), (Object)object) ? DasRoutine.Kind.PROCEDURE : DasRoutine.Kind.NONE));
                            MsModRoutine msModRoutine = routine2;
                            Intrinsics.checkExpressionValueIsNotNull((Object)msModRoutine, (String)"routine");
                            obj = msModRoutine;
                            routine2.getArguments().markChildrenAsSyncPending();
                            object = MsSchemaRetriever.access$getMyTouchedRoutines$p(this.this$0);
                            object.add(routine2);
                        }
                        boolean nameIsSurrogate = MsIntrospectorKt.access$detectSurrogateName(o.name);
                        obj.setNameSurrogate(nameIsSurrogate);
                        MsIntrospectorKt.access$setCreatedAndModifiedTimestamps(obj, o.create_date, o.modify_date);
                        if (!(obj instanceof MsModLikeTable)) continue;
                        MsSchemaRetriever.access$getMyTouchedTables$p(this.this$0).add(obj);
                        ((MsModLikeTable)obj).getColumns().markChildrenAsSyncPending();
                    }
                    if (this.$tablesWereTouched$inlined.element) {
                        schema2.getTables().sort();
                    }
                    if (this.$viewsWereTouched$inlined.element) {
                        schema2.getViews().sort();
                    }
                    if (this.$tableTypesWereTouched$inlined.element) {
                        schema2.getTableTypes().sort();
                    }
                    if (!MsSchemaRetriever.access$getMyTouchedRoutines$p(this.this$0).isEmpty()) {
                        schema2.getRoutines().sort();
                    }
                }
            });
        }

        private final void retrieveColumns() {
            List cols3;
            if (this.myTouchedTables.isEmpty()) {
                return;
            }
            this.progress("retrieving columns of tables and views");
            List list = cols3 = (List)this.getTransaction().query(((MsIntrospector)MsIntrospector.this).myQueries.retrieveColumns.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId, this.getFromTimestamp()}).run();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"cols");
            this.processColumns(list);
        }

        private final void retrieveTypeColumns() {
            List cols3;
            this.progress("retrieving columns of custom table types");
            List list = cols3 = (List)this.getTransaction().query(((MsIntrospector)MsIntrospector.this).myQueries.retrieveTypeColumns.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId}).run();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"cols");
            this.processColumns(list);
        }

        private final void processColumns(List<MsIntroQueries.OneColumn> cols3) {
            HashSet affectedTables = new HashSet(cols3.size() / 3);
            MsSchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(cols3, affectedTables){
                final /* synthetic */ List $cols$inlined;
                final /* synthetic */ HashSet $affectedTables$inlined;
                {
                    this.$cols$inlined = list;
                    this.$affectedTables$inlined = hashSet;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    MsModSchema schema2 = (MsModSchema)MS;
                    MsModLikeTable table = null;
                    int object_id = 0;
                    for (MsIntroQueries.OneColumn col : this.$cols$inlined) {
                        if (object_id != col.object_id || table == null) {
                            object_id = col.object_id;
                            table = MsIntrospectorKt.access$findLikeTableById(schema2, object_id);
                            if (table == null) continue;
                            if (col.column_position == 1) {
                                table.getColumns().markChildrenAsSyncPending();
                            }
                            this.$affectedTables$inlined.add(table);
                        }
                        MsModLikeColumn column = (MsModLikeColumn)table.getColumns().createOrGet(col.name);
                        column.setPosition(col.column_position);
                        column.setNotNull(!col.is_nullable);
                        DataType dt = MsIntrospectorKt.access$makeDataType(col.type_name, col.max_length, col.precision, col.scale);
                        column.setDataType(dt);
                        if (!(column instanceof MsModLikeStoredColumn)) continue;
                        ((MsModLikeStoredColumn)column).setComputed(col.is_computed);
                        ((MsModLikeStoredColumn)column).setDefaultExpression(MsIntrospectorKt.access$normalizeExpression(col.default_expression));
                        if (col.identity_seed_value == null && col.identity_increment_value == null && col.identity_last_value == null) continue;
                        Long next = col.identity_last_value != null ? Long.valueOf(col.identity_last_value + (long)1) : null;
                        ((MsModLikeStoredColumn)column).setSequenceIdentity(SequenceIdentity.of(col.identity_seed_value, next, col.identity_increment_value, null));
                    }
                    for (MsModLikeTable t : this.$affectedTables$inlined) {
                        t.getColumns().removeSyncPendingChildren();
                        t.getColumns().sort();
                    }
                }
            });
        }

        private final void retrieveIndices() {
            this.progress("retrieving indices");
            List inds = (List)this.getTransaction().query(((MsIntrospector)MsIntrospector.this).myQueries.retrieveIndices.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId, this.getFromTimestamp()}).run();
            List ics = (List)this.getTransaction().query(((MsIntrospector)MsIntrospector.this).myQueries.retrieveIndexColumns.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId, this.getFromTimestamp()}).run();
            List list = inds;
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"inds");
            List list2 = ics;
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"ics");
            this.processIndices(list, list2);
        }

        private final void retrieveTypeIndices() {
            this.progress("retrieving indices of custom table types");
            List inds = (List)this.getTransaction().query(((MsIntrospector)MsIntrospector.this).myQueries.retrieveTypeIndices.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId}).run();
            List ics = (List)this.getTransaction().query(((MsIntrospector)MsIntrospector.this).myQueries.retrieveTypeIndexColumns.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId}).run();
            List list = inds;
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"inds");
            List list2 = ics;
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"ics");
            this.processIndices(list, list2);
        }

        private final void processIndices(List<MsIntroQueries.OneIndex> inds, List<MsIntroQueries.OneIndexColumn> ics) {
            HashMap indices = new HashMap(inds.size());
            MsSchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(inds, indices){
                final /* synthetic */ List $inds$inlined;
                final /* synthetic */ HashMap $indices$inlined;
                {
                    this.$inds$inlined = list;
                    this.$indices$inlined = hashMap;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    MsModSchema schema2 = (MsModSchema)MS;
                    for (MsIntroQueries.OneIndex ind : this.$inds$inlined) {
                        MsModLikeTable t;
                        if (MsIntrospectorKt.access$findLikeTableById(schema2, (long)ind.object_id) == null) {
                            continue;
                        }
                        MsModIndex index = (MsModIndex)t.getIndices().createOrGetAt(ind.position);
                        index.setName(ind.name);
                        index.setNameSurrogate(MsIntrospectorKt.access$detectSurrogateName(ind.name));
                        index.setUnique(ind.is_unique);
                        index.setClustering(ind.type == 1);
                        this.$indices$inlined.put(new MsMinorIdentity(ind.object_id, ind.position), index);
                    }
                }
            });
            CollectionAggregator cols12 = new CollectionAggregator(processIndices.cols1.1.INSTANCE);
            CollectionAggregator cols22 = new CollectionAggregator(processIndices.cols2.1.INSTANCE);
            for (MsIntroQueries.OneIndexColumn ic : ics) {
                MsMinorIdentity key = new MsMinorIdentity(ic.object_id, ic.index_position);
                String string = ic.name;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ic.name");
                cols12.add(key, string);
                if (!ic.is_desc) continue;
                String string2 = ic.name;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"ic.name");
                cols22.add(key, string2);
            }
            MsSchemaRetriever this_$iv2 = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv2).modify((BasicElement)this_$iv2.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv2).this$0), new ModelModifier<MS>(cols12, indices, cols22){
                final /* synthetic */ CollectionAggregator $cols1$inlined;
                final /* synthetic */ HashMap $indices$inlined;
                final /* synthetic */ CollectionAggregator $cols2$inlined;
                {
                    this.$cols1$inlined = collectionAggregator;
                    this.$indices$inlined = hashMap;
                    this.$cols2$inlined = collectionAggregator2;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    MsModSchema schema2 = (MsModSchema)MS;
                    Map<K, CV> map = this.$cols1$inlined.getResult();
                    Iterator<Map.Entry<K, CV>> iterator = map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        MsModIndex index;
                        Map.Entry<K, CV> entry;
                        Map.Entry<K, CV> entry2 = entry = iterator.next();
                        MsMinorIdentity key = (MsMinorIdentity)entry2.getKey();
                        entry2 = entry;
                        List names = (List)entry2.getValue();
                        if ((MsModIndex)this.$indices$inlined.get(key) == null) {
                            continue;
                        }
                        index.setColNames(names);
                        Set set = (Set)this.$cols2$inlined.get(key);
                        if (set == null) {
                            set = SetsKt.emptySet();
                        }
                        index.setReverseColNames(set);
                    }
                }
            });
        }

        private final void retrieveKeys() {
            List ks;
            this.progress("retrieving candidate keys");
            List list = ks = (List)this.getTransaction().query(((MsIntrospector)MsIntrospector.this).myQueries.retrieveKeys.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId, this.getFromTimestamp()}).run();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"ks");
            this.processKeys(list);
            Collection collection = ks;
            if (!collection.isEmpty()) {
                collection = MsIntrospector.this.databasesToReResolveForeignKeys;
                BasicDatabase basicDatabase = this.getDatabase();
                collection.add(basicDatabase);
            }
        }

        private final void retrieveTypeKeys() {
            List ks;
            this.progress("retrieving keys of custom table types");
            List list = ks = (List)this.getTransaction().query(((MsIntrospector)MsIntrospector.this).myQueries.retrieveTypeKeys.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId}).run();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"ks");
            this.processKeys(list);
        }

        private final void processKeys(List<MsIntroQueries.OneKey> ks) {
            MsSchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(ks){
                final /* synthetic */ List $ks$inlined;
                {
                    this.$ks$inlined = list;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    MsModSchema schema2 = (MsModSchema)MS;
                    HashSet<MsModLikeTable> tables = new HashSet<MsModLikeTable>(this.$ks$inlined.size());
                    for (MsIntroQueries.OneKey k : this.$ks$inlined) {
                        Object v1;
                        MsModKey key;
                        MsModLikeTable table;
                        block6: {
                            if (MsIntrospectorKt.access$findLikeTableById(schema2, (long)k.table_id) == null) {
                                continue;
                            }
                            key = (MsModKey)table.getKeys().renew(k.key_id, k.name);
                            key.setNameSurrogate(k.is_system_named);
                            key.setPrimary(k.is_primary);
                            MsIntrospectorKt.access$setCreatedAndModifiedTimestamps(key, k.create_date, k.modify_date);
                            Iterable $receiver$iv = table.getIndices();
                            for (T element$iv : $receiver$iv) {
                                MsModIndex ind = (MsModIndex)element$iv;
                                if (!(ind.getPosition() == k.index_position)) continue;
                                v1 = element$iv;
                                break block6;
                            }
                            v1 = null;
                        }
                        MsModIndex index = v1;
                        if (index != null) {
                            key.setUnderlyingIndexName(index.getRealName());
                            key.setColNames(index.getColNames());
                            index.setNameSurrogate(k.is_system_named);
                        } else {
                            key.setUnderlyingIndexName(null);
                            key.setColNames(CollectionsKt.emptyList());
                        }
                        tables.add(table);
                    }
                    for (MsModLikeTable table : tables) {
                        table.getKeys().sort();
                    }
                }
            });
        }

        private final void retrieveForeignKeys() {
            if (this.myTouchedTables.isEmpty()) {
                return;
            }
            this.progress("retrieving foreign keys");
            List fks = (List)this.getTransaction().query(((MsIntrospector)MsIntrospector.this).myQueries.retrieveForeignKeys.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId, this.getFromTimestamp()}).run();
            if (fks.isEmpty()) {
                return;
            }
            MsSchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, fks){
                final /* synthetic */ MsSchemaRetriever this$0;
                final /* synthetic */ List $fks$inlined;
                {
                    this.this$0 = msSchemaRetriever;
                    this.$fks$inlined = list;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    MsModSchema schema2 = (MsModSchema)MS;
                    HashSet<MsModTable> affectedTables = new HashSet<MsModTable>(this.$fks$inlined.size());
                    TLongObjectHashMap infos = new TLongObjectHashMap(this.$fks$inlined.size());
                    for (MsIntroQueries.OneForeignKey fk : this.$fks$inlined) {
                        MsModTable table;
                        if ((MsModTable)schema2.getTables().getByObjectId(fk.table_id) == null) {
                            continue;
                        }
                        MsModForeignKey fkey = (MsModForeignKey)table.getForeignKeys().renew(fk.constraint_id, fk.name);
                        BasicDatabase basicDatabase = this.this$0.getDatabase();
                        if (basicDatabase == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.mssql.MsDatabase");
                        }
                        MsSchema refSchema = (MsSchema)((MsDatabase)basicDatabase).getSchemas().getByObjectId(fk.referenced_schema_id);
                        fkey.setNameSurrogate(fk.is_system_named);
                        fkey.setRefTableId(fk.referenced_object_id);
                        fkey.setRefTableName(fk.referenced_object_name);
                        MsSchema msSchema = refSchema;
                        fkey.setRefSchemaName(msSchema != null ? msSchema.getRealName() : null);
                        MsIntrospectorKt.access$setCreatedAndModifiedTimestamps(fkey, fk.create_date, fk.modify_date);
                        MsModForeignKey msModForeignKey = fkey;
                        Intrinsics.checkExpressionValueIsNotNull((Object)msModForeignKey, (String)"fkey");
                        ForeignKeyInfo fki = new ForeignKeyInfo(msModForeignKey, refSchema);
                        fki.setDomTableId(fk.table_id);
                        fki.setRefTableId(fk.referenced_object_id);
                        infos.put(fk.constraint_id, (Object)fki);
                        affectedTables.add(table);
                    }
                    List fcs = (List)this.this$0.getTransaction().query(MsIntrospector.access$getMyQueries$p((MsIntrospector)this.this$0.MsIntrospector.this).retrieveForeignKeyColumns.rewrite(MsSchemaRetriever.access$getRewriter$p(this.this$0))).withParams(new Object[]{MsSchemaRetriever.access$getSchemaId$p(this.this$0), this.this$0.getFromTimestamp()}).run();
                    for (MsIntroQueries.OneForeignKeyColumn fc : fcs) {
                        ForeignKeyInfo fki = (ForeignKeyInfo)infos.get(fc.constraint_id);
                        if (fki == null) continue;
                        fki.getDomColumnNames().add((Object)fc.domestic_column_name);
                        fki.getRefColumnNames().add((Object)fc.reference_column_name);
                    }
                    Object[] objectArray = infos.getValues();
                    for (int j = 0; j < objectArray.length; ++j) {
                        Object object;
                        MsTable refTable;
                        Object o;
                        Object object2 = o = objectArray[j];
                        if (object2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.introspection.ForeignKeyInfo");
                        }
                        ForeignKeyInfo fki = (ForeignKeyInfo)object2;
                        fki.getFkey().setColNames((List)ImmutableList.copyOf((Collection)((Collection)fki.getDomColumnNames())));
                        fki.getFkey().setRefColNames((List)ImmutableList.copyOf((Collection)((Collection)fki.getRefColumnNames())));
                        BasicNode basicNode = fki.getRefSchema();
                        MsTable msTable = basicNode != null && (basicNode = basicNode.getTables()) != null ? (MsTable)basicNode.getByObjectId(fki.getRefTableId()) : (refTable = null);
                        if (refTable != null) {
                            MsKey refKey = MsIntrospectorKt.access$findKeyByColumns(refTable, (List)fki.getRefColumnNames());
                            MsKey msKey = refKey;
                            fki.getFkey().setRefKeyName(msKey != null ? msKey.getRealName() : null);
                            if (refKey != null) continue;
                            object = MsIntrospector.access$getDatabasesToReResolveForeignKeys$p(this.this$0.MsIntrospector.this);
                            BasicDatabase basicDatabase = this.this$0.getDatabase();
                            object.add(basicDatabase);
                            continue;
                        }
                        Collection collection = MsIntrospector.access$getDatabasesToReResolveForeignKeys$p(this.this$0.MsIntrospector.this);
                        object = this.this$0.getDatabase();
                        collection.add(object);
                    }
                    for (MsModTable table : affectedTables) {
                        table.getForeignKeys().sort();
                    }
                }
            });
        }

        private final void retrieveCheckConstraints() {
            List cs;
            if (this.myTouchedTables.isEmpty()) {
                return;
            }
            this.progress("retrieving check constraints");
            List list = cs = (List)this.getTransaction().query(((MsIntrospector)MsIntrospector.this).myQueries.retrieveCheckConstraints.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId, this.getFromTimestamp()}).run();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"cs");
            this.processCheckConstraints(list);
        }

        private final void retrieveTypeCheckConstraints() {
            List cs;
            this.progress("retrieving check constraints of custom table types");
            List list = cs = (List)this.getTransaction().query(((MsIntrospector)MsIntrospector.this).myQueries.retrieveTypeCheckConstraints.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId}).run();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"cs");
            this.processCheckConstraints(list);
        }

        private final void processCheckConstraints(List<MsIntroQueries.OneCheckConstraints> cs) {
            MsSchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(cs){
                final /* synthetic */ List $cs$inlined;
                {
                    this.$cs$inlined = list;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    MsModSchema schema2 = (MsModSchema)MS;
                    HashSet<MsModLikeTable> affectedTables = new HashSet<MsModLikeTable>(this.$cs$inlined.size());
                    for (MsIntroQueries.OneCheckConstraints c : this.$cs$inlined) {
                        MsModLikeTable table;
                        if (MsIntrospectorKt.access$findLikeTableById(schema2, (long)c.table_id) == null) {
                            continue;
                        }
                        MsModCheck check = (MsModCheck)table.getChecks().renew(c.constraint_id, c.name);
                        check.setNameSurrogate(c.is_system_named);
                        MsIntrospectorKt.access$setCreatedAndModifiedTimestamps(check, c.create_date, c.modify_date);
                        if (c.column_name != null) {
                            check.setColNames(Collections.singletonList(c.column_name));
                        } else {
                            check.setColNames(CollectionsKt.emptyList());
                        }
                        check.setPredicate(MsIntrospectorKt.access$normalizePredicateExpression(c.definition));
                        affectedTables.add(table);
                    }
                    for (MsModLikeTable table : affectedTables) {
                        table.getChecks().sort();
                    }
                }
            });
        }

        private final void retrieveSynonyms() {
            this.progress("retrieving synonyms");
            List ss = (List)this.getTransaction().query(((MsIntrospector)MsIntrospector.this).myQueries.retrieveSynonyms.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId, this.getFromTimestamp()}).run();
            if (ss.isEmpty()) {
                return;
            }
            MsSchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(ss){
                final /* synthetic */ List $ss$inlined;
                {
                    this.$ss$inlined = list;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    MsModSchema schema2 = (MsModSchema)MS;
                    for (MsIntroQueries.OneSynonym s : this.$ss$inlined) {
                        MsModSynonym synonym = (MsModSynonym)schema2.getSynonyms().renew(s.object_id, s.name);
                        synonym.setTargetSchemaName(s.origin_schema_name);
                        synonym.setTargetObjectName(s.origin_object_name);
                        MsIntrospectorKt.access$setCreatedAndModifiedTimestamps(synonym, s.create_date, s.modify_date);
                    }
                    schema2.getSynonyms().sort();
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveArguments() {
            void wasDefaults;
            if (this.myTouchedRoutines.isEmpty()) {
                return;
            }
            this.progress("retrieving procedures' and functions' parameters");
            Ref.BooleanRef booleanRef = new Ref.BooleanRef();
            booleanRef.element = false;
            List args = (List)this.getTransaction().query(((MsIntrospector)MsIntrospector.this).myQueries.retrieveArguments.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId, this.getFromTimestamp()}).run();
            MsSchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, args, (Ref.BooleanRef)wasDefaults){
                final /* synthetic */ MsSchemaRetriever this$0;
                final /* synthetic */ List $args$inlined;
                final /* synthetic */ Ref.BooleanRef $wasDefaults$inlined;
                {
                    this.this$0 = msSchemaRetriever;
                    this.$args$inlined = list;
                    this.$wasDefaults$inlined = booleanRef;
                }

                public final void perform(MS schema) {
                    MsRoutine routine2;
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    MsModSchema schema2 = (MsModSchema)MS;
                    Iterator<E> iterator = MsSchemaRetriever.access$getMyTouchedRoutines$p(this.this$0).iterator();
                    while (iterator.hasNext()) {
                        MsRoutine msRoutine = routine2 = (MsRoutine)iterator.next();
                        if (msRoutine == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.mssql.MsModRoutine");
                        }
                        ((MsModRoutine)msRoutine).getArguments().markChildrenAsSyncPending();
                    }
                    for (MsIntroQueries.OneArguments a : this.$args$inlined) {
                        CharSequence charSequence;
                        DasArgument.Direction d;
                        MsModRoutine routine3;
                        if ((MsModRoutine)schema2.getRoutines().getByObjectId((long)a.object_id) == null) {
                            continue;
                        }
                        MsModArgument argument = (MsModArgument)routine3.getArguments().createOrGet(a.name);
                        DasArgument.Direction direction = a.is_cursor_ref ? DasArgument.Direction.RESULT : (d = a.is_output ? DasArgument.Direction.OUT : DasArgument.Direction.IN);
                        if (Intrinsics.areEqual((Object)d, (Object)DasArgument.Direction.OUT) && (a.name == null || (charSequence = (CharSequence)a.name).length() == 0)) {
                            d = DasArgument.Direction.RETURN;
                        }
                        argument.setArgumentDirection(d);
                        DataType dt = MsIntrospectorKt.access$makeDataType(a.type_name, a.max_length, a.precision, a.scale);
                        argument.setDataType(dt);
                        argument.resetSyncPending();
                        this.$wasDefaults$inlined.element |= a.has_default_value;
                        Collection collection = MsSchemaRetriever.access$getMyTouchedRoutines$p(this.this$0);
                        collection.add(routine3);
                    }
                    iterator = MsSchemaRetriever.access$getMyTouchedRoutines$p(this.this$0).iterator();
                    while (iterator.hasNext()) {
                        MsRoutine msRoutine = routine2 = (MsRoutine)iterator.next();
                        if (msRoutine == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.mssql.MsModRoutine");
                        }
                        ((MsModRoutine)msRoutine).getArguments().removeSyncPendingChildren();
                    }
                }
            });
            boolean cfr_ignored_0 = wasDefaults.element;
        }

        private final void retrieveTriggers() {
            if (((MsSchema)this.getSchema()).getTables().isEmpty() & ((MsSchema)this.getSchema()).getViews().isEmpty()) {
                return;
            }
            this.progress("retrieving triggers");
            List ts2 = (List)this.getTransaction().query(((MsIntrospector)MsIntrospector.this).myQueries.retrieveTriggers.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId, this.getFromTimestamp()}).run();
            if (ts2.isEmpty()) {
                return;
            }
            MsSchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(ts2){
                final /* synthetic */ List $ts$inlined;
                {
                    this.$ts$inlined = list;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    MsModSchema schema2 = (MsModSchema)MS;
                    HashSet<MsModLikeMajorTable> affectedTables = new HashSet<MsModLikeMajorTable>(this.$ts$inlined.size());
                    for (MsIntroQueries.OneTrigger t : this.$ts$inlined) {
                        MsModLikeMajorTable table;
                        if (MsIntrospectorKt.access$findLikeMajorTableById(schema2, t.table_id) == null) {
                            continue;
                        }
                        MsModTrigger trigger2 = (MsModTrigger)table.getTriggers().renew(t.trigger_id, t.name);
                        trigger2.setEvents(MsIntrospectorKt.access$unpackEvents(t.events));
                        trigger2.setFirstEvents(MsIntrospectorKt.access$unpackEvents(t.first_events));
                        trigger2.setLastEvents(MsIntrospectorKt.access$unpackEvents(t.last_events));
                        trigger2.setTurn(t.is_instead_of_trigger ? TrigTurn.INSTEAD_OF : TrigTurn.AFTER_STMT);
                        trigger2.setNotForReplication(t.is_not_for_replication);
                        trigger2.setDisabled(t.is_disabled);
                        trigger2.setEncrypted(t.encrypted);
                        trigger2.setCreatedTimestamp(t.create_date);
                        trigger2.setModifiedTimestamp(t.modify_date);
                        affectedTables.add(table);
                    }
                    for (MsModLikeMajorTable table : affectedTables) {
                        table.getTriggers().sort();
                    }
                }
            });
        }

        private final void retrieveDescription() {
            if (this.myTouchedTables.isEmpty()) {
                return;
            }
            this.progress("retrieving tables' descriptions");
            List ds = (List)this.getTransaction().query(((MsIntrospector)MsIntrospector.this).myQueries.retrieveDescriptions.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId, this.getFromTimestamp()}).run();
            if (ds.isEmpty()) {
                return;
            }
            MsSchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(ds){
                final /* synthetic */ List $ds$inlined;
                {
                    this.$ds$inlined = list;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    MsModSchema schema2 = (MsModSchema)MS;
                    MsModLikeTable table = null;
                    int object_id = 0;
                    for (MsIntroQueries.OneDescription d : this.$ds$inlined) {
                        MsModLikeColumn column;
                        Object v1;
                        block3: {
                            if ((object_id != d.object_id || table == null) && (table = MsIntrospectorKt.access$findLikeTableById(schema2, object_id = d.object_id)) == null) continue;
                            if (d.item_position == 0) {
                                table.setComment(d.description);
                                continue;
                            }
                            Iterable $receiver$iv = table.getColumns();
                            for (T element$iv : $receiver$iv) {
                                MsModLikeColumn c = (MsModLikeColumn)element$iv;
                                if (!(c.getPosition() == d.item_position)) continue;
                                v1 = element$iv;
                                break block3;
                            }
                            v1 = null;
                        }
                        if ((column = (MsModLikeColumn)v1) == null) continue;
                        column.setComment(d.description);
                    }
                }
            });
        }

        private final void retrieveSources() {
            if (!this.getWithSources()) {
                return;
            }
            this.progress("retrieving source texts");
            List ss = (List)this.getTransaction().query(((MsIntrospector)MsIntrospector.this).myQueries.retrieveSources.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId, this.getSourcesSince()}).run();
            if (ss.isEmpty()) {
                return;
            }
            MsIntrospector this_$iv = MsIntrospector.this;
            this_$iv.getModel().writeSources(new Runnable(this, ss){
                final /* synthetic */ MsSchemaRetriever this$0;
                final /* synthetic */ List $ss$inlined;
                {
                    this.this$0 = msSchemaRetriever;
                    this.$ss$inlined = list;
                }

                public final void run() {
                    MsSchemaRetriever this_$iv = this.this$0;
                    BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), (ModelModifier)new ModelModifier<MS>(this){
                        final /* synthetic */ MsSchemaRetriever$retrieveSources$$inlined$writeSources$1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public final void perform(MS schema) {
                            MS MS = schema;
                            Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                            MsModSchema schema2 = (MsModSchema)MS;
                            for (MsIntroQueries.OneSource s : this.this$0.$ss$inlined) {
                                MsModTrigger trigger2;
                                MsModLikeMajorTable table;
                                if (s.object_id == 0L || s.text == null) continue;
                                if (!s.is_trigger) {
                                    MsModSourceAware msModSourceAware = MsIntrospectorKt.access$findMajorSourceAwareById(schema2, s.object_id);
                                    if (msModSourceAware != null) {
                                        String string = s.text;
                                        msModSourceAware.setSourceText(string != null ? BaseIntrospectionFunctions.toCompositeText(string, CompositeText.Kind.ORIGINAL_TEXT) : null);
                                    }
                                    continue;
                                }
                                if (MsIntrospectorKt.access$findLikeMajorTableById(schema2, s.parent_id) == null) {
                                    continue;
                                }
                                if ((MsModTrigger)table.getTriggers().getByObjectId(s.object_id) == null) {
                                    continue;
                                }
                                trigger2.setSourceText(BaseIntrospectionFunctions.toCompositeText(s.text, CompositeText.Kind.ORIGINAL_TEXT));
                            }
                        }
                    });
                }
            });
        }

        @Override
        protected void finishSchema() {
            super.finishSchema();
            MsSchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this){
                final /* synthetic */ MsSchemaRetriever this$0;
                {
                    this.this$0 = msSchemaRetriever;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    MsModSchema schema2 = (MsModSchema)MS;
                    schema2.setIntrospectionTimestamp(this.this$0.getIntrospectionBeginTimestamp());
                }
            });
        }

        private final void progress(String what) {
            String mode = this.getMode().increment ? "incrementally" : "completely";
            String string = String.format("Introspecting schema %s (%s)", ((MsSchema)this.getSchema()).getName(), mode);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"format(\"Introspecting sc\u2026(%s)\", schema.name, mode)");
            MsIntrospector.this.updateStatus(string, what);
        }

        public MsSchemaRetriever(@NotNull DBTransaction transaction, MsSchema schema) {
            MsDatabase database;
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            super((BaseIntrospector)MsIntrospector.this, transaction, (BasicSchema)schema);
            this.myTouchedTables = new ArrayList();
            this.myTouchedRoutines = new HashSet();
            this.schemaId = (int)schema.getObjectId();
            MsDatabase msDatabase = schema.getDatabase();
            if (msDatabase == null) {
                Intrinsics.throwNpe();
            }
            MsDatabase msDatabase2 = database = msDatabase;
            Intrinsics.checkExpressionValueIsNotNull((Object)msDatabase2, (String)"database");
            String catalogPrefix = MsIntrospectorKt.access$catalogPrefix(msDatabase2);
            ImmutableMap substitutionMap = ImmutableMap.of((Object)"#CAT", (Object)catalogPrefix, (Object)"#ISTABLETYPE", (Object)(MsIntrospector.this.myVer10 ? "is_table_type" : "0"));
            StringOperator stringOperator = QueryRewriters.substitute((Map)substitutionMap);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringOperator, (String)"substitute(substitutionMap)");
            this.rewriter = stringOperator;
        }

        public static final /* synthetic */ void access$removeUnexistentSchemaObjects(MsSchemaRetriever $this, @NotNull MsModSchema schema, @NotNull TIntHashSet existentObjectIds) {
            $this.removeUnexistentSchemaObjects(schema, existentObjectIds);
        }

        public static final /* synthetic */ void access$removeUnexistentIndices(MsSchemaRetriever $this, @NotNull MsModSchema schema, @NotNull TLongHashSet existentIndicesCombies) {
            $this.removeUnexistentIndices(schema, existentIndicesCombies);
        }

        @NotNull
        public static final /* synthetic */ HashSet access$getMyTouchedRoutines$p(MsSchemaRetriever $this) {
            return $this.myTouchedRoutines;
        }

        @NotNull
        public static final /* synthetic */ ArrayList access$getMyTouchedTables$p(MsSchemaRetriever $this) {
            return $this.myTouchedTables;
        }

        @NotNull
        public static final /* synthetic */ StringOperator access$getRewriter$p(MsSchemaRetriever $this) {
            return $this.rewriter;
        }

        public static final /* synthetic */ int access$getSchemaId$p(MsSchemaRetriever $this) {
            return $this.schemaId;
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/introspection/MsIntrospector$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "()V", "database-introspection"})
    public static final class VERSION
    extends PerObjectVersion {
        public static final VERSION INSTANCE;

        private VERSION() {
            INSTANCE = this;
        }

        static {
            new VERSION();
        }
    }
}

