/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.model.AlienElementException;
import com.intellij.database.model.Branch;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicColumn;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicMinorObject;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicNamespaceOwner;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicSchemaObject;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.mssql.MsIndex;
import com.intellij.database.model.mssql.MsKey;
import com.intellij.database.model.properties.TrigEvent;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000\u009e\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u001c\u001a\u00020\u001d*\u00020\u000e\u001a\u001e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00120\u001f*\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001f\u001a\n\u0010#\u001a\u00020\u0012*\u00020$\u001a\u001a\u0010%\u001a\u0004\u0018\u00010\u0017*\u00020 2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00120\u001f\u001a\u001b\u0010'\u001a\u0004\u0018\u00010\u0002\"\b\b\u0000\u0010(*\u00020\u000e*\u0002H(\u00a2\u0006\u0002\u0010)\u001a,\u0010*\u001a\u0014\u0012\u0004\u0012\u00020,\u0012\n\u0012\b\u0012\u0004\u0012\u0002H(0\u001f0+\"\b\b\u0000\u0010(*\u00020\u000e*\b\u0012\u0004\u0012\u0002H(0-\u001a\f\u0010.\u001a\u00020\u0006*\u0004\u0018\u00010\u0001\u001a\u0016\u0010/\u001a\u00020\u0006\"\u0004\b\u0000\u00100*\b\u0012\u0004\u0012\u0002H001\u001a\u0018\u00102\u001a\u00020\u0006*\u00020\u00172\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00120\u001f\u001a\u0019\u00103\u001a\u0004\u0018\u00010\u0012*\u0002042\b\u00105\u001a\u0004\u0018\u00010\u0001H\u0086\u0004\u001a\u0010\u00106\u001a\u00020\u0012*\b\u0012\u0004\u0012\u00020807\u001a)\u00109\u001a\u0002H(\"\b\b\u0000\u0010(*\u00020\u000e*\n\u0012\u0006\b\u0001\u0012\u0002H(0:2\u0006\u0010;\u001a\u00020\u000e\u00a2\u0006\u0002\u0010<\u001a1\u0010=\u001a\b\u0012\u0004\u0012\u0002H(01\"\n\b\u0000\u0010(\u0018\u0001*\u00020\u000e*\u0004\u0018\u00010\u000e2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020?H\u0086\b\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\b\"\u0015\u0010\t\u001a\u00020\u0006*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u0017\u0010\r\u001a\u0004\u0018\u00010\u0001*\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\"\u0017\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\"\u0017\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\"\u0017\u0010\u0015\u001a\u0004\u0018\u00010\u001a*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u001b\u00a8\u0006A"}, d2={"currentSchema", "Lcom/intellij/database/model/basic/BasicSchema;", "Lcom/intellij/database/model/basic/BasicDatabase;", "getCurrentSchema", "(Lcom/intellij/database/model/basic/BasicDatabase;)Lcom/intellij/database/model/basic/BasicSchema;", "isClustering", "", "Lcom/intellij/database/model/mssql/MsKey;", "(Lcom/intellij/database/model/mssql/MsKey;)Z", "refToPrimaryKey", "Lcom/intellij/database/model/basic/BasicForeignKey;", "getRefToPrimaryKey", "(Lcom/intellij/database/model/basic/BasicForeignKey;)Z", "schema", "Lcom/intellij/database/model/basic/BasicElement;", "getSchema", "(Lcom/intellij/database/model/basic/BasicElement;)Lcom/intellij/database/model/basic/BasicSchema;", "schemaName", "", "getSchemaName", "(Lcom/intellij/database/model/basic/BasicForeignKey;)Ljava/lang/String;", "underlyingIndex", "Lcom/intellij/database/model/basic/BasicIndex;", "Lcom/intellij/database/model/basic/BasicKey;", "getUnderlyingIndex", "(Lcom/intellij/database/model/basic/BasicKey;)Lcom/intellij/database/model/basic/BasicIndex;", "Lcom/intellij/database/model/mssql/MsIndex;", "(Lcom/intellij/database/model/mssql/MsKey;)Lcom/intellij/database/model/mssql/MsIndex;", "branch", "Lcom/intellij/database/model/Branch;", "columnNamesByPositions", "", "Lcom/intellij/database/model/basic/BasicLikeTable;", "positions", "", "eventsString", "Lcom/intellij/database/model/basic/BasicTrigger;", "findKey", "columnNames", "getDatabase", "E", "(Lcom/intellij/database/model/basic/BasicElement;)Lcom/intellij/database/model/basic/BasicDatabase;", "groupByModel", "", "Lcom/intellij/database/model/basic/BasicModel;", "", "hasTriggers", "isNotEmpty", "T", "Lcom/intellij/util/containers/JBIterable;", "isOfColumns", "nameInContextOfSchema", "Lcom/intellij/database/model/basic/BasicSchemaObject;", "contextSchema", "namesAsString", "", "Lcom/intellij/database/model/basic/BasicNamedElement;", "own", "Lcom/intellij/database/model/families/Family;", "element", "(Lcom/intellij/database/model/families/Family;Lcom/intellij/database/model/basic/BasicElement;)Lcom/intellij/database/model/basic/BasicElement;", "subIterable", "kindOfLevel1", "Lcom/intellij/database/model/ObjectKind;", "kindOfLevel2", "database-model-api"})
@JvmName(name="ModelFun")
public final class ModelFun {
    @NotNull
    public static final Branch branch(@NotNull BasicElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return new Branch($receiver);
    }

    @Nullable
    public static final BasicSchema getCurrentSchema(@NotNull BasicDatabase $receiver) {
        Object v0;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Iterable $receiver$iv = $receiver.getSchemas();
            for (Object element$iv : $receiver$iv) {
                BasicSchema it = (BasicSchema)element$iv;
                if (!it.isCurrent()) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public static final <E extends BasicElement> E own(@NotNull Family<? extends E> $receiver, @NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        for (BasicElement e : $receiver) {
            if (!Intrinsics.areEqual((Object)e, (Object)element)) continue;
            return (E)e;
        }
        throw (Throwable)new AlienElementException(element);
    }

    private static final <E extends BasicElement> JBIterable<E> subIterable(@Nullable BasicElement $receiver, ObjectKind kindOfLevel1, ObjectKind kindOfLevel2) {
        BasicNode basicNode;
        block3: {
            block2: {
                basicNode = $receiver;
                if (basicNode == null || (basicNode = basicNode.familyOf(kindOfLevel1)) == null || (basicNode = basicNode.jbi()) == null || (basicNode = basicNode.flatten(new Function<E, Iterable<? extends T>>(kindOfLevel2){
                    final /* synthetic */ ObjectKind $kindOfLevel2;

                    @NotNull
                    public final JBIterable<? extends BasicElement> fun(BasicElement it) {
                        JBIterable jBIterable = it.familyOf(this.$kindOfLevel2);
                        if (jBIterable == null || (jBIterable = jBIterable.jbi()) == null) {
                            jBIterable = JBIterable.empty();
                        }
                        return jBIterable;
                    }
                    {
                        this.$kindOfLevel2 = objectKind;
                    }
                })) == null) break block2;
                Intrinsics.reifiedOperationMarker((int)4, (String)"E");
                if ((basicNode = basicNode.filter(BasicElement.class)) != null) break block3;
            }
            JBIterable jBIterable = JBIterable.empty();
            basicNode = jBIterable;
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"JBIterable.empty()");
        }
        return basicNode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean hasTriggers(@Nullable BasicSchema $receiver) {
        ObjectKind kindOfLevel1$iv;
        BasicElement $receiver$iv;
        if ($receiver == null) return false;
        BasicElement basicElement = $receiver;
        ObjectKind objectKind = ObjectKind.TABLE;
        Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"TABLE");
        ObjectKind objectKind2 = objectKind;
        ObjectKind objectKind3 = ObjectKind.TRIGGER;
        Intrinsics.checkExpressionValueIsNotNull((Object)objectKind3, (String)"TRIGGER");
        ObjectKind kindOfLevel2$iv = objectKind3;
        JBIterable jBIterable = $receiver$iv.familyOf(kindOfLevel1$iv);
        if (jBIterable == null || (jBIterable = jBIterable.jbi()) == null || (jBIterable = jBIterable.flatten(new /* invalid duplicate definition of identical inner class */)) == null || (jBIterable = jBIterable.filter(BasicElement.class)) == null) {
            JBIterable jBIterable2 = JBIterable.empty();
            jBIterable = jBIterable2;
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable2, (String)"JBIterable.empty()");
        }
        if (ModelFun.isNotEmpty(jBIterable)) return true;
        $receiver$iv = $receiver;
        ObjectKind objectKind4 = ObjectKind.MAT_VIEW;
        Intrinsics.checkExpressionValueIsNotNull((Object)objectKind4, (String)"MAT_VIEW");
        kindOfLevel1$iv = objectKind4;
        ObjectKind objectKind5 = ObjectKind.TRIGGER;
        Intrinsics.checkExpressionValueIsNotNull((Object)objectKind5, (String)"TRIGGER");
        kindOfLevel2$iv = objectKind5;
        JBIterable jBIterable3 = $receiver$iv.familyOf(kindOfLevel1$iv);
        if (jBIterable3 == null || (jBIterable3 = jBIterable3.jbi()) == null || (jBIterable3 = jBIterable3.flatten(new /* invalid duplicate definition of identical inner class */)) == null || (jBIterable3 = jBIterable3.filter(BasicElement.class)) == null) {
            JBIterable jBIterable4 = JBIterable.empty();
            jBIterable3 = jBIterable4;
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable4, (String)"JBIterable.empty()");
        }
        if (ModelFun.isNotEmpty(jBIterable3)) return true;
        $receiver$iv = $receiver;
        ObjectKind objectKind6 = ObjectKind.VIEW;
        Intrinsics.checkExpressionValueIsNotNull((Object)objectKind6, (String)"VIEW");
        kindOfLevel1$iv = objectKind6;
        ObjectKind objectKind7 = ObjectKind.TRIGGER;
        Intrinsics.checkExpressionValueIsNotNull((Object)objectKind7, (String)"TRIGGER");
        kindOfLevel2$iv = objectKind7;
        JBIterable jBIterable5 = $receiver$iv.familyOf(kindOfLevel1$iv);
        if (jBIterable5 == null || (jBIterable5 = jBIterable5.jbi()) == null || (jBIterable5 = jBIterable5.flatten(new /* invalid duplicate definition of identical inner class */)) == null || (jBIterable5 = jBIterable5.filter(BasicElement.class)) == null) {
            JBIterable jBIterable6 = JBIterable.empty();
            jBIterable5 = jBIterable6;
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable6, (String)"JBIterable.empty()");
        }
        if (!ModelFun.isNotEmpty(jBIterable5)) return false;
        return true;
    }

    public static final <T> boolean isNotEmpty(@NotNull JBIterable<T> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return !$receiver.isEmpty();
    }

    @Nullable
    public static final <E extends BasicElement> BasicDatabase getDatabase(@NotNull E $receiver) {
        BasicDatabase basicDatabase;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        E e = $receiver;
        if (e instanceof BasicDatabase) {
            basicDatabase = (BasicDatabase)$receiver;
        } else if (e instanceof BasicRoot) {
            basicDatabase = null;
        } else if (e instanceof BasicSchema) {
            BasicNamespaceOwner basicNamespaceOwner = ((BasicSchema)$receiver).getDbParent();
            if (!(basicNamespaceOwner instanceof BasicDatabase)) {
                basicNamespaceOwner = null;
            }
            basicDatabase = (BasicDatabase)basicNamespaceOwner;
        } else {
            BasicElement basicElement = $receiver.getDbParent();
            basicDatabase = basicElement != null ? ModelFun.getDatabase(basicElement) : null;
        }
        return basicDatabase;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <E extends BasicElement> Map<BasicModel, List<E>> groupByModel(@NotNull Iterable<? extends E> $receiver) {
        void var3_3;
        BasicElement it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Iterable iterable = $receiver$iv = $receiver;
        Object destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (BasicElement)element$iv$iv;
            if (!(it.getModel() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new LinkedHashMap();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Object object;
            BasicModel key$iv$iv;
            Object $receiver$iv$iv$iv;
            Object value$iv$iv$iv;
            it = (BasicElement)element$iv$iv;
            if (it.getModel() == null) {
                Intrinsics.throwNpe();
            }
            if ((value$iv$iv$iv = ($receiver$iv$iv$iv = destination$iv$iv).get(key$iv$iv)) == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        return var3_3;
    }

    @Nullable
    public static final BasicSchema getSchema(@NotNull BasicElement $receiver) {
        BasicSchema basicSchema;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        BasicElement basicElement = $receiver;
        if (basicElement instanceof BasicSchema) {
            basicSchema = (BasicSchema)$receiver;
        } else if (basicElement instanceof BasicSchemaObject) {
            basicSchema = ((BasicSchemaObject)$receiver).getSchema();
        } else if (basicElement instanceof BasicMinorObject) {
            BasicMajorObject basicMajorObject = ((BasicMinorObject)$receiver).getMajorObject();
            basicSchema = basicMajorObject != null ? basicMajorObject.getSchema() : null;
        } else if (basicElement instanceof BasicDatabase) {
            basicSchema = null;
        } else if (basicElement instanceof BasicRoot) {
            basicSchema = null;
        } else {
            BasicElement basicElement2 = $receiver.getDbParent();
            basicSchema = basicElement2 != null ? ModelFun.getSchema(basicElement2) : null;
        }
        return basicSchema;
    }

    @NotNull
    public static final String namesAsString(@NotNull Collection<? extends BasicNamedElement> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return CollectionsKt.joinToString$default((Iterable)$receiver, null, null, null, (int)0, null, (Function1)namesAsString.1.INSTANCE, (int)31, null);
    }

    @Nullable
    public static final String nameInContextOfSchema(@NotNull BasicSchemaObject $receiver, @Nullable BasicSchema contextSchema) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = $receiver.getRealName();
        if (string == null) {
            return null;
        }
        String thisName = string;
        BasicSchema thisSchema = $receiver.getSchema();
        if (thisSchema == null || thisSchema == contextSchema) {
            return thisName;
        }
        String string2 = thisSchema.getRealName();
        if (string2 == null) {
            return thisName;
        }
        String schemaName = string2;
        return schemaName + "." + thisName;
    }

    @NotNull
    public static final List<String> columnNamesByPositions(@NotNull BasicLikeTable $receiver, @NotNull List<Short> positions) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(positions, (String)"positions");
        int n = positions.size();
        if (n == 0) {
            return CollectionsKt.emptyList();
        }
        ArrayList names = new ArrayList(n);
        Iterator<Short> iterator = positions.iterator();
        while (iterator.hasNext()) {
            short p = ((Number)iterator.next()).shortValue();
            BasicColumn column = (BasicColumn)$receiver.getColumns().getByNaturalPosition(p);
            Object object = column;
            if (object == null || (object = object.getRealName()) == null) {
                object = "???";
            }
            Object name = object;
            Collection collection = names;
            collection.add(name);
        }
        return names;
    }

    @Nullable
    public static final BasicKey findKey(@NotNull BasicLikeTable $receiver, @NotNull List<String> columnNames) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(columnNames, (String)"columnNames");
        int cn = columnNames.size();
        if (cn == 0) {
            return null;
        }
        for (BasicKey basicKey : $receiver.getKeys()) {
            if (!ModelFun.isOfColumns(basicKey, columnNames)) continue;
            return basicKey;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String eventsString(@NotNull BasicTrigger $receiver) {
        void var3_3;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Iterable $receiver$iv = $receiver.getEvents();
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            String string;
            Object object;
            void it;
            TrigEvent trigEvent = (TrigEvent)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            if (Intrinsics.areEqual((Object)it, (Object)((Object)TrigEvent.UPDATE)) && !(object = (Collection)$receiver.getCols()).isEmpty()) {
                string = "update of " + CollectionsKt.joinToString$default((Iterable)$receiver.getColNames(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
            } else {
                Object object2 = object = it.name();
                if (object2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string2 = ((String)object2).toLowerCase();
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
            }
            String string3 = string;
            collection.add(string3);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)var3_3), (CharSequence)" or ", null, null, (int)0, null, null, (int)62, null);
    }

    @Nullable
    public static final BasicIndex getUnderlyingIndex(@NotNull BasicKey $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = $receiver.getUnderlyingIndexName();
        if (string == null) {
            return null;
        }
        String indexName = string;
        BasicLikeTable basicLikeTable = $receiver.getTable();
        if (basicLikeTable == null) {
            return null;
        }
        BasicLikeTable table = basicLikeTable;
        Family<? extends BasicIndex> family = table.getIndices();
        if (!(family instanceof NamingFamily)) {
            family = null;
        }
        NamingFamily namingFamily = (NamingFamily)family;
        if (namingFamily == null) {
            return null;
        }
        NamingFamily indices = namingFamily;
        return (BasicIndex)indices.get(indexName);
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isOfColumns(@NotNull BasicKey $receiver, @NotNull List<String> columnNames) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(columnNames, (String)"columnNames");
        int cn = columnNames.size();
        int mn = $receiver.getColNames().size();
        if (cn == 0 || cn != mn) {
            return false;
        }
        int n = 0;
        int n2 = cn - 1;
        if (n <= n2) {
            while (true) {
                void i2;
                if (Intrinsics.areEqual((Object)columnNames.get((int)i2), (Object)$receiver.getColNames().get((int)i2)) ^ true) {
                    return false;
                }
                if (i2 == n2) break;
                ++i2;
            }
        }
        return true;
    }

    @Nullable
    public static final String getSchemaName(@NotNull BasicForeignKey $receiver) {
        String string;
        BasicLikeTable table;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        BasicLikeTable basicLikeTable = table = $receiver.getTable();
        if (Intrinsics.areEqual((Object)basicLikeTable, null)) {
            string = null;
        } else if (basicLikeTable instanceof BasicSchemaObject) {
            string = ((BasicSchemaObject)((Object)table)).getSchemaName();
        } else if (basicLikeTable instanceof BasicMinorObject) {
            BasicMajorObject basicMajorObject = ((BasicMinorObject)((Object)table)).getMajorObject();
            string = basicMajorObject != null ? basicMajorObject.getSchemaName() : null;
        } else {
            string = null;
        }
        return string;
    }

    public static final boolean getRefToPrimaryKey(@NotNull BasicForeignKey $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        BasicKey basicKey = $receiver.getRefKey();
        return basicKey != null ? basicKey.isPrimary() : false;
    }

    @Nullable
    public static final MsIndex getUnderlyingIndex(@NotNull MsKey $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = $receiver.getUnderlyingIndexName();
        if (string == null) {
            return null;
        }
        String indexName = string;
        BasicLikeTable basicLikeTable = $receiver.getTable();
        if (basicLikeTable == null) {
            return null;
        }
        BasicLikeTable table = basicLikeTable;
        Family<? extends BasicIndex> family = table.getIndices();
        if (!(family instanceof NamingFamily)) {
            family = null;
        }
        NamingFamily namingFamily = (NamingFamily)family;
        if (namingFamily == null) {
            return null;
        }
        NamingFamily indices = namingFamily;
        Object e = indices.get(indexName);
        if (!(e instanceof MsIndex)) {
            e = null;
        }
        return (MsIndex)e;
    }

    public static final boolean isClustering(@NotNull MsKey $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        MsIndex msIndex = ModelFun.getUnderlyingIndex($receiver);
        return msIndex != null ? msIndex.isClustering() : false;
    }
}

