/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.model.Naming;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RelativeReference
implements Serializable {
    static final char ARGS_OPEN_MARKER = '(';
    static final char ARGS_CLOSE_MARKER = ')';
    static final char PATH_SEPARATOR = '.';
    static final char ARGS_SEPARATOR = ',';
    static final char HOME_MARKER = '~';
    static final String HOME_MARKER_STR = Character.toString('~').intern();
    @NotNull
    public final ExplicitOrigin explicitOrigin;
    @NotNull
    public final String[] path;
    @Nullable
    public final String[] args;

    @NotNull
    public static RelativeReference of(@NotNull ExplicitOrigin explicitOrigin, @NotNull String[] path, @Nullable String[] args) {
        if (explicitOrigin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "explicitOrigin", "com/intellij/database/model/RelativeReference", "of"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/model/RelativeReference", "of"));
        }
        String[] copiedPath = RelativeReference.copyStrings(path);
        String[] copiedArgs = RelativeReference.copyStrings(args);
        RelativeReference relativeReference = new RelativeReference(explicitOrigin, copiedPath, copiedArgs);
        if (relativeReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/RelativeReference", "of"));
        }
        return relativeReference;
    }

    @NotNull
    public static RelativeReference of(@NotNull String[] path, @Nullable String[] args) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/model/RelativeReference", "of"));
        }
        String[] copiedPath = RelativeReference.copyStrings(path);
        String[] copiedArgs = RelativeReference.copyStrings(args);
        RelativeReference relativeReference = new RelativeReference(copiedPath, copiedArgs);
        if (relativeReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/RelativeReference", "of"));
        }
        return relativeReference;
    }

    @NotNull
    public static RelativeReference of(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/database/model/RelativeReference", "of"));
        }
        RelativeReference relativeReference = RelativeReference.parseForImport(string);
        if (relativeReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/RelativeReference", "of"));
        }
        return relativeReference;
    }

    private RelativeReference(@NotNull ExplicitOrigin explicitOrigin, @NotNull String[] path, @Nullable String[] args) {
        if (explicitOrigin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "explicitOrigin", "com/intellij/database/model/RelativeReference", "<init>"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/model/RelativeReference", "<init>"));
        }
        this.explicitOrigin = explicitOrigin;
        this.path = path;
        this.args = args;
    }

    private RelativeReference(@NotNull String[] path, @Nullable String[] args) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/model/RelativeReference", "<init>"));
        }
        this.explicitOrigin = ExplicitOrigin.NONE;
        this.path = path;
        this.args = args;
    }

    @NotNull
    public final String export() {
        String s;
        int i2;
        int n = this.path.length;
        int m = this.args == null ? 0 : this.args.length;
        StringBuilder b = new StringBuilder((n + m) * 32);
        switch (this.explicitOrigin) {
            case DATABASE: {
                b.append('~');
                break;
            }
            case SCHEMA: {
                b.append('~').append('.');
            }
        }
        for (i2 = 0; i2 < n; ++i2) {
            if (i2 != 0) {
                b.append('.');
            }
            s = Naming.exportName(this.path[i2]);
            b.append(s);
        }
        if (this.args != null) {
            b.append('(');
            for (i2 = 0; i2 < m; ++i2) {
                if (i2 != 0) {
                    b.append(',');
                }
                s = Naming.exportName(this.args[i2]);
                b.append(s);
            }
            b.append(')');
        }
        String string = b.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/RelativeReference", "export"));
        }
        return string;
    }

    @NotNull
    static RelativeReference parseForImport(@NotNull String string) {
        String[] args;
        String[] path;
        int p2;
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/database/model/RelativeReference", "parseForImport"));
        }
        int p1 = string.indexOf(40);
        int n = p2 = p1 == -1 ? -1 : string.indexOf(41, p1 + 1);
        if (p1 > -1 && p2 == -1) {
            throw new IllegalArgumentException("Cannot import reference: \"" + string + "\"");
        }
        if (p2 == -1) {
            path = RelativeReference.splitNames(string, '.');
            args = null;
        } else {
            String pathStr = string.substring(0, p1);
            String argsStr = string.substring(p1 + 1, p2);
            path = RelativeReference.splitNames(pathStr, '.');
            args = RelativeReference.splitNames(argsStr, ',');
        }
        ExplicitOrigin eo = ExplicitOrigin.NONE;
        if (path.length > 0) {
            String s1 = path[0];
            assert (s1 != null);
            if ((s1 = s1.trim()).equals(HOME_MARKER_STR)) {
                eo = ExplicitOrigin.SCHEMA;
                path = Arrays.copyOfRange(path, 1, path.length);
            } else if (s1.startsWith(HOME_MARKER_STR) && s1.length() >= 2) {
                eo = ExplicitOrigin.DATABASE;
                path[0] = s1.substring(1);
            }
        }
        RelativeReference relativeReference = new RelativeReference(eo, path, args);
        if (relativeReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/RelativeReference", "parseForImport"));
        }
        return relativeReference;
    }

    private static String[] splitNames(@NotNull String names, char separator) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/database/model/RelativeReference", "splitNames"));
        }
        List escapedNames = StringUtil.split((String)names, (String)Character.toString(separator), (boolean)true, (boolean)true);
        int n = escapedNames.size();
        String[] result2 = new String[n];
        for (int i2 = 0; i2 < n; ++i2) {
            result2[i2] = Naming.importName((String)escapedNames.get(i2));
        }
        return result2;
    }

    @Contract(value="!null -> !null; null -> null", pure=true)
    static String[] copyStrings(String[] strings) {
        if (strings != null) {
            String[] newStrings;
            int n = strings.length;
            if (n > 0) {
                newStrings = new String[n];
                System.arraycopy(strings, 0, newStrings, 0, n);
            } else {
                newStrings = ArrayUtil.EMPTY_STRING_ARRAY;
            }
            return newStrings;
        }
        return null;
    }

    public String toString() {
        return this.export();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelativeReference that = (RelativeReference)o;
        if (!Arrays.equals(this.path, that.path)) {
            return false;
        }
        if (!Arrays.equals(this.args, that.args)) {
            return false;
        }
        return this.explicitOrigin == that.explicitOrigin;
    }

    public int hashCode() {
        return Arrays.hashCode(this.path) * 17 + Arrays.hashCode(this.args);
    }

    public static enum ExplicitOrigin {
        NONE,
        SCHEMA,
        DATABASE;

    }
}

