/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.basic;

import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelUtil;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicColumn;
import com.intellij.database.model.basic.BasicConstraint;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.ListMultiRef;
import com.intellij.database.util.DasUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BasicForeignKey
extends BasicConstraint,
BasicNamedElement,
DasForeignKey {
    default public boolean isReferencingAnotherSchema() {
        @Nullable BasicMajorObject majorObject = this.getMajorObject();
        if (majorObject == null) {
            return false;
        }
        BasicSchema mySchema = majorObject.getSchema();
        if (mySchema == null) {
            return false;
        }
        String refSchemaName = this.getRefSchemaName();
        if (refSchemaName == null) {
            return false;
        }
        return !refSchemaName.equals(mySchema.getName());
    }

    @Nullable
    default public String getRefSchemaName() {
        return null;
    }

    @Nullable
    default public BasicSchema getRefSchema() {
        @Nullable BasicMajorObject majorObject = this.getMajorObject();
        if (majorObject == null) {
            return null;
        }
        BasicSchema mySchema = majorObject.getSchema();
        String refSchemaName = this.getRefSchemaName();
        if (refSchemaName == null) {
            return mySchema;
        }
        return mySchema != null ? mySchema.getSibling(refSchemaName) : null;
    }

    @Nullable
    default public String getRefTableName() {
        return null;
    }

    @Nullable
    default public BasicLikeTable getRefTable() {
        String refTableName = this.getRefTableName();
        if (refTableName == null) {
            return null;
        }
        BasicSchema refSchema = this.getRefSchema();
        return refSchema != null ? refSchema.getLikeTable(refTableName) : null;
    }

    @Nullable
    default public String getRefKeyName() {
        return null;
    }

    @Nullable
    default public BasicKey getRefKey() {
        String refKeyName = this.getRefKeyName();
        if (refKeyName == null) {
            return null;
        }
        BasicLikeTable refTable = this.getRefTable();
        if (refTable == null) {
            return null;
        }
        return refTable.findChild(ObjectKind.KEY, refKeyName, BasicKey.class);
    }

    @NotNull
    default public List<String> getRefColNames() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicForeignKey", "getRefColNames"));
        }
        return list;
    }

    @NotNull
    default public List<? extends BasicColumn> getRefCols() {
        List<String> refColNames = this.getRefColNames();
        if (refColNames.isEmpty()) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicForeignKey", "getRefCols"));
            }
            return list;
        }
        BasicLikeTable refTable = this.getRefTable();
        if (refTable == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicForeignKey", "getRefCols"));
            }
            return list;
        }
        Family<@NotNull ? extends BasicElement> columns2 = refTable.familyOf(ObjectKind.COLUMN);
        if (columns2 == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicForeignKey", "getRefCols"));
            }
            return list;
        }
        if (!1.$assertionsDisabled && !(columns2 instanceof NamingFamily)) {
            throw new AssertionError();
        }
        List list = ((NamingFamily)columns2).get(refColNames);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicForeignKey", "getRefCols"));
        }
        return list;
    }

    @NotNull
    default public CascadeRule getOnUpdate() {
        CascadeRule cascadeRule = CascadeRule.restrict;
        if (cascadeRule == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicForeignKey", "getOnUpdate"));
        }
        return cascadeRule;
    }

    @NotNull
    default public CascadeRule getOnDelete() {
        CascadeRule cascadeRule = CascadeRule.restrict;
        if (cascadeRule == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicForeignKey", "getOnDelete"));
        }
        return cascadeRule;
    }

    @Override
    @NotNull
    default public Iterable<? extends BasicElement> getPredecessors() {
        BasicLikeTable refTable = this.getRefTable();
        BasicKey refKey = this.getRefKey();
        List<BasicElement> list = ModelUtil.listOfNN(refTable, refKey);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicForeignKey", "getPredecessors"));
        }
        return list;
    }

    @NotNull
    default public MultiRef<? extends BasicColumn> getRefColumns() {
        ListMultiRef<? extends BasicColumn> listMultiRef = new ListMultiRef<BasicColumn>(this.getRefCols());
        if (listMultiRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicForeignKey", "getRefColumns"));
        }
        return listMultiRef;
    }

    @Deprecated
    default public String getRefTableSchema() {
        return this.getRefSchemaName();
    }

    @Deprecated
    default public String getRefTableCatalog() {
        BasicLikeTable refTable = this.getRefTable();
        return DasUtil.getCatalog((DasObject)refTable);
    }

    @Deprecated
    default public DasForeignKey.RuleAction getUpdateRule() {
        switch (this.getOnUpdate()) {
            case restrict: {
                return DasForeignKey.RuleAction.RESTRICT;
            }
            case set_null: {
                return DasForeignKey.RuleAction.SET_NULL;
            }
            case set_default: {
                return DasForeignKey.RuleAction.SET_DEFAULT;
            }
            case cascade: {
                return DasForeignKey.RuleAction.CASCADE;
            }
        }
        return DasForeignKey.RuleAction.NO_ACTION;
    }

    @Deprecated
    default public DasForeignKey.RuleAction getDeleteRule() {
        switch (this.getOnDelete()) {
            case restrict: {
                return DasForeignKey.RuleAction.RESTRICT;
            }
            case set_null: {
                return DasForeignKey.RuleAction.SET_NULL;
            }
            case set_default: {
                return DasForeignKey.RuleAction.SET_DEFAULT;
            }
            case cascade: {
                return DasForeignKey.RuleAction.CASCADE;
            }
        }
        return DasForeignKey.RuleAction.NO_ACTION;
    }

    @Deprecated
    default public DasForeignKey.Deferrability getDeferrability() {
        return this.isDeferrable() ? (this.isInitiallyDeferred() ? DasForeignKey.Deferrability.INITIALLY_DEFERRED : DasForeignKey.Deferrability.INITIALLY_IMMEDIATE) : DasForeignKey.Deferrability.NOT_DEFERRABLE;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

