/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.basic;

import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BasicNamedElement
extends BasicElement {
    @Override
    @NotNull
    default public String getName() {
        String string = ModelConsts.NO_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicNamedElement", "getName"));
        }
        return string;
    }

    @Override
    default public String getRealName() {
        String name = this.getName();
        return name != ModelConsts.NO_NAME ? name : null;
    }

    @Override
    @Nullable
    default public String getNaturalName() {
        return this.isNameSurrogate() ? null : this.getRealName();
    }

    default public boolean isNameSurrogate() {
        return false;
    }

    default public boolean isNameScripted() {
        return false;
    }

    default public boolean isNameQuoted() {
        return false;
    }

    @Nullable
    default public String getCatalogName() {
        String name = this.getRealName();
        if (name == null || name.isEmpty()) {
            return name;
        }
        if (this.isNameScripted()) {
            Casing casing = this.getCasing();
            Case caze = this.isNameQuoted() ? casing.quoted : casing.plain;
            return caze.apply(name);
        }
        return name;
    }

    @NotNull
    default public Casing getCasing() {
        CasingProvider provider = this.getCasingProvider();
        Casing casing = provider != null ? provider.getCasing(this.getKind(), null) : Casing.EXACT;
        if (casing == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicNamedElement", "getCasing"));
        }
        return casing;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }
}

