/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.derby;

import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DataType;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModArrangedElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.derby.DerbyArgument;
import com.intellij.database.model.derby.DerbyModRoutine;
import com.intellij.database.model.derby.DerbyModSchema;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DerbyModArgument
extends DerbyArgument,
BasicModArgument,
BasicModArrangedElement,
BasicModNamedElement {
    @Override
    @NotNull
    public DerbyModRoutine getRoutine();

    @Override
    @NotNull
    default public DerbyModRoutine getDbParent() {
        DerbyModRoutine derbyModRoutine = this.getRoutine();
        if (derbyModRoutine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/derby/DerbyModArgument", "getDbParent"));
        }
        return derbyModRoutine;
    }

    @Override
    @NotNull
    public ModPositioningNamingFamily<? extends DerbyModArgument> getParentFamily();

    @Override
    @NotNull
    default public DerbyModSchema getSchema() {
        DerbyModSchema derbyModSchema = this.getRoutine().getSchema();
        if (derbyModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/derby/DerbyModArgument", "getSchema"));
        }
        return derbyModSchema;
    }

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/derby/DerbyModArgument", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/derby/DerbyModArgument", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setPosition(short var1);

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setArgumentDirection(@NotNull DasArgument.Direction var1);

    @Override
    public void setDataType(@NotNull DataType var1);

    @Override
    public void setDefaultExpression(@Nullable String var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/derby/DerbyModArgument", "importProperties"));
        }
        String position = properties.get("Position");
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String nameScripted = properties.get("NameScripted");
        String nameQuoted = properties.get("NameQuoted");
        String comment = properties.get("Comment");
        String argumentDirection = properties.get("ArgumentDirection");
        String dataType = properties.get("DataType");
        String defaultExpression = properties.get("DefaultExpression");
        if (position != null) {
            this.setPosition(PropertyConverter.importShort(position));
        }
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (nameScripted != null) {
            this.setNameScripted(PropertyConverter.importBoolean(nameScripted));
        }
        if (nameQuoted != null) {
            this.setNameQuoted(PropertyConverter.importBoolean(nameQuoted));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (argumentDirection != null) {
            this.setArgumentDirection(PropertyConverter.importDasArgumentDirection(argumentDirection));
        }
        if (dataType != null) {
            this.setDataType(PropertyConverter.importDataType(dataType));
        }
        if (defaultExpression != null) {
            this.setDefaultExpression(PropertyConverter.importString(defaultExpression));
        }
    }
}

