/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.families;

import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.families.Family;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface NamingFamily<E extends BasicNamedElement>
extends Family<E> {
    @Nullable
    default public E get(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/families/NamingFamily", "get"));
        }
        for (BasicNamedElement e : this) {
            if (!e.getName().equals(name)) continue;
            return (E)e;
        }
        return null;
    }

    @Nullable
    default public E get(@NotNull String name, boolean caseSensitive) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/families/NamingFamily", "get"));
        }
        for (BasicNamedElement e : this) {
            if (!(caseSensitive ? e.getName().equals(name) : e.getName().equalsIgnoreCase(name))) continue;
            return (E)e;
        }
        return null;
    }

    default public @NotNull List<@Nullable E> get(@NotNull List<String> names) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/database/model/families/NamingFamily", "get"));
        }
        int n = names.size();
        if (n == 0) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/families/NamingFamily", "get"));
            }
            return list;
        }
        ArrayList<E> result2 = new ArrayList<E>(n);
        for (String name : names) {
            E e = this.get(name);
            result2.add(e);
        }
        if (!1.$assertionsDisabled && result2.size() != n) {
            throw new AssertionError();
        }
        ArrayList<E> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/families/NamingFamily", "get"));
        }
        return arrayList;
    }

    @NotNull
    default public List<String> getNames() {
        Stream<String> stream = StreamSupport.stream(this.spliterator(), false).map(BasicNamedElement::getRealName).filter(name -> name != null);
        List<String> list = stream.collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/families/NamingFamily", "getNames"));
        }
        return list;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

