/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.generic;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.generic.GenericDatabase;
import com.intellij.database.model.generic.GenericPackage;
import com.intellij.database.model.generic.GenericRoutine;
import com.intellij.database.model.generic.GenericSequence;
import com.intellij.database.model.generic.GenericTable;
import com.intellij.database.model.generic.GenericView;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface GenericSchema
extends BasicSchema,
BasicNamedElement {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.SCHEMA;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/generic/GenericSchema", "getKind"));
        }
        return objectKind;
    }

    @Override
    @Nullable
    public GenericDatabase getDatabase();

    @Override
    @Nullable
    default public GenericDatabase getDbParent() {
        return this.getDatabase();
    }

    @Override
    default public @Nullable NamingFamily<@NotNull ? extends GenericSchema> getParentFamily() {
        return null;
    }

    @NotNull
    public @NotNull NamingFamily<@NotNull ? extends GenericSequence> getSequences();

    @NotNull
    public @NotNull NamingFamily<@NotNull ? extends GenericTable> getTables();

    @NotNull
    public @NotNull NamingFamily<@NotNull ? extends GenericView> getViews();

    @NotNull
    public @NotNull NamingFamily<@NotNull ? extends GenericRoutine> getRoutines();

    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends GenericPackage> getPackages();

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Arrays.asList(ObjectKind.SEQUENCE, ObjectKind.TABLE, ObjectKind.VIEW, ObjectKind.ROUTINE, ObjectKind.PACKAGE);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/generic/GenericSchema", "getFamilyKinds"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List<Family> list = Arrays.asList(this.getSequences(), this.getTables(), this.getViews(), this.getRoutines(), this.getPackages());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/generic/GenericSchema", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull JBIterable<@NotNull ? extends BasicElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty().append(this.getSequences()).append(this.getTables()).append(this.getViews()).append(this.getRoutines()).append(this.getPackages());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/generic/GenericSchema", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    @Nullable
    default public Date getIntrospectionTimestamp() {
        return null;
    }

    @Override
    default public boolean isCurrent() {
        return false;
    }

    @Override
    default public boolean isVisible() {
        return false;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        boolean visible;
        boolean current;
        Date introspectionTimestamp;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/model/generic/GenericSchema", "exportProperties"));
        }
        String name = this.getName();
        if (name != null && name != ModelConsts.NO_NAME) {
            consumer.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer.accept("NameScripted", PropertyConverter.export(nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer.accept("NameQuoted", PropertyConverter.export(nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", PropertyConverter.export(comment));
        }
        if ((introspectionTimestamp = this.getIntrospectionTimestamp()) != null) {
            consumer.accept("IntrospectionTimestamp", PropertyConverter.export(introspectionTimestamp));
        }
        if (current = this.isCurrent()) {
            consumer.accept("Current", PropertyConverter.export(current));
        }
        if (visible = this.isVisible()) {
            consumer.accept("Visible", PropertyConverter.export(visible));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("Name", "NameSurrogate", "NameScripted", "NameQuoted", "Comment", "IntrospectionTimestamp", "Current", "Visible");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/generic/GenericSchema", "getPropertyNames"));
        }
        return list;
    }
}

