/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.h2;

import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.h2.H2ModCheck;
import com.intellij.database.model.h2.H2ModForeignKey;
import com.intellij.database.model.h2.H2ModIndex;
import com.intellij.database.model.h2.H2ModKey;
import com.intellij.database.model.h2.H2ModLikeTable;
import com.intellij.database.model.h2.H2ModSchema;
import com.intellij.database.model.h2.H2ModTableColumn;
import com.intellij.database.model.h2.H2ModTrigger;
import com.intellij.database.model.h2.H2Table;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface H2ModTable
extends H2Table,
H2ModLikeTable {
    @Override
    @NotNull
    public H2ModSchema getSchema();

    @Override
    @NotNull
    default public H2ModSchema getDbParent() {
        H2ModSchema h2ModSchema = this.getSchema();
        if (h2ModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/h2/H2ModTable", "getDbParent"));
        }
        return h2ModSchema;
    }

    @Override
    @NotNull
    public ModNamingFamily<? extends H2ModTable> getParentFamily();

    @NotNull
    public ModPositioningNamingFamily<? extends H2ModTableColumn> getColumns();

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends H2ModIndex> getIndices();

    @Override
    @NotNull
    public ModNamingFamily<? extends H2ModKey> getKeys();

    @Override
    @NotNull
    public ModNamingFamily<? extends H2ModForeignKey> getForeignKeys();

    @Override
    @NotNull
    public ModNamingFamily<? extends H2ModCheck> getChecks();

    @NotNull
    public ModNamingFamily<? extends H2ModTrigger> getTriggers();

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<ModFamily> list = Arrays.asList(this.getColumns(), this.getIndices(), this.getKeys(), this.getForeignKeys(), this.getChecks(), this.getTriggers());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/h2/H2ModTable", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty().append((Iterable)this.getColumns()).append((Iterable)this.getIndices()).append((Iterable)this.getKeys()).append((Iterable)this.getForeignKeys()).append((Iterable)this.getChecks()).append((Iterable)this.getTriggers());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/h2/H2ModTable", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setSystem(boolean var1);

    public void setTemporary(boolean var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/h2/H2ModTable", "importProperties"));
        }
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String nameScripted = properties.get("NameScripted");
        String nameQuoted = properties.get("NameQuoted");
        String comment = properties.get("Comment");
        String system = properties.get("System");
        String temporary = properties.get("Temporary");
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (nameScripted != null) {
            this.setNameScripted(PropertyConverter.importBoolean(nameScripted));
        }
        if (nameQuoted != null) {
            this.setNameQuoted(PropertyConverter.importBoolean(nameQuoted));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (system != null) {
            this.setSystem(PropertyConverter.importBoolean(system));
        }
        if (temporary != null) {
            this.setTemporary(PropertyConverter.importBoolean(temporary));
        }
    }
}

