/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.hsql;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLeaf;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.hsql.HsqlSchema;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface HsqlSequence
extends BasicNamedElement,
BasicLeaf {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.SEQUENCE;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/hsql/HsqlSequence", "getKind"));
        }
        return objectKind;
    }

    @Nullable
    public HsqlSchema getSchema();

    @Override
    @Nullable
    default public HsqlSchema getDbParent() {
        return this.getSchema();
    }

    default public @Nullable NamingFamily<@NotNull ? extends HsqlSequence> getParentFamily() {
        return null;
    }

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/hsql/HsqlSequence", "getFamilyKinds"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/hsql/HsqlSequence", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull JBIterable<@NotNull ? extends BasicElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/hsql/HsqlSequence", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Nullable
    default public SequenceIdentity getIdentity() {
        return null;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        SequenceIdentity identity;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/model/hsql/HsqlSequence", "exportProperties"));
        }
        String name = this.getName();
        if (name != null && name != ModelConsts.NO_NAME) {
            consumer.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer.accept("NameScripted", PropertyConverter.export(nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer.accept("NameQuoted", PropertyConverter.export(nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", PropertyConverter.export(comment));
        }
        if ((identity = this.getIdentity()) != null) {
            consumer.accept("Identity", PropertyConverter.export(identity));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("Name", "NameSurrogate", "NameScripted", "NameQuoted", "Comment", "Identity");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/hsql/HsqlSequence", "getPropertyNames"));
        }
        return list;
    }
}

