/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.hsql;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.hsql.HsqlCheck;
import com.intellij.database.model.hsql.HsqlForeignKey;
import com.intellij.database.model.hsql.HsqlIndex;
import com.intellij.database.model.hsql.HsqlKey;
import com.intellij.database.model.hsql.HsqlLikeTable;
import com.intellij.database.model.hsql.HsqlSchema;
import com.intellij.database.model.hsql.HsqlTableColumn;
import com.intellij.database.model.hsql.HsqlTrigger;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface HsqlTable
extends HsqlLikeTable,
BasicTable {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.TABLE;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/hsql/HsqlTable", "getKind"));
        }
        return objectKind;
    }

    @Override
    @Nullable
    public HsqlSchema getSchema();

    @Override
    @Nullable
    default public HsqlSchema getDbParent() {
        return this.getSchema();
    }

    default public @Nullable NamingFamily<@NotNull ? extends HsqlTable> getParentFamily() {
        return null;
    }

    @NotNull
    public @NotNull PositioningNamingFamily<@NotNull ? extends HsqlTableColumn> getColumns();

    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends HsqlIndex> getIndices();

    @NotNull
    public @NotNull NamingFamily<@NotNull ? extends HsqlKey> getKeys();

    @NotNull
    public @NotNull NamingFamily<@NotNull ? extends HsqlForeignKey> getForeignKeys();

    @NotNull
    public @NotNull NamingFamily<@NotNull ? extends HsqlCheck> getChecks();

    @NotNull
    public @NotNull NamingFamily<@NotNull ? extends HsqlTrigger> getTriggers();

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Arrays.asList(ObjectKind.COLUMN, ObjectKind.INDEX, ObjectKind.KEY, ObjectKind.FOREIGN_KEY, ObjectKind.CHECK, ObjectKind.TRIGGER);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/hsql/HsqlTable", "getFamilyKinds"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List<Family> list = Arrays.asList(this.getColumns(), this.getIndices(), this.getKeys(), this.getForeignKeys(), this.getChecks(), this.getTriggers());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/hsql/HsqlTable", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull JBIterable<@NotNull ? extends BasicElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty().append(this.getColumns()).append((Iterable)this.getIndices()).append((Iterable)this.getKeys()).append((Iterable)this.getForeignKeys()).append((Iterable)this.getChecks()).append(this.getTriggers());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/hsql/HsqlTable", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    default public boolean isSystem() {
        return false;
    }

    @Override
    default public boolean isTemporary() {
        return false;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        boolean temporary;
        boolean system;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/model/hsql/HsqlTable", "exportProperties"));
        }
        String name = this.getName();
        if (name != null && name != ModelConsts.NO_NAME) {
            consumer.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer.accept("NameScripted", PropertyConverter.export(nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer.accept("NameQuoted", PropertyConverter.export(nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", PropertyConverter.export(comment));
        }
        if (system = this.isSystem()) {
            consumer.accept("System", PropertyConverter.export(system));
        }
        if (temporary = this.isTemporary()) {
            consumer.accept("Temporary", PropertyConverter.export(temporary));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("Name", "NameSurrogate", "NameScripted", "NameQuoted", "Comment", "System", "Temporary");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/hsql/HsqlTable", "getPropertyNames"));
        }
        return list;
    }
}

