/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.mssql;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.mssql.MsCheck;
import com.intellij.database.model.mssql.MsForeignKey;
import com.intellij.database.model.mssql.MsIndex;
import com.intellij.database.model.mssql.MsKey;
import com.intellij.database.model.mssql.MsLikeMajorTable;
import com.intellij.database.model.mssql.MsSchema;
import com.intellij.database.model.mssql.MsTableColumn;
import com.intellij.database.model.mssql.MsTrigger;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MsTable
extends MsLikeMajorTable,
BasicTable {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.TABLE;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mssql/MsTable", "getKind"));
        }
        return objectKind;
    }

    @Override
    @Nullable
    public MsSchema getSchema();

    @Override
    @Nullable
    default public MsSchema getDbParent() {
        return this.getSchema();
    }

    default public @Nullable NamingIdentifyingFamily<@NotNull ? extends MsTable> getParentFamily() {
        return null;
    }

    @NotNull
    public @NotNull PositioningNamingFamily<@NotNull ? extends MsTableColumn> getColumns();

    @Override
    @NotNull
    public @NotNull PositioningNamingFamily<@NotNull ? extends MsIndex> getIndices();

    @Override
    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends MsKey> getKeys();

    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends MsForeignKey> getForeignKeys();

    @Override
    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends MsCheck> getChecks();

    @Override
    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends MsTrigger> getTriggers();

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Arrays.asList(ObjectKind.COLUMN, ObjectKind.INDEX, ObjectKind.KEY, ObjectKind.FOREIGN_KEY, ObjectKind.CHECK, ObjectKind.TRIGGER);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mssql/MsTable", "getFamilyKinds"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List<Family> list = Arrays.asList(this.getColumns(), this.getIndices(), this.getKeys(), this.getForeignKeys(), this.getChecks(), this.getTriggers());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mssql/MsTable", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull JBIterable<@NotNull ? extends BasicElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty().append(this.getColumns()).append((Iterable)this.getIndices()).append((Iterable)this.getKeys()).append((Iterable)this.getForeignKeys()).append((Iterable)this.getChecks()).append(this.getTriggers());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mssql/MsTable", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    default public long getObjectId() {
        return Long.MIN_VALUE;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    @Nullable
    default public Date getCreatedTimestamp() {
        return null;
    }

    @Override
    @Nullable
    default public Date getModifiedTimestamp() {
        return null;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        Date modifiedTimestamp;
        Date createdTimestamp;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name;
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/model/mssql/MsTable", "exportProperties"));
        }
        long objectId = this.getObjectId();
        if (objectId != Long.MIN_VALUE) {
            consumer.accept("ObjectId", PropertyConverter.export(objectId));
        }
        if ((name = this.getName()) != null && name != ModelConsts.NO_NAME) {
            consumer.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer.accept("NameScripted", PropertyConverter.export(nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer.accept("NameQuoted", PropertyConverter.export(nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", PropertyConverter.export(comment));
        }
        if ((createdTimestamp = this.getCreatedTimestamp()) != null) {
            consumer.accept("CreatedTimestamp", PropertyConverter.export(createdTimestamp));
        }
        if ((modifiedTimestamp = this.getModifiedTimestamp()) != null) {
            consumer.accept("ModifiedTimestamp", PropertyConverter.export(modifiedTimestamp));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("ObjectId", "Name", "NameSurrogate", "NameScripted", "NameQuoted", "Comment", "CreatedTimestamp", "ModifiedTimestamp");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mssql/MsTable", "getPropertyNames"));
        }
        return list;
    }
}

