/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.mssql;

import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLeaf;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.mssql.MsLikeStoredColumn;
import com.intellij.database.model.mssql.MsSchema;
import com.intellij.database.model.mssql.MsTableType;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MsTableTypeColumn
extends MsLikeStoredColumn,
BasicLeaf {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.COLUMN;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mssql/MsTableTypeColumn", "getKind"));
        }
        return objectKind;
    }

    @Nullable
    public MsTableType getTableType();

    @Override
    @Nullable
    default public MsTableType getDbParent() {
        return this.getTableType();
    }

    @Override
    @Nullable
    default public MsTableType getMajorObject() {
        return this.getTableType();
    }

    default public @Nullable PositioningNamingFamily<@NotNull ? extends MsTableTypeColumn> getParentFamily() {
        return null;
    }

    @Override
    @Nullable
    default public MsSchema getSchema() {
        MsTableType tableType = this.getTableType();
        return tableType != null ? tableType.getSchema() : null;
    }

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mssql/MsTableTypeColumn", "getFamilyKinds"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mssql/MsTableTypeColumn", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull JBIterable<@NotNull ? extends BasicElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mssql/MsTableTypeColumn", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    default public short getPosition() {
        return 0;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    @NotNull
    default public DataType getDataType() {
        DataType dataType = ModelConsts.NO_DATA_TYPE;
        if (dataType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mssql/MsTableTypeColumn", "getDataType"));
        }
        return dataType;
    }

    @Override
    default public boolean isNotNull() {
        return false;
    }

    @Override
    default public boolean isComputed() {
        return false;
    }

    @Override
    @Nullable
    default public String getDefaultExpression() {
        return null;
    }

    @Override
    @Nullable
    default public SequenceIdentity getSequenceIdentity() {
        return null;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        SequenceIdentity sequenceIdentity;
        String defaultExpression;
        boolean computed;
        boolean notNull;
        DataType dataType;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name;
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/model/mssql/MsTableTypeColumn", "exportProperties"));
        }
        short position = this.getPosition();
        if (position != 0) {
            consumer.accept("Position", PropertyConverter.export(position));
        }
        if ((name = this.getName()) != null && name != ModelConsts.NO_NAME) {
            consumer.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer.accept("NameScripted", PropertyConverter.export(nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer.accept("NameQuoted", PropertyConverter.export(nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", PropertyConverter.export(comment));
        }
        if ((dataType = this.getDataType()) != null && dataType != ModelConsts.NO_DATA_TYPE) {
            consumer.accept("DataType", PropertyConverter.export(dataType));
        }
        if (notNull = this.isNotNull()) {
            consumer.accept("NotNull", PropertyConverter.export(notNull));
        }
        if (computed = this.isComputed()) {
            consumer.accept("Computed", PropertyConverter.export(computed));
        }
        if ((defaultExpression = this.getDefaultExpression()) != null) {
            consumer.accept("DefaultExpression", PropertyConverter.export(defaultExpression));
        }
        if ((sequenceIdentity = this.getSequenceIdentity()) != null) {
            consumer.accept("SequenceIdentity", PropertyConverter.export(sequenceIdentity));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("Position", "Name", "NameSurrogate", "NameScripted", "NameQuoted", "Comment", "DataType", "NotNull", "Computed", "DefaultExpression", "SequenceIdentity");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mssql/MsTableTypeColumn", "getPropertyNames"));
        }
        return list;
    }
}

