/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.oracle;

import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.oracle.OraIndex;
import com.intellij.database.model.oracle.OraModLikeIndex;
import com.intellij.database.model.oracle.OraModSchema;
import com.intellij.database.model.oracle.OraModTable;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OraModIndex
extends OraIndex,
OraModLikeIndex {
    @Override
    @NotNull
    public OraModTable getTable();

    @Override
    @NotNull
    default public OraModTable getDbParent() {
        OraModTable oraModTable = this.getTable();
        if (oraModTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraModIndex", "getDbParent"));
        }
        return oraModTable;
    }

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends OraModIndex> getParentFamily();

    @Override
    @NotNull
    default public OraModSchema getSchema() {
        OraModSchema oraModSchema = this.getTable().getSchema();
        if (oraModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraModIndex", "getSchema"));
        }
        return oraModSchema;
    }

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraModIndex", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraModIndex", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setObjectId(long var1);

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setCreatedTimestamp(@Nullable Date var1);

    @Override
    public void setModifiedTimestamp(@Nullable Date var1);

    @Override
    public void setTablespaceName(@Nullable String var1);

    @Override
    public void setColNames(@NotNull List<String> var1);

    @Override
    default public void setColNames(String ... colNames) {
        this.setColNames(Arrays.asList(colNames));
    }

    @Override
    public void setReverseColNames(@NotNull Set<String> var1);

    @Override
    public void setUnique(boolean var1);

    public void setClustering(boolean var1);

    public void setFunctionBased(boolean var1);

    public void setBitmap(boolean var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/oracle/OraModIndex", "importProperties"));
        }
        String objectId = properties.get("ObjectId");
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String nameScripted = properties.get("NameScripted");
        String nameQuoted = properties.get("NameQuoted");
        String comment = properties.get("Comment");
        String createdTimestamp = properties.get("CreatedTimestamp");
        String modifiedTimestamp = properties.get("ModifiedTimestamp");
        String tablespaceName = properties.get("TablespaceName");
        String colNames = properties.get("ColNames");
        String reverseColNames = properties.get("ReverseColNames");
        String unique = properties.get("Unique");
        String clustering = properties.get("Clustering");
        String functionBased = properties.get("FunctionBased");
        String bitmap = properties.get("Bitmap");
        if (objectId != null) {
            this.setObjectId(PropertyConverter.importLong(objectId));
        }
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (nameScripted != null) {
            this.setNameScripted(PropertyConverter.importBoolean(nameScripted));
        }
        if (nameQuoted != null) {
            this.setNameQuoted(PropertyConverter.importBoolean(nameQuoted));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (createdTimestamp != null) {
            this.setCreatedTimestamp(PropertyConverter.importDate(createdTimestamp));
        }
        if (modifiedTimestamp != null) {
            this.setModifiedTimestamp(PropertyConverter.importDate(modifiedTimestamp));
        }
        if (tablespaceName != null) {
            this.setTablespaceName(PropertyConverter.importString(tablespaceName));
        }
        if (colNames != null) {
            this.setColNames(PropertyConverter.importListOfString(colNames));
        }
        if (reverseColNames != null) {
            this.setReverseColNames(PropertyConverter.importSetOfString(reverseColNames));
        }
        if (unique != null) {
            this.setUnique(PropertyConverter.importBoolean(unique));
        }
        if (clustering != null) {
            this.setClustering(PropertyConverter.importBoolean(clustering));
        }
        if (functionBased != null) {
            this.setFunctionBased(PropertyConverter.importBoolean(functionBased));
        }
        if (bitmap != null) {
            this.setBitmap(PropertyConverter.importBoolean(bitmap));
        }
    }
}

