/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.oracle;

import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModSingletonFamily;
import com.intellij.database.model.oracle.OraModModule;
import com.intellij.database.model.oracle.OraModPackageBody;
import com.intellij.database.model.oracle.OraModPackageRoutine;
import com.intellij.database.model.oracle.OraModSchema;
import com.intellij.database.model.oracle.OraPackage;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.properties.SourceError;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OraModPackage
extends OraPackage,
OraModModule {
    @Override
    @NotNull
    public OraModSchema getSchema();

    @Override
    @NotNull
    default public OraModSchema getDbParent() {
        OraModSchema oraModSchema = this.getSchema();
        if (oraModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraModPackage", "getDbParent"));
        }
        return oraModSchema;
    }

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends OraModPackage> getParentFamily();

    @Override
    @NotNull
    public ModSingletonFamily<? extends OraModPackageBody> getBodies();

    @Override
    @NotNull
    public ModNamingFamily<? extends OraModPackageRoutine> getRoutines();

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<ModFamily> list = Arrays.asList(this.getBodies(), this.getRoutines());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraModPackage", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty().append((Iterable)this.getBodies()).append((Iterable)this.getRoutines());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraModPackage", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setObjectId(long var1);

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setErrors(@NotNull List<SourceError> var1);

    @Override
    default public void setErrors(SourceError ... errors) {
        this.setErrors(Arrays.asList(errors));
    }

    @Override
    public void setInvalid(boolean var1);

    @Override
    public void setObfuscated(boolean var1);

    @Override
    public void setCreatedTimestamp(@Nullable Date var1);

    @Override
    public void setModifiedTimestamp(@Nullable Date var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/oracle/OraModPackage", "importProperties"));
        }
        String objectId = properties.get("ObjectId");
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String nameScripted = properties.get("NameScripted");
        String nameQuoted = properties.get("NameQuoted");
        String comment = properties.get("Comment");
        String invalid = properties.get("Invalid");
        String obfuscated = properties.get("Obfuscated");
        String createdTimestamp = properties.get("CreatedTimestamp");
        String modifiedTimestamp = properties.get("ModifiedTimestamp");
        if (objectId != null) {
            this.setObjectId(PropertyConverter.importLong(objectId));
        }
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (nameScripted != null) {
            this.setNameScripted(PropertyConverter.importBoolean(nameScripted));
        }
        if (nameQuoted != null) {
            this.setNameQuoted(PropertyConverter.importBoolean(nameQuoted));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (invalid != null) {
            this.setInvalid(PropertyConverter.importBoolean(invalid));
        }
        if (obfuscated != null) {
            this.setObfuscated(PropertyConverter.importBoolean(obfuscated));
        }
        if (createdTimestamp != null) {
            this.setCreatedTimestamp(PropertyConverter.importDate(createdTimestamp));
        }
        if (modifiedTimestamp != null) {
            this.setModifiedTimestamp(PropertyConverter.importDate(modifiedTimestamp));
        }
    }
}

