/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.oracle;

import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModSingletonFamily;
import com.intellij.database.model.oracle.OraModBody;
import com.intellij.database.model.oracle.OraModPackage;
import com.intellij.database.model.oracle.OraModSchema;
import com.intellij.database.model.oracle.OraPackageBody;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.properties.SourceError;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OraModPackageBody
extends OraPackageBody,
OraModBody {
    @Override
    @NotNull
    public OraModPackage getPackage();

    @Override
    @NotNull
    default public OraModPackage getDbParent() {
        OraModPackage oraModPackage = this.getPackage();
        if (oraModPackage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraModPackageBody", "getDbParent"));
        }
        return oraModPackage;
    }

    @Override
    @NotNull
    public ModSingletonFamily<? extends OraModPackageBody> getParentFamily();

    @Override
    @NotNull
    default public OraModSchema getSchema() {
        OraModSchema oraModSchema = this.getPackage().getSchema();
        if (oraModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraModPackageBody", "getSchema"));
        }
        return oraModSchema;
    }

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraModPackageBody", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraModPackageBody", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setObjectId(long var1);

    @Override
    public void setErrors(@NotNull List<SourceError> var1);

    @Override
    default public void setErrors(SourceError ... errors) {
        this.setErrors(Arrays.asList(errors));
    }

    @Override
    public void setInvalid(boolean var1);

    @Override
    public void setObfuscated(boolean var1);

    @Override
    public void setCreatedTimestamp(@Nullable Date var1);

    @Override
    public void setModifiedTimestamp(@Nullable Date var1);

    @Override
    public void setComment(@Nullable String var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/oracle/OraModPackageBody", "importProperties"));
        }
        String objectId = properties.get("ObjectId");
        String invalid = properties.get("Invalid");
        String obfuscated = properties.get("Obfuscated");
        String createdTimestamp = properties.get("CreatedTimestamp");
        String modifiedTimestamp = properties.get("ModifiedTimestamp");
        if (objectId != null) {
            this.setObjectId(PropertyConverter.importLong(objectId));
        }
        if (invalid != null) {
            this.setInvalid(PropertyConverter.importBoolean(invalid));
        }
        if (obfuscated != null) {
            this.setObfuscated(PropertyConverter.importBoolean(obfuscated));
        }
        if (createdTimestamp != null) {
            this.setCreatedTimestamp(PropertyConverter.importDate(createdTimestamp));
        }
        if (modifiedTimestamp != null) {
            this.setModifiedTimestamp(PropertyConverter.importDate(modifiedTimestamp));
        }
    }
}

