/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.oracle;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLeaf;
import com.intellij.database.model.basic.BasicSequence;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.oracle.OraMajorObject;
import com.intellij.database.model.oracle.OraSchema;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OraSequence
extends OraMajorObject,
BasicSequence,
BasicLeaf {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.SEQUENCE;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraSequence", "getKind"));
        }
        return objectKind;
    }

    @Override
    @Nullable
    public OraSchema getSchema();

    @Override
    @Nullable
    default public OraSchema getDbParent() {
        return this.getSchema();
    }

    default public @Nullable NamingIdentifyingFamily<@NotNull ? extends OraSequence> getParentFamily() {
        return null;
    }

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraSequence", "getFamilyKinds"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraSequence", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull JBIterable<@NotNull ? extends BasicElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraSequence", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    default public long getObjectId() {
        return Long.MIN_VALUE;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    @Nullable
    default public Date getCreatedTimestamp() {
        return null;
    }

    @Override
    @Nullable
    default public Date getModifiedTimestamp() {
        return null;
    }

    @Override
    @Nullable
    default public SequenceIdentity getSequenceIdentity() {
        return null;
    }

    @Override
    default public boolean isBelongsToColumn() {
        return false;
    }

    default public boolean isOrdered() {
        return false;
    }

    default public boolean isCycled() {
        return false;
    }

    default public int getCacheSize() {
        return 0;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        int cacheSize;
        boolean cycled;
        boolean ordered;
        boolean belongsToColumn;
        SequenceIdentity sequenceIdentity;
        Date modifiedTimestamp;
        Date createdTimestamp;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name;
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/model/oracle/OraSequence", "exportProperties"));
        }
        long objectId = this.getObjectId();
        if (objectId != Long.MIN_VALUE) {
            consumer.accept("ObjectId", PropertyConverter.export(objectId));
        }
        if ((name = this.getName()) != null && name != ModelConsts.NO_NAME) {
            consumer.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer.accept("NameScripted", PropertyConverter.export(nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer.accept("NameQuoted", PropertyConverter.export(nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", PropertyConverter.export(comment));
        }
        if ((createdTimestamp = this.getCreatedTimestamp()) != null) {
            consumer.accept("CreatedTimestamp", PropertyConverter.export(createdTimestamp));
        }
        if ((modifiedTimestamp = this.getModifiedTimestamp()) != null) {
            consumer.accept("ModifiedTimestamp", PropertyConverter.export(modifiedTimestamp));
        }
        if ((sequenceIdentity = this.getSequenceIdentity()) != null) {
            consumer.accept("SequenceIdentity", PropertyConverter.export(sequenceIdentity));
        }
        if (belongsToColumn = this.isBelongsToColumn()) {
            consumer.accept("BelongsToColumn", PropertyConverter.export(belongsToColumn));
        }
        if (ordered = this.isOrdered()) {
            consumer.accept("Ordered", PropertyConverter.export(ordered));
        }
        if (cycled = this.isCycled()) {
            consumer.accept("Cycled", PropertyConverter.export(cycled));
        }
        if ((cacheSize = this.getCacheSize()) != 0) {
            consumer.accept("CacheSize", PropertyConverter.export(cacheSize));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("ObjectId", "Name", "NameSurrogate", "NameScripted", "NameQuoted", "Comment", "CreatedTimestamp", "ModifiedTimestamp", "SequenceIdentity", "BelongsToColumn", "Ordered", "Cycled", "CacheSize");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraSequence", "getPropertyNames"));
        }
        return list;
    }
}

