/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.postgres;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.postgres.PostgresDefTypeAttribute;
import com.intellij.database.model.postgres.PostgresDefTypeCheck;
import com.intellij.database.model.postgres.PostgresSchema;
import com.intellij.database.model.postgresbase.PostgresBaseDefType;
import com.intellij.database.model.properties.PostgresDataTypeSubCategory;
import com.intellij.database.model.properties.PostgresDataTypeSubKind;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PostgresDefType
extends PostgresBaseDefType,
BasicMajorObject,
BasicIdentifiedElement,
BasicNamedElement {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.OBJECT_TYPE;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresDefType", "getKind"));
        }
        return objectKind;
    }

    @Override
    @Nullable
    public PostgresSchema getSchema();

    @Override
    @Nullable
    default public PostgresSchema getDbParent() {
        return this.getSchema();
    }

    default public @Nullable NamingIdentifyingFamily<@NotNull ? extends PostgresDefType> getParentFamily() {
        return null;
    }

    @NotNull
    public @NotNull PositioningNamingFamily<@NotNull ? extends PostgresDefTypeAttribute> getAttributes();

    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends PostgresDefTypeCheck> getChecks();

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Arrays.asList(ObjectKind.OBJECT_ATTRIBUTE, ObjectKind.CHECK);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresDefType", "getFamilyKinds"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List<Family> list = Arrays.asList(this.getAttributes(), this.getChecks());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresDefType", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull JBIterable<@NotNull ? extends BasicElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty().append(this.getAttributes()).append(this.getChecks());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresDefType", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    default public long getObjectId() {
        return Long.MIN_VALUE;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    default public long getStateNumber() {
        return 0L;
    }

    @Override
    @NotNull
    default public PostgresDataTypeSubKind getSubKind() {
        PostgresDataTypeSubKind postgresDataTypeSubKind = PostgresDataTypeSubKind.NONE;
        if (postgresDataTypeSubKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresDefType", "getSubKind"));
        }
        return postgresDataTypeSubKind;
    }

    @NotNull
    default public PostgresDataTypeSubCategory getSubCategory() {
        PostgresDataTypeSubCategory postgresDataTypeSubCategory = PostgresDataTypeSubCategory.NONE;
        if (postgresDataTypeSubCategory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresDefType", "getSubCategory"));
        }
        return postgresDataTypeSubCategory;
    }

    @Override
    @Nullable
    default public String getDefinition() {
        return null;
    }

    @NotNull
    default public List<String> getLabels() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresDefType", "getLabels"));
        }
        return list;
    }

    @Override
    @Nullable
    default public String getDefaultExpression() {
        return null;
    }

    @Override
    default public boolean isNotNull() {
        return false;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        boolean notNull;
        String defaultExpression;
        List<String> labels2;
        String definition;
        PostgresDataTypeSubCategory subCategory;
        PostgresDataTypeSubKind subKind;
        long stateNumber;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name;
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/model/postgres/PostgresDefType", "exportProperties"));
        }
        long objectId = this.getObjectId();
        if (objectId != Long.MIN_VALUE) {
            consumer.accept("ObjectId", PropertyConverter.export(objectId));
        }
        if ((name = this.getName()) != null && name != ModelConsts.NO_NAME) {
            consumer.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer.accept("NameScripted", PropertyConverter.export(nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer.accept("NameQuoted", PropertyConverter.export(nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", PropertyConverter.export(comment));
        }
        if ((stateNumber = this.getStateNumber()) != 0L) {
            consumer.accept("StateNumber", PropertyConverter.export(stateNumber));
        }
        if ((subKind = this.getSubKind()) != null && subKind != PostgresDataTypeSubKind.NONE) {
            consumer.accept("SubKind", PropertyConverter.export(subKind));
        }
        if ((subCategory = this.getSubCategory()) != null && subCategory != PostgresDataTypeSubCategory.NONE) {
            consumer.accept("SubCategory", PropertyConverter.export(subCategory));
        }
        if ((definition = this.getDefinition()) != null) {
            consumer.accept("Definition", PropertyConverter.export(definition));
        }
        if (!(labels2 = this.getLabels()).isEmpty()) {
            consumer.accept("Labels", PropertyConverter.exportListOfString(labels2));
        }
        if ((defaultExpression = this.getDefaultExpression()) != null) {
            consumer.accept("DefaultExpression", PropertyConverter.export(defaultExpression));
        }
        if (notNull = this.isNotNull()) {
            consumer.accept("NotNull", PropertyConverter.export(notNull));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("ObjectId", "Name", "NameSurrogate", "NameScripted", "NameQuoted", "Comment", "StateNumber", "SubKind", "SubCategory", "Definition", "Labels", "DefaultExpression", "NotNull");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresDefType", "getPropertyNames"));
        }
        return list;
    }
}

