/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.postgres;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLeaf;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.postgres.PostgresLikeStoredTable;
import com.intellij.database.model.postgres.PostgresLikeTrigger;
import com.intellij.database.model.postgres.PostgresSchema;
import com.intellij.database.model.properties.PostgresFireMode;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.properties.TrigEvent;
import com.intellij.database.model.properties.TrigTurn;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PostgresTrigger
extends PostgresLikeTrigger,
BasicLeaf {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.TRIGGER;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresTrigger", "getKind"));
        }
        return objectKind;
    }

    @Nullable
    public PostgresLikeStoredTable getLikeStoredTable();

    @Override
    @Nullable
    default public PostgresLikeStoredTable getDbParent() {
        return this.getLikeStoredTable();
    }

    @Override
    @Nullable
    default public PostgresLikeStoredTable getMajorObject() {
        return this.getLikeStoredTable();
    }

    default public @Nullable NamingIdentifyingFamily<@NotNull ? extends PostgresTrigger> getParentFamily() {
        return null;
    }

    @Nullable
    default public PostgresSchema getSchema() {
        PostgresLikeStoredTable likeStoredTable = this.getLikeStoredTable();
        return likeStoredTable != null ? likeStoredTable.getSchema() : null;
    }

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresTrigger", "getFamilyKinds"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresTrigger", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull JBIterable<@NotNull ? extends BasicElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresTrigger", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    default public long getObjectId() {
        return Long.MIN_VALUE;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    default public long getStateNumber() {
        return 0L;
    }

    @Override
    @Nullable
    default public TrigTurn getTurn() {
        return null;
    }

    @Override
    @NotNull
    default public Set<TrigEvent> getEvents() {
        Set<TrigEvent> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresTrigger", "getEvents"));
        }
        return set;
    }

    @Override
    @Nullable
    default public String getCondition() {
        return null;
    }

    @Override
    @Nullable
    default public PostgresFireMode getFireMode() {
        return null;
    }

    default public long getCallRoutineId() {
        return 0L;
    }

    default public boolean isDeferrable() {
        return false;
    }

    default public boolean isInitiallyDeferred() {
        return false;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        boolean initiallyDeferred;
        boolean deferrable;
        long callRoutineId;
        PostgresFireMode fireMode;
        String condition;
        Set<TrigEvent> events;
        TrigTurn turn;
        long stateNumber;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name;
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/model/postgres/PostgresTrigger", "exportProperties"));
        }
        long objectId = this.getObjectId();
        if (objectId != Long.MIN_VALUE) {
            consumer.accept("ObjectId", PropertyConverter.export(objectId));
        }
        if ((name = this.getName()) != null && name != ModelConsts.NO_NAME) {
            consumer.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer.accept("NameScripted", PropertyConverter.export(nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer.accept("NameQuoted", PropertyConverter.export(nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", PropertyConverter.export(comment));
        }
        if ((stateNumber = this.getStateNumber()) != 0L) {
            consumer.accept("StateNumber", PropertyConverter.export(stateNumber));
        }
        if ((turn = this.getTurn()) != null) {
            consumer.accept("Turn", PropertyConverter.export(turn));
        }
        if (!(events = this.getEvents()).isEmpty()) {
            consumer.accept("Events", PropertyConverter.exportSetOfTrigEvent(events));
        }
        if ((condition = this.getCondition()) != null) {
            consumer.accept("Condition", PropertyConverter.export(condition));
        }
        if ((fireMode = this.getFireMode()) != null) {
            consumer.accept("FireMode", PropertyConverter.export(fireMode));
        }
        if ((callRoutineId = this.getCallRoutineId()) != 0L) {
            consumer.accept("CallRoutineId", PropertyConverter.export(callRoutineId));
        }
        if (deferrable = this.isDeferrable()) {
            consumer.accept("Deferrable", PropertyConverter.export(deferrable));
        }
        if (initiallyDeferred = this.isInitiallyDeferred()) {
            consumer.accept("InitiallyDeferred", PropertyConverter.export(initiallyDeferred));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("ObjectId", "Name", "NameSurrogate", "NameScripted", "NameQuoted", "Comment", "StateNumber", "Turn", "Events", "Condition", "FireMode", "CallRoutineId", "Deferrable", "InitiallyDeferred");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresTrigger", "getPropertyNames"));
        }
        return list;
    }
}

