/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.postgres;

import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicArrangedElement;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLeaf;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.postgres.PostgresSchema;
import com.intellij.database.model.postgres.PostgresView;
import com.intellij.database.model.postgresbase.PostgresBaseViewColumn;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PostgresViewColumn
extends PostgresBaseViewColumn,
BasicArrangedElement,
BasicNamedElement,
BasicLeaf {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.COLUMN;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresViewColumn", "getKind"));
        }
        return objectKind;
    }

    @Nullable
    public PostgresView getView();

    @Override
    @Nullable
    default public PostgresView getDbParent() {
        return this.getView();
    }

    @Override
    @Nullable
    default public PostgresView getMajorObject() {
        return this.getView();
    }

    default public @Nullable PositioningNamingFamily<@NotNull ? extends PostgresViewColumn> getParentFamily() {
        return null;
    }

    @Override
    @Nullable
    default public PostgresSchema getSchema() {
        PostgresView view2 = this.getView();
        return view2 != null ? view2.getSchema() : null;
    }

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresViewColumn", "getFamilyKinds"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresViewColumn", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull JBIterable<@NotNull ? extends BasicElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresViewColumn", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    default public short getPosition() {
        return 0;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    @NotNull
    default public DataType getDataType() {
        DataType dataType = ModelConsts.NO_DATA_TYPE;
        if (dataType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresViewColumn", "getDataType"));
        }
        return dataType;
    }

    @Override
    default public boolean isNotNull() {
        return false;
    }

    @Override
    default public long getStateNumber() {
        return 0L;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        long stateNumber;
        boolean notNull;
        DataType dataType;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name;
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/model/postgres/PostgresViewColumn", "exportProperties"));
        }
        short position = this.getPosition();
        if (position != 0) {
            consumer.accept("Position", PropertyConverter.export(position));
        }
        if ((name = this.getName()) != null && name != ModelConsts.NO_NAME) {
            consumer.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer.accept("NameScripted", PropertyConverter.export(nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer.accept("NameQuoted", PropertyConverter.export(nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", PropertyConverter.export(comment));
        }
        if ((dataType = this.getDataType()) != null && dataType != ModelConsts.NO_DATA_TYPE) {
            consumer.accept("DataType", PropertyConverter.export(dataType));
        }
        if (notNull = this.isNotNull()) {
            consumer.accept("NotNull", PropertyConverter.export(notNull));
        }
        if ((stateNumber = this.getStateNumber()) != 0L) {
            consumer.accept("StateNumber", PropertyConverter.export(stateNumber));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("Position", "Name", "NameSurrogate", "NameScripted", "NameQuoted", "Comment", "DataType", "NotNull", "StateNumber");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresViewColumn", "getPropertyNames"));
        }
        return list;
    }
}

