/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.properties;

import com.intellij.database.model.DasRoutine;
import org.jetbrains.annotations.NotNull;

public enum JdbcProcedureType {
    UNKNOWN,
    NO_RESULT,
    HAS_RESULT;


    @NotNull
    public DasRoutine.Kind getKind() {
        DasRoutine.Kind kind = this == NO_RESULT ? DasRoutine.Kind.PROCEDURE : (this == HAS_RESULT ? DasRoutine.Kind.FUNCTION : DasRoutine.Kind.NONE);
        if (kind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/properties/JdbcProcedureType", "getKind"));
        }
        return kind;
    }

    public int getID() {
        switch (this) {
            case UNKNOWN: {
                return 0;
            }
            case NO_RESULT: {
                return 1;
            }
            case HAS_RESULT: {
                return 2;
            }
        }
        return 0;
    }

    public static JdbcProcedureType findByID(int id) {
        switch (id) {
            case 0: {
                return UNKNOWN;
            }
            case 1: {
                return NO_RESULT;
            }
            case 2: {
                return HAS_RESULT;
            }
        }
        return UNKNOWN;
    }
}

