/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.redshift;

import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.postgresbase.PostgresBaseModDatabase;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.redshift.RedshiftDatabase;
import com.intellij.database.model.redshift.RedshiftModRoot;
import com.intellij.database.model.redshift.RedshiftModSchema;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RedshiftModDatabase
extends RedshiftDatabase,
PostgresBaseModDatabase,
BasicModIdentifiedElement,
BasicModNamedElement {
    @Override
    @NotNull
    public RedshiftModRoot getRoot();

    @Override
    @NotNull
    default public RedshiftModRoot getDbParent() {
        RedshiftModRoot redshiftModRoot = this.getRoot();
        if (redshiftModRoot == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/redshift/RedshiftModDatabase", "getDbParent"));
        }
        return redshiftModRoot;
    }

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends RedshiftModDatabase> getParentFamily();

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends RedshiftModSchema> getSchemas();

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<NamingIdentifyingFamily> list = Collections.singletonList(this.getSchemas());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/redshift/RedshiftModDatabase", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.from((Iterable)this.getSchemas());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/redshift/RedshiftModDatabase", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setObjectId(long var1);

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setCurrent(boolean var1);

    @Override
    public void setVisible(boolean var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/redshift/RedshiftModDatabase", "importProperties"));
        }
        String objectId = properties.get("ObjectId");
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String nameScripted = properties.get("NameScripted");
        String nameQuoted = properties.get("NameQuoted");
        String comment = properties.get("Comment");
        String current = properties.get("Current");
        String visible = properties.get("Visible");
        if (objectId != null) {
            this.setObjectId(PropertyConverter.importLong(objectId));
        }
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (nameScripted != null) {
            this.setNameScripted(PropertyConverter.importBoolean(nameScripted));
        }
        if (nameQuoted != null) {
            this.setNameQuoted(PropertyConverter.importBoolean(nameQuoted));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (current != null) {
            this.setCurrent(PropertyConverter.importBoolean(current));
        }
        if (visible != null) {
            this.setVisible(PropertyConverter.importBoolean(visible));
        }
    }
}

