/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.redshift;

import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.postgresbase.PostgresBaseModDefType;
import com.intellij.database.model.properties.PostgresDataTypeSubKind;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.redshift.RedshiftDefType;
import com.intellij.database.model.redshift.RedshiftModDefTypeAttribute;
import com.intellij.database.model.redshift.RedshiftModSchema;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RedshiftModDefType
extends RedshiftDefType,
PostgresBaseModDefType,
BasicModIdentifiedElement,
BasicModNamedElement {
    @Override
    @NotNull
    public RedshiftModSchema getSchema();

    @Override
    @NotNull
    default public RedshiftModSchema getDbParent() {
        RedshiftModSchema redshiftModSchema = this.getSchema();
        if (redshiftModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/redshift/RedshiftModDefType", "getDbParent"));
        }
        return redshiftModSchema;
    }

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends RedshiftModDefType> getParentFamily();

    @Override
    @NotNull
    public ModPositioningNamingFamily<? extends RedshiftModDefTypeAttribute> getAttributes();

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<PositioningNamingFamily> list = Collections.singletonList(this.getAttributes());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/redshift/RedshiftModDefType", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.from((Iterable)this.getAttributes());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/redshift/RedshiftModDefType", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setObjectId(long var1);

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setStateNumber(long var1);

    @Override
    public void setSubKind(@NotNull PostgresDataTypeSubKind var1);

    @Override
    public void setDefinition(@Nullable String var1);

    @Override
    public void setDefaultExpression(@Nullable String var1);

    @Override
    public void setNotNull(boolean var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/redshift/RedshiftModDefType", "importProperties"));
        }
        String objectId = properties.get("ObjectId");
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String nameScripted = properties.get("NameScripted");
        String nameQuoted = properties.get("NameQuoted");
        String comment = properties.get("Comment");
        String stateNumber = properties.get("StateNumber");
        String subKind = properties.get("SubKind");
        String definition = properties.get("Definition");
        String defaultExpression = properties.get("DefaultExpression");
        String notNull = properties.get("NotNull");
        if (objectId != null) {
            this.setObjectId(PropertyConverter.importLong(objectId));
        }
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (nameScripted != null) {
            this.setNameScripted(PropertyConverter.importBoolean(nameScripted));
        }
        if (nameQuoted != null) {
            this.setNameQuoted(PropertyConverter.importBoolean(nameQuoted));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (stateNumber != null) {
            this.setStateNumber(PropertyConverter.importLong(stateNumber));
        }
        if (subKind != null) {
            this.setSubKind(PropertyConverter.importPostgresDataTypeSubKind(subKind));
        }
        if (definition != null) {
            this.setDefinition(PropertyConverter.importString(definition));
        }
        if (defaultExpression != null) {
            this.setDefaultExpression(PropertyConverter.importString(defaultExpression));
        }
        if (notNull != null) {
            this.setNotNull(PropertyConverter.importBoolean(notNull));
        }
    }
}

