/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.redshift;

import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.postgresbase.PostgresBaseModForeignKey;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.redshift.RedshiftForeignKey;
import com.intellij.database.model.redshift.RedshiftModSchema;
import com.intellij.database.model.redshift.RedshiftModTable;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RedshiftModForeignKey
extends RedshiftForeignKey,
PostgresBaseModForeignKey,
BasicModIdentifiedElement,
BasicModNamedElement {
    @Override
    @NotNull
    public RedshiftModTable getTable();

    @Override
    @NotNull
    default public RedshiftModTable getDbParent() {
        RedshiftModTable redshiftModTable = this.getTable();
        if (redshiftModTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/redshift/RedshiftModForeignKey", "getDbParent"));
        }
        return redshiftModTable;
    }

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends RedshiftModForeignKey> getParentFamily();

    @Override
    @NotNull
    default public RedshiftModSchema getSchema() {
        RedshiftModSchema redshiftModSchema = this.getTable().getSchema();
        if (redshiftModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/redshift/RedshiftModForeignKey", "getSchema"));
        }
        return redshiftModSchema;
    }

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/redshift/RedshiftModForeignKey", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/redshift/RedshiftModForeignKey", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setObjectId(long var1);

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setColNames(@NotNull List<String> var1);

    @Override
    default public void setColNames(String ... colNames) {
        this.setColNames(Arrays.asList(colNames));
    }

    @Override
    public void setRefTableId(long var1);

    @Override
    public void setRefColPositions(@NotNull List<Short> var1);

    @Override
    default public void setRefColPositions(Short ... refColPositions) {
        this.setRefColPositions(Arrays.asList(refColPositions));
    }

    @Override
    public void setRefSchemaName(@Nullable String var1);

    @Override
    public void setRefTableName(@Nullable String var1);

    @Override
    public void setRefKeyName(@Nullable String var1);

    @Override
    public void setRefColNames(@NotNull List<String> var1);

    @Override
    default public void setRefColNames(String ... refColNames) {
        this.setRefColNames(Arrays.asList(refColNames));
    }

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/redshift/RedshiftModForeignKey", "importProperties"));
        }
        String objectId = properties.get("ObjectId");
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String nameScripted = properties.get("NameScripted");
        String nameQuoted = properties.get("NameQuoted");
        String comment = properties.get("Comment");
        String colNames = properties.get("ColNames");
        String refTableId = properties.get("RefTableId");
        String refColPositions = properties.get("RefColPositions");
        String refSchemaName = properties.get("RefSchemaName");
        String refTableName = properties.get("RefTableName");
        String refKeyName = properties.get("RefKeyName");
        String refColNames = properties.get("RefColNames");
        if (objectId != null) {
            this.setObjectId(PropertyConverter.importLong(objectId));
        }
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (nameScripted != null) {
            this.setNameScripted(PropertyConverter.importBoolean(nameScripted));
        }
        if (nameQuoted != null) {
            this.setNameQuoted(PropertyConverter.importBoolean(nameQuoted));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (colNames != null) {
            this.setColNames(PropertyConverter.importListOfString(colNames));
        }
        if (refTableId != null) {
            this.setRefTableId(PropertyConverter.importLong(refTableId));
        }
        if (refColPositions != null) {
            this.setRefColPositions(PropertyConverter.importListOfShort(refColPositions));
        }
        if (refSchemaName != null) {
            this.setRefSchemaName(PropertyConverter.importString(refSchemaName));
        }
        if (refTableName != null) {
            this.setRefTableName(PropertyConverter.importString(refTableName));
        }
        if (refKeyName != null) {
            this.setRefKeyName(PropertyConverter.importString(refKeyName));
        }
        if (refColNames != null) {
            this.setRefColNames(PropertyConverter.importListOfString(refColNames));
        }
    }
}

