/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.redshift;

import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.postgresbase.PostgresBaseModSchema;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.redshift.RedshiftModDatabase;
import com.intellij.database.model.redshift.RedshiftModDefType;
import com.intellij.database.model.redshift.RedshiftModOperator;
import com.intellij.database.model.redshift.RedshiftModRoutine;
import com.intellij.database.model.redshift.RedshiftModTable;
import com.intellij.database.model.redshift.RedshiftModView;
import com.intellij.database.model.redshift.RedshiftSchema;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RedshiftModSchema
extends RedshiftSchema,
PostgresBaseModSchema,
BasicModIdentifiedElement,
BasicModNamedElement {
    @Override
    @NotNull
    public RedshiftModDatabase getDatabase();

    @Override
    @NotNull
    default public RedshiftModDatabase getDbParent() {
        RedshiftModDatabase redshiftModDatabase = this.getDatabase();
        if (redshiftModDatabase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/redshift/RedshiftModSchema", "getDbParent"));
        }
        return redshiftModDatabase;
    }

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends RedshiftModSchema> getParentFamily();

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends RedshiftModDefType> getDefTypes();

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends RedshiftModTable> getTables();

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends RedshiftModView> getViews();

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends RedshiftModRoutine> getRoutines();

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends RedshiftModOperator> getOperators();

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<ModFamily> list = Arrays.asList(this.getDefTypes(), this.getTables(), this.getViews(), this.getRoutines(), this.getOperators());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/redshift/RedshiftModSchema", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty().append((Iterable)this.getDefTypes()).append((Iterable)this.getTables()).append((Iterable)this.getViews()).append((Iterable)this.getRoutines()).append((Iterable)this.getOperators());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/redshift/RedshiftModSchema", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setObjectId(long var1);

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setIntrospectionTimestamp(@Nullable Date var1);

    @Override
    public void setIntrospectionStateNumber(long var1);

    @Override
    public void setCurrent(boolean var1);

    @Override
    public void setVisible(boolean var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/redshift/RedshiftModSchema", "importProperties"));
        }
        String objectId = properties.get("ObjectId");
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String nameScripted = properties.get("NameScripted");
        String nameQuoted = properties.get("NameQuoted");
        String comment = properties.get("Comment");
        String introspectionTimestamp = properties.get("IntrospectionTimestamp");
        String introspectionStateNumber = properties.get("IntrospectionStateNumber");
        String current = properties.get("Current");
        String visible = properties.get("Visible");
        if (objectId != null) {
            this.setObjectId(PropertyConverter.importLong(objectId));
        }
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (nameScripted != null) {
            this.setNameScripted(PropertyConverter.importBoolean(nameScripted));
        }
        if (nameQuoted != null) {
            this.setNameQuoted(PropertyConverter.importBoolean(nameQuoted));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (introspectionTimestamp != null) {
            this.setIntrospectionTimestamp(PropertyConverter.importDate(introspectionTimestamp));
        }
        if (introspectionStateNumber != null) {
            this.setIntrospectionStateNumber(PropertyConverter.importLong(introspectionStateNumber));
        }
        if (current != null) {
            this.setCurrent(PropertyConverter.importBoolean(current));
        }
        if (visible != null) {
            this.setVisible(PropertyConverter.importBoolean(visible));
        }
    }
}

