/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.redshift;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.postgresbase.PostgresBaseTable;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.properties.RedshiftTableBackupMode;
import com.intellij.database.model.properties.RedshiftTableDistStyle;
import com.intellij.database.model.redshift.RedshiftForeignKey;
import com.intellij.database.model.redshift.RedshiftKey;
import com.intellij.database.model.redshift.RedshiftLikeStoredTable;
import com.intellij.database.model.redshift.RedshiftSchema;
import com.intellij.database.model.redshift.RedshiftTableColumn;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RedshiftTable
extends RedshiftLikeStoredTable,
PostgresBaseTable {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.TABLE;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/redshift/RedshiftTable", "getKind"));
        }
        return objectKind;
    }

    @Override
    @Nullable
    public RedshiftSchema getSchema();

    @Override
    @Nullable
    default public RedshiftSchema getDbParent() {
        return this.getSchema();
    }

    default public @Nullable NamingIdentifyingFamily<@NotNull ? extends RedshiftTable> getParentFamily() {
        return null;
    }

    @NotNull
    public @NotNull PositioningNamingFamily<@NotNull ? extends RedshiftTableColumn> getColumns();

    @Override
    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends RedshiftKey> getKeys();

    @Override
    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends RedshiftForeignKey> getForeignKeys();

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Arrays.asList(ObjectKind.COLUMN, ObjectKind.KEY, ObjectKind.FOREIGN_KEY);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/redshift/RedshiftTable", "getFamilyKinds"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List<Family> list = Arrays.asList(this.getColumns(), this.getKeys(), this.getForeignKeys());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/redshift/RedshiftTable", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull JBIterable<@NotNull ? extends BasicElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty().append(this.getColumns()).append((Iterable)this.getKeys()).append((Iterable)this.getForeignKeys());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/redshift/RedshiftTable", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    default public long getObjectId() {
        return Long.MIN_VALUE;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    default public boolean isSystem() {
        return false;
    }

    @Override
    default public long getStateNumber() {
        return 0L;
    }

    @NotNull
    default public RedshiftTableDistStyle getDistStyle() {
        RedshiftTableDistStyle redshiftTableDistStyle = RedshiftTableDistStyle.EVEN;
        if (redshiftTableDistStyle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/redshift/RedshiftTable", "getDistStyle"));
        }
        return redshiftTableDistStyle;
    }

    @NotNull
    default public RedshiftTableBackupMode getBackupMode() {
        RedshiftTableBackupMode redshiftTableBackupMode = RedshiftTableBackupMode.ON;
        if (redshiftTableBackupMode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/redshift/RedshiftTable", "getBackupMode"));
        }
        return redshiftTableBackupMode;
    }

    @Override
    default public boolean isTemporary() {
        return false;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        boolean temporary;
        RedshiftTableBackupMode backupMode;
        RedshiftTableDistStyle distStyle;
        long stateNumber;
        boolean system;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name;
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/model/redshift/RedshiftTable", "exportProperties"));
        }
        long objectId = this.getObjectId();
        if (objectId != Long.MIN_VALUE) {
            consumer.accept("ObjectId", PropertyConverter.export(objectId));
        }
        if ((name = this.getName()) != null && name != ModelConsts.NO_NAME) {
            consumer.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer.accept("NameScripted", PropertyConverter.export(nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer.accept("NameQuoted", PropertyConverter.export(nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", PropertyConverter.export(comment));
        }
        if (system = this.isSystem()) {
            consumer.accept("System", PropertyConverter.export(system));
        }
        if ((stateNumber = this.getStateNumber()) != 0L) {
            consumer.accept("StateNumber", PropertyConverter.export(stateNumber));
        }
        if ((distStyle = this.getDistStyle()) != null && distStyle != RedshiftTableDistStyle.EVEN) {
            consumer.accept("DistStyle", PropertyConverter.export(distStyle));
        }
        if ((backupMode = this.getBackupMode()) != null && backupMode != RedshiftTableBackupMode.ON) {
            consumer.accept("BackupMode", PropertyConverter.export(backupMode));
        }
        if (temporary = this.isTemporary()) {
            consumer.accept("Temporary", PropertyConverter.export(temporary));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("ObjectId", "Name", "NameSurrogate", "NameScripted", "NameQuoted", "Comment", "System", "StateNumber", "DistStyle", "BackupMode", "Temporary");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/redshift/RedshiftTable", "getPropertyNames"));
        }
        return list;
    }
}

