/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.sqlite;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicLeaf;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicSchemaObject;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.sqlite.SqliteSchema;
import com.intellij.database.model.sqlite.SqliteTable;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SqliteIndex
extends BasicNamedElement,
BasicIndex,
BasicSchemaObject,
BasicLeaf {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.INDEX;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sqlite/SqliteIndex", "getKind"));
        }
        return objectKind;
    }

    @Override
    @Nullable
    public SqliteTable getTable();

    @Override
    @Nullable
    default public SqliteTable getDbParent() {
        return this.getTable();
    }

    @Override
    @Nullable
    default public SqliteTable getMajorObject() {
        return this.getTable();
    }

    default public @Nullable NamingFamily<@NotNull ? extends SqliteIndex> getParentFamily() {
        return null;
    }

    @Override
    @Nullable
    default public SqliteSchema getSchema() {
        SqliteTable table = this.getTable();
        return table != null ? table.getSchema() : null;
    }

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sqlite/SqliteIndex", "getFamilyKinds"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sqlite/SqliteIndex", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull JBIterable<@NotNull ? extends BasicElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sqlite/SqliteIndex", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    @NotNull
    default public List<String> getColNames() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sqlite/SqliteIndex", "getColNames"));
        }
        return list;
    }

    @Override
    @NotNull
    default public Set<String> getReverseColNames() {
        Set<String> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sqlite/SqliteIndex", "getReverseColNames"));
        }
        return set;
    }

    @NotNull
    default public List<String> getColumnCollations() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sqlite/SqliteIndex", "getColumnCollations"));
        }
        return list;
    }

    @Override
    default public boolean isUnique() {
        return false;
    }

    @Override
    @Nullable
    default public String getCondition() {
        return null;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        String condition;
        boolean unique;
        List<String> columnCollations;
        Set<String> reverseColNames;
        List<String> colNames;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/model/sqlite/SqliteIndex", "exportProperties"));
        }
        String name = this.getName();
        if (name != null && name != ModelConsts.NO_NAME) {
            consumer.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer.accept("NameScripted", PropertyConverter.export(nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer.accept("NameQuoted", PropertyConverter.export(nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", PropertyConverter.export(comment));
        }
        if (!(colNames = this.getColNames()).isEmpty()) {
            consumer.accept("ColNames", PropertyConverter.exportListOfString(colNames));
        }
        if (!(reverseColNames = this.getReverseColNames()).isEmpty()) {
            consumer.accept("ReverseColNames", PropertyConverter.exportSetOfString(reverseColNames));
        }
        if (!(columnCollations = this.getColumnCollations()).isEmpty()) {
            consumer.accept("ColumnCollations", PropertyConverter.exportListOfString(columnCollations));
        }
        if (unique = this.isUnique()) {
            consumer.accept("Unique", PropertyConverter.export(unique));
        }
        if ((condition = this.getCondition()) != null) {
            consumer.accept("Condition", PropertyConverter.export(condition));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("Name", "NameSurrogate", "NameScripted", "NameQuoted", "Comment", "ColNames", "ReverseColNames", "ColumnCollations", "Unique", "Condition");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sqlite/SqliteIndex", "getPropertyNames"));
        }
        return list;
    }
}

