/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.sqlite;

import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.sqlite.SqliteModLikeTable;
import com.intellij.database.model.sqlite.SqliteModSchema;
import com.intellij.database.model.sqlite.SqliteModSourceAware;
import com.intellij.database.model.sqlite.SqliteModTrigger;
import com.intellij.database.model.sqlite.SqliteModViewColumn;
import com.intellij.database.model.sqlite.SqliteView;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SqliteModView
extends SqliteView,
SqliteModLikeTable,
SqliteModSourceAware {
    @Override
    @NotNull
    public SqliteModSchema getSchema();

    @Override
    @NotNull
    default public SqliteModSchema getDbParent() {
        SqliteModSchema sqliteModSchema = this.getSchema();
        if (sqliteModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sqlite/SqliteModView", "getDbParent"));
        }
        return sqliteModSchema;
    }

    @Override
    @NotNull
    public ModNamingFamily<? extends SqliteModView> getParentFamily();

    @Override
    @NotNull
    public ModNamingFamily<? extends SqliteModTrigger> getTriggers();

    @Override
    @NotNull
    public ModPositioningNamingFamily<? extends SqliteModViewColumn> getColumns();

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<ModFamily> list = Arrays.asList(this.getTriggers(), this.getColumns());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sqlite/SqliteModView", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty().append((Iterable)this.getTriggers()).append((Iterable)this.getColumns());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sqlite/SqliteModView", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setSystem(boolean var1);

    @Override
    public void setInvalid(boolean var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/sqlite/SqliteModView", "importProperties"));
        }
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String nameScripted = properties.get("NameScripted");
        String nameQuoted = properties.get("NameQuoted");
        String comment = properties.get("Comment");
        String system = properties.get("System");
        String invalid = properties.get("Invalid");
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (nameScripted != null) {
            this.setNameScripted(PropertyConverter.importBoolean(nameScripted));
        }
        if (nameQuoted != null) {
            this.setNameQuoted(PropertyConverter.importBoolean(nameQuoted));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (system != null) {
            this.setSystem(PropertyConverter.importBoolean(system));
        }
        if (invalid != null) {
            this.setInvalid(PropertyConverter.importBoolean(invalid));
        }
    }
}

