/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.sqlite;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicSingleDatabaseRoot;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.sqlite.SqliteCollation;
import com.intellij.database.model.sqlite.SqliteSchema;
import com.intellij.database.util.Casing;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public interface SqliteRoot
extends BasicSingleDatabaseRoot {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.ROOT;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sqlite/SqliteRoot", "getKind"));
        }
        return objectKind;
    }

    @NotNull
    public @NotNull NamingFamily<@NotNull ? extends SqliteSchema> getSchemas();

    @NotNull
    public @NotNull NamingFamily<@NotNull ? extends SqliteCollation> getCollations();

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Arrays.asList(ObjectKind.SCHEMA, ObjectKind.COLLATION);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sqlite/SqliteRoot", "getFamilyKinds"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List<Family> list = Arrays.asList(this.getSchemas(), this.getCollations());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sqlite/SqliteRoot", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull JBIterable<@NotNull ? extends BasicElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty().append(this.getSchemas()).append(this.getCollations());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sqlite/SqliteRoot", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    default public Casing getDefaultCasing() {
        return BasicNamespace.MIXED_CASING;
    }
}

