/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.sqlite;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.sqlite.SqliteCheck;
import com.intellij.database.model.sqlite.SqliteForeignKey;
import com.intellij.database.model.sqlite.SqliteIndex;
import com.intellij.database.model.sqlite.SqliteKey;
import com.intellij.database.model.sqlite.SqliteLikeTable;
import com.intellij.database.model.sqlite.SqliteSchema;
import com.intellij.database.model.sqlite.SqliteTableColumn;
import com.intellij.database.model.sqlite.SqliteTrigger;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SqliteTable
extends SqliteLikeTable,
BasicTable {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.TABLE;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sqlite/SqliteTable", "getKind"));
        }
        return objectKind;
    }

    @Override
    @Nullable
    public SqliteSchema getSchema();

    @Override
    @Nullable
    default public SqliteSchema getDbParent() {
        return this.getSchema();
    }

    default public @Nullable NamingFamily<@NotNull ? extends SqliteTable> getParentFamily() {
        return null;
    }

    @Override
    @NotNull
    public @NotNull NamingFamily<@NotNull ? extends SqliteTrigger> getTriggers();

    @NotNull
    public @NotNull PositioningNamingFamily<@NotNull ? extends SqliteTableColumn> getColumns();

    @NotNull
    public @NotNull NamingFamily<@NotNull ? extends SqliteIndex> getIndices();

    @NotNull
    public @NotNull NamingFamily<@NotNull ? extends SqliteKey> getKeys();

    @NotNull
    public @NotNull NamingFamily<@NotNull ? extends SqliteForeignKey> getForeignKeys();

    @NotNull
    public @NotNull NamingFamily<@NotNull ? extends SqliteCheck> getChecks();

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Arrays.asList(ObjectKind.TRIGGER, ObjectKind.COLUMN, ObjectKind.INDEX, ObjectKind.KEY, ObjectKind.FOREIGN_KEY, ObjectKind.CHECK);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sqlite/SqliteTable", "getFamilyKinds"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List<Family> list = Arrays.asList(this.getTriggers(), this.getColumns(), this.getIndices(), this.getKeys(), this.getForeignKeys(), this.getChecks());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sqlite/SqliteTable", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull JBIterable<@NotNull ? extends BasicElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty().append(this.getTriggers()).append(this.getColumns()).append((Iterable)this.getIndices()).append((Iterable)this.getKeys()).append((Iterable)this.getForeignKeys()).append((Iterable)this.getChecks());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sqlite/SqliteTable", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    default public boolean isSystem() {
        return false;
    }

    @Override
    default public boolean isTemporary() {
        return false;
    }

    default public boolean isWithoutRowId() {
        return false;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        boolean withoutRowId;
        boolean temporary;
        boolean system;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/model/sqlite/SqliteTable", "exportProperties"));
        }
        String name = this.getName();
        if (name != null && name != ModelConsts.NO_NAME) {
            consumer.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer.accept("NameScripted", PropertyConverter.export(nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer.accept("NameQuoted", PropertyConverter.export(nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", PropertyConverter.export(comment));
        }
        if (system = this.isSystem()) {
            consumer.accept("System", PropertyConverter.export(system));
        }
        if (temporary = this.isTemporary()) {
            consumer.accept("Temporary", PropertyConverter.export(temporary));
        }
        if (withoutRowId = this.isWithoutRowId()) {
            consumer.accept("WithoutRowId", PropertyConverter.export(withoutRowId));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("Name", "NameSurrogate", "NameScripted", "NameQuoted", "Comment", "System", "Temporary", "WithoutRowId");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sqlite/SqliteTable", "getPropertyNames"));
        }
        return list;
    }
}

