/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.sybase;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicLeaf;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.sybase.SybaseConstraint;
import com.intellij.database.model.sybase.SybaseSchema;
import com.intellij.database.model.sybase.SybaseTable;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SybaseKey
extends SybaseConstraint,
BasicKey,
BasicLeaf {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.KEY;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sybase/SybaseKey", "getKind"));
        }
        return objectKind;
    }

    @Override
    @Nullable
    public SybaseTable getTable();

    @Override
    @Nullable
    default public SybaseTable getDbParent() {
        return this.getTable();
    }

    @Override
    @Nullable
    default public SybaseTable getMajorObject() {
        return this.getTable();
    }

    default public @Nullable NamingIdentifyingFamily<@NotNull ? extends SybaseKey> getParentFamily() {
        return null;
    }

    @Nullable
    default public SybaseSchema getSchema() {
        SybaseTable table = this.getTable();
        return table != null ? table.getSchema() : null;
    }

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sybase/SybaseKey", "getFamilyKinds"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sybase/SybaseKey", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull JBIterable<@NotNull ? extends BasicElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sybase/SybaseKey", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    default public long getObjectId() {
        return Long.MIN_VALUE;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    @NotNull
    default public List<String> getColNames() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sybase/SybaseKey", "getColNames"));
        }
        return list;
    }

    @Override
    default public boolean isDeferrable() {
        return false;
    }

    @Override
    default public boolean isInitiallyDeferred() {
        return false;
    }

    @Override
    default public boolean isPrimary() {
        return false;
    }

    default public short getUnderlyingIndexPosition() {
        return 0;
    }

    @Override
    @Nullable
    default public String getUnderlyingIndexName() {
        return null;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        String underlyingIndexName;
        short underlyingIndexPosition;
        boolean primary;
        boolean initiallyDeferred;
        boolean deferrable;
        List<String> colNames;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name;
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/model/sybase/SybaseKey", "exportProperties"));
        }
        long objectId = this.getObjectId();
        if (objectId != Long.MIN_VALUE) {
            consumer.accept("ObjectId", PropertyConverter.export(objectId));
        }
        if ((name = this.getName()) != null && name != ModelConsts.NO_NAME) {
            consumer.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer.accept("NameScripted", PropertyConverter.export(nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer.accept("NameQuoted", PropertyConverter.export(nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", PropertyConverter.export(comment));
        }
        if (!(colNames = this.getColNames()).isEmpty()) {
            consumer.accept("ColNames", PropertyConverter.exportListOfString(colNames));
        }
        if (deferrable = this.isDeferrable()) {
            consumer.accept("Deferrable", PropertyConverter.export(deferrable));
        }
        if (initiallyDeferred = this.isInitiallyDeferred()) {
            consumer.accept("InitiallyDeferred", PropertyConverter.export(initiallyDeferred));
        }
        if (primary = this.isPrimary()) {
            consumer.accept("Primary", PropertyConverter.export(primary));
        }
        if ((underlyingIndexPosition = this.getUnderlyingIndexPosition()) != 0) {
            consumer.accept("UnderlyingIndexPosition", PropertyConverter.export(underlyingIndexPosition));
        }
        if ((underlyingIndexName = this.getUnderlyingIndexName()) != null) {
            consumer.accept("UnderlyingIndexName", PropertyConverter.export(underlyingIndexName));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("ObjectId", "Name", "NameSurrogate", "NameScripted", "NameQuoted", "Comment", "ColNames", "Deferrable", "InitiallyDeferred", "Primary", "UnderlyingIndexPosition", "UnderlyingIndexName");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sybase/SybaseKey", "getPropertyNames"));
        }
        return list;
    }
}

