/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.plan.ui;

import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.ui.PlanRenderers;
import com.intellij.database.plan.ui.PlanTreeNode;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeColumnInfo;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlanView {
    public static final ColumnInfo OPERATION_COLUMN = new TreeColumnInfo("Operation");
    public static final ColumnInfo PARAMS_COLUMN = new ColumnInfo<PlanTreeNode, String>("Params"){

        @Nullable
        public String valueOf(PlanTreeNode node) {
            return node.getNode().getExtraInfo();
        }
    };
    public static final ColumnInfo NUM_ROWS_COLUMN = new ColumnInfo<PlanTreeNode, BigDecimal>("Rows"){

        @Nullable
        public BigDecimal valueOf(PlanTreeNode node) {
            return node.getNode().getPlanNumRows();
        }
    };
    public static final ColumnInfo TOTAL_COST_COLUMN = new ColumnInfo<PlanTreeNode, Double>("Total Cost"){

        @Nullable
        public Double valueOf(PlanTreeNode node) {
            return node.getNode().getTotalCost();
        }
    };
    public static final ColumnInfo STARTUP_COST_COLUMN = new ColumnInfo<PlanTreeNode, Double>("Startup Cost"){

        @Nullable
        public Double valueOf(PlanTreeNode node) {
            return node.getNode().getStartupCost();
        }
    };
    public static final ColumnInfo RAW_DESC_COLUMN = new ColumnInfo<PlanTreeNode, String>("Raw desc"){

        @Nullable
        public String valueOf(PlanTreeNode node) {
            return node.getNode().getRawDescription();
        }

        public boolean isCellEditable(PlanTreeNode node) {
            return true;
        }
    };
    private final JScrollPane myPanel;
    private final Project myProject;
    private PlanRenderers.ActionRenderer myTreeRenderer;

    private static ColumnInfo[] columnsFor(@NotNull PlanModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/plan/ui/PlanView", "columnsFor"));
        }
        ArrayList res = ContainerUtil.newArrayList();
        res.add(OPERATION_COLUMN);
        res.add(PARAMS_COLUMN);
        if (!model.getUnsupported().contains((Object)PlanModel.Feature.NUM_ROWS)) {
            res.add(NUM_ROWS_COLUMN);
        }
        if (!model.getUnsupported().contains((Object)PlanModel.Feature.TOTAL_COST)) {
            res.add(TOTAL_COST_COLUMN);
        }
        if (!model.getUnsupported().contains((Object)PlanModel.Feature.STARTUP_COST)) {
            res.add(STARTUP_COST_COLUMN);
        }
        res.add(RAW_DESC_COLUMN);
        return res.toArray(new ColumnInfo[res.size()]);
    }

    private PlanView(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/plan/ui/PlanView", "<init>"));
        }
        this.myTreeRenderer = new PlanRenderers.ActionRenderer();
        this.myProject = project;
        this.myPanel = ScrollPaneFactory.createScrollPane();
    }

    private static double getRendererWidth(JTable table, boolean header, int i2, int j) {
        TableCellRenderer renderer;
        TableCellRenderer tableCellRenderer = renderer = header ? table.getColumnModel().getColumn(j).getHeaderRenderer() : table.getCellRenderer(i2, j);
        if (renderer == null && header) {
            renderer = table.getTableHeader().getDefaultRenderer();
        }
        if (renderer == null) {
            return 0.0;
        }
        Object value = header ? table.getColumnModel().getColumn(j).getHeaderValue() : table.getModel().getValueAt(i2, j);
        return renderer.getTableCellRendererComponent(table, value, false, false, i2, j).getPreferredSize().getWidth();
    }

    public void setModel(@Nullable PlanModel model) {
        if (model != null) {
            ColumnInfo[] columns2 = PlanView.columnsFor(model);
            final TreeTableView table = new TreeTableView(new ListTreeTableModelOnColumns((TreeNode)PlanTreeNode.create(model.getRoot()), columns2));
            table.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getButton() == 3) {
                        int row = table.rowAtPoint(e.getPoint());
                        int col = table.columnAtPoint(e.getPoint());
                        if (row >= 0 && col >= 0) {
                            table.changeSelection(row, col, false, false);
                        }
                    }
                }
            });
            table.setTreeCellRenderer((TreeCellRenderer)this.myTreeRenderer);
            table.setRootVisible(false);
            this.myPanel.setViewportView((Component)table);
            TreeUtil.expandAll((JTree)table.getTree());
            FontMetrics metrics = table.getFontMetrics(table.getFont());
            int minWidth = metrics.stringWidth("XXXX");
            int spacing = metrics.stringWidth("X");
            for (int i2 = 0; i2 < columns2.length; ++i2) {
                double size;
                if (columns2[i2] == RAW_DESC_COLUMN) {
                    size = metrics.stringWidth("XXXXXXXXXXXX");
                } else {
                    size = table.getColumnModel().getColumn(i2).getMinWidth();
                    int count = table.getRowCount();
                    for (int j = 0; j != count; ++j) {
                        size = Math.max(size, PlanView.getRendererWidth((JTable)table, false, j, i2));
                    }
                    size = Math.max(size, PlanView.getRendererWidth((JTable)table, true, -1, i2) + (double)spacing);
                }
                table.getColumnModel().getColumn(i2).setPreferredWidth((int)size);
                table.getColumnModel().getColumn(i2).setMinWidth(minWidth);
            }
            table.revalidate();
            ActionManager actionManager = ActionManager.getInstance();
            ShowFullAction.INSTANCE.registerCustomShortcutSet(actionManager.getAction("ViewSource").getShortcutSet(), (JComponent)table);
            PopupHandler.installPopupHandler((JComponent)table, (ActionGroup)new DefaultActionGroup(new AnAction[]{ShowFullAction.INSTANCE}), (String)"unknown", (ActionManager)actionManager);
            DataManager.registerDataProvider((JComponent)table, (DataProvider)new DataProvider(){

                @Nullable
                public Object getData(@NonNls String dataId) {
                    if (CommonDataKeys.PROJECT.getName().equals(dataId)) {
                        return PlanView.this.myProject;
                    }
                    return null;
                }
            });
        } else {
            this.myPanel.setViewportView(null);
        }
    }

    @NotNull
    public JComponent getComponent() {
        JScrollPane jScrollPane = this.myPanel;
        if (jScrollPane == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/ui/PlanView", "getComponent"));
        }
        return jScrollPane;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JScrollPane jScrollPane = this.myPanel;
        if (jScrollPane == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/ui/PlanView", "getPreferredFocusedComponent"));
        }
        return jScrollPane;
    }

    @NotNull
    public static PlanView createView(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/plan/ui/PlanView", "createView"));
        }
        PlanView planView = new PlanView(project);
        if (planView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/ui/PlanView", "createView"));
        }
        return planView;
    }

    private static final class ShowFullAction
    extends DumbAwareAction {
        private static final AnAction INSTANCE = new ShowFullAction();

        public ShowFullAction() {
            super("Show Full");
        }

        public void actionPerformed(AnActionEvent e) {
            TreeTableView component = (TreeTableView)ObjectUtils.tryCast((Object)PlatformDataKeys.CONTEXT_COMPONENT.getData(e.getDataContext()), TreeTableView.class);
            if (component == null) {
                return;
            }
            int col = component.getSelectedColumn();
            int row = component.getSelectedRow();
            if (col < 0 || col >= component.getColumnCount() || row < 0 || row >= component.getRowCount()) {
                return;
            }
            String val = String.valueOf(component.getModel().getValueAt(row, col));
            if (StringUtil.isEmpty((String)val)) {
                return;
            }
            String title = String.valueOf(component.getColumnModel().getColumn(col).getHeaderValue());
            JTextArea text = new JTextArea(val);
            text.setLineWrap(true);
            text.setEditable(false);
            text.setSize(new Dimension(200, 200));
            JBPopup popup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)ScrollPaneFactory.createScrollPane((Component)text, (boolean)true), (JComponent)text).setShowBorder(true).setResizable(true).setMovable(true).setTitle(title).setRequestFocus(true).setDimensionServiceKey(e.getProject(), "PlanView.ShowFull", false).createPopup();
            popup.showInBestPositionFor(e.getDataContext());
        }
    }
}

