/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run;

import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ConcurrentWeakFactoryMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MeasuringDataAuditor
extends DataAuditor.Adapter {
    private final ConcurrentWeakFactoryMap<DataRequest, Stat> myStatMap = new ConcurrentWeakFactoryMap<DataRequest, Stat>(){

        @Nullable
        protected Stat create(DataRequest key) {
            return new Stat();
        }
    };

    protected Stat getStat(DataRequest.Context context) {
        return (Stat)this.myStatMap.get((Object)context.request);
    }

    protected long now() {
        return System.currentTimeMillis();
    }

    @Override
    public void updateCountReceived(@NotNull DataRequest.Context context, int updateCount) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/run/MeasuringDataAuditor", "updateCountReceived"));
        }
        this.getStat((DataRequest.Context)context).updateT = this.now();
        if (updateCount < 0) {
            return;
        }
        this.getStat((DataRequest.Context)context).updateCount += (long)updateCount;
    }

    @Override
    public void fetchStarted(@NotNull DataRequest.Context context, int index) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/run/MeasuringDataAuditor", "fetchStarted"));
        }
        this.getStat((DataRequest.Context)context).fetchT1 += this.now();
        this.getStat((DataRequest.Context)context).rowCount = 0L;
    }

    @Override
    public void fetchFinished(@NotNull DataRequest.Context context, int index, int rowCount) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/run/MeasuringDataAuditor", "fetchFinished"));
        }
        this.getStat((DataRequest.Context)context).fetchT2 += this.now();
        this.getStat((DataRequest.Context)context).rowCount += (long)rowCount;
    }

    @Override
    public void jobSubmitted(@NotNull DataRequest request, @NotNull DataProducer producer) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/database/run/MeasuringDataAuditor", "jobSubmitted"));
        }
        if (producer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producer", "com/intellij/database/run/MeasuringDataAuditor", "jobSubmitted"));
        }
    }

    @Override
    public void jobFinished(@NotNull DataRequest request, @NotNull DataProducer producer) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/database/run/MeasuringDataAuditor", "jobFinished"));
        }
        if (producer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producer", "com/intellij/database/run/MeasuringDataAuditor", "jobFinished"));
        }
    }

    @Override
    public void requestStarted(@NotNull DataRequest.Context context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/run/MeasuringDataAuditor", "requestStarted"));
        }
        this.getStat((DataRequest.Context)context).reqT1 = this.now();
    }

    @Override
    public void requestFinished(@NotNull DataRequest.Context context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/run/MeasuringDataAuditor", "requestFinished"));
        }
        this.getStat((DataRequest.Context)context).reqT2 = this.now();
        this.reportFinish(context);
    }

    @Override
    public void txCompleted(@NotNull DataRequest.Context context, boolean commit) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/run/MeasuringDataAuditor", "txCompleted"));
        }
        this.print(context, "transaction " + (commit ? "committed" : "rolled back") + ": " + context.txMarker);
    }

    @Override
    public void error(@NotNull DataRequest.Context context, @Nullable String message, @Nullable Throwable th) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/run/MeasuringDataAuditor", "error"));
        }
        ++this.getStat((DataRequest.Context)context).errorCount;
    }

    private void reportFinish(@NotNull DataRequest.Context context) {
        String reportText;
        String totalTimeStr;
        String timings;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/run/MeasuringDataAuditor", "reportFinish"));
        }
        Stat stat = this.getStat(context);
        long totalTime = stat.reqT2 - stat.reqT1;
        long fetchTime = stat.fetchT2 - stat.fetchT1;
        String executionTimeStr = StringUtil.formatDuration((long)(totalTime - fetchTime));
        String string = timings = Comparing.equal((String)executionTimeStr, (String)(totalTimeStr = StringUtil.formatDuration((long)totalTime))) ? executionTimeStr : totalTimeStr + " (execution: " + executionTimeStr + ", fetching: " + StringUtil.formatDuration((long)fetchTime) + ")";
        if (stat.updateCount > 0L) {
            reportText = (stat.updateCount == 1L ? "1 row" : stat.updateCount + " rows") + " affected in " + executionTimeStr;
            this.bringAttentionToOutput(context, false);
        } else if (stat.rowCount > 0L) {
            int offset = ((DataRequest.QueryRequest)context.request).constraints.offset;
            reportText = (stat.rowCount == 1L ? "1 row" : stat.rowCount + " rows") + " retrieved starting from " + offset + " in " + timings;
        } else if (stat.errorCount == 0L) {
            if (stat.rowCount == 0L) {
                reportText = "0 rows retrieved in " + timings;
            } else {
                reportText = "completed in " + executionTimeStr;
                this.bringAttentionToOutput(context, false);
            }
        } else {
            reportText = null;
        }
        if (reportText != null) {
            this.print(context, reportText);
        }
        if (totalTime > 20000L) {
            this.bringAttentionByNotification(context);
        }
    }

    protected void bringAttentionToOutput(@NotNull DataRequest.Context context, boolean isError) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/run/MeasuringDataAuditor", "bringAttentionToOutput"));
        }
    }

    protected void bringAttentionByNotification(@NotNull DataRequest.Context context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/run/MeasuringDataAuditor", "bringAttentionByNotification"));
        }
    }

    public static class Stat {
        public long reqT1;
        public long reqT2;
        public long fetchT1;
        public long fetchT2;
        public long rowCount = -1L;
        public long updateT;
        public long updateCount;
        public long errorCount;
    }
}

