/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.actions.QueryActionBase;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.dump.DumpHandler;
import com.intellij.database.dump.ExtractionHelper;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.model.DasSchemaChild;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.run.actions.ChooseExtractorAction;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DatabaseView;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DumpAction
extends DumbAwareAction
implements GridAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/actions/DumpAction", "update"));
        }
        Project project = e.getProject();
        e.getPresentation().setEnabled(project != null && DumpAction.getDumpSource(e) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/actions/DumpAction", "actionPerformed"));
        }
        DumpHandler<?> handler = DumpAction.createHandler(e, this.createHelper());
        if (handler == null) {
            return;
        }
        handler.performDump(e.getDataContext());
    }

    @Nullable
    private static DumpHandler<?> createHandler(@NotNull AnActionEvent e, ExtractionHelper manager) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/actions/DumpAction", "createHandler"));
        }
        Project project = e.getProject();
        Object source = DumpAction.getDumpSource(e);
        if (project == null || source == null) {
            return null;
        }
        return source instanceof ConsoleSource ? DumpAction.createConsoleHandler((ConsoleSource)source, manager) : (source instanceof DataGrid ? new DumpHandler.GridHandler(project, (DataGrid)source, manager) : new DumpHandler.DatabaseViewHandler(project, (JBIterable<DbTable>)((JBIterable)source), manager));
    }

    @Nullable
    private static DumpHandler<?> createConsoleHandler(@NotNull ConsoleSource source, @NotNull ExtractionHelper manager) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/run/actions/DumpAction", "createConsoleHandler"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/database/run/actions/DumpAction", "createConsoleHandler"));
        }
        if (!source.console.beforeExecuteQueries(source.model)) {
            return null;
        }
        List<String> queries = DumpAction.getQueries(source);
        Project project = source.console.getProject();
        return queries.isEmpty() ? null : new DumpHandler.ConsoleHandler(project, (JBIterable<String>)JBIterable.from(queries), source.console, manager);
    }

    @NotNull
    public static List<String> getQueries(@NotNull ConsoleSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/run/actions/DumpAction", "getQueries"));
        }
        List list = source.model.statements().transform(it -> {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/run/actions/DumpAction", "lambda$getQueries$0"));
            }
            return it.text(source.console.getPStorage(), Conditions.alwaysFalse());
        }).toList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/DumpAction", "getQueries"));
        }
        return list;
    }

    @Nullable
    public static Object getDumpSource(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/actions/DumpAction", "getDumpSource"));
        }
        DataGrid dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        if (dataGrid != null) {
            return dataGrid.isReady() && !dataGrid.isEmpty() && !dataGrid.isEditing() ? dataGrid : null;
        }
        JdbcConsole console = JdbcConsole.findConsole(e);
        JdbcConsoleProvider.Info info = QueryActionBase.getInfoClassic(e);
        if (console != null && info != null) {
            return new ConsoleSource(console, DumpAction.getAdjustedScriptModel(info));
        }
        Set<DbElement> selection = DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class);
        JBIterable<DbTable> tables = DumpAction.getTables(selection);
        return tables.isEmpty() ? null : tables;
    }

    @NotNull
    private static ScriptModel<?> getAdjustedScriptModel(@NotNull JdbcConsoleProvider.Info info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/run/actions/DumpAction", "getAdjustedScriptModel"));
        }
        TextRange range = ScriptModelUtil.getSelectionForConsole((Editor)info.editor);
        TextRange adjusted = ScriptModelUtil.adjustSelectionRange(info.model, (Document)info.editor.getDocument(), range);
        ScriptModel scriptModel = info.model.subModel(adjusted, false);
        if (scriptModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/DumpAction", "getAdjustedScriptModel"));
        }
        return scriptModel;
    }

    @NotNull
    private static JBIterable<DbTable> getTables(Set<DbElement> elements) {
        Set sources = ContainerUtil.map2Set(elements, e -> e.getDataSource());
        List canConnectSources = ContainerUtil.filter((Collection)sources, DbImplUtil::canConnectTo);
        JBIterable jBIterable = canConnectSources.isEmpty() ? JBIterable.empty() : ((JBTreeTraverser)((JBTreeTraverser)DasUtil.dasTraverser().withRoots(elements)).expand(Conditions.not((Condition)DasUtil.byClass(DasSchemaChild.class)))).filter(DbTable.class).filter(e -> canConnectSources.contains(e.getDataSource()));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/DumpAction", "getTables"));
        }
        return jBIterable;
    }

    @NotNull
    protected abstract ExtractionHelper createHelper();

    public static class ConsoleSource {
        final JdbcConsole console;
        final ScriptModel<?> model;

        public ConsoleSource(@NotNull JdbcConsole console, @NotNull ScriptModel<?> model) {
            if (console == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/run/actions/DumpAction$ConsoleSource", "<init>"));
            }
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/run/actions/DumpAction$ConsoleSource", "<init>"));
            }
            this.console = console;
            this.model = model;
        }
    }

    public static class FileGroup
    extends ActionGroup
    implements DumbAware {
        public void update(AnActionEvent e) {
            Object source = DumpAction.getDumpSource(e);
            e.getPresentation().setEnabledAndVisible(source != null && e.getProject() != null);
            if (source == null || e.getProject() == null) {
                return;
            }
            if (source instanceof ConsoleSource) {
                FileGroup.updateConsolePresentation((ConsoleSource)source, e);
            } else {
                this.updatePresentation(source, e);
            }
        }

        private static void updateConsolePresentation(@NotNull ConsoleSource source, @NotNull AnActionEvent e) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/run/actions/DumpAction$FileGroup", "updateConsolePresentation"));
            }
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/actions/DumpAction$FileGroup", "updateConsolePresentation"));
            }
            List<String> queries = DumpAction.getQueries(source);
            e.getPresentation().setEnabledAndVisible(!queries.isEmpty());
            if (queries.isEmpty()) {
                return;
            }
            e.getPresentation().setText(FileGroup.pluralizeInternal("Execute to &File", FileGroup.getSize(queries)));
            e.getPresentation().setIcon(AllIcons.Actions.Execute);
        }

        private void updatePresentation(@NotNull Object target, @NotNull AnActionEvent e) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/database/run/actions/DumpAction$FileGroup", "updatePresentation"));
            }
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/actions/DumpAction$FileGroup", "updatePresentation"));
            }
            e.getPresentation().setText(FileGroup.pluralizeInternal("Dump Data to &File", FileGroup.getSize(target)), true);
            e.getPresentation().setIcon(this.getTemplatePresentation().getIcon());
        }

        @NotNull
        private static String pluralizeInternal(@NotNull String s, int count) {
            if (s == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/database/run/actions/DumpAction$FileGroup", "pluralizeInternal"));
            }
            String string = s + (count > 1 ? "(s)" : "");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/DumpAction$FileGroup", "pluralizeInternal"));
            }
            return string;
        }

        private static int getSize(@NotNull Object object) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/run/actions/DumpAction$FileGroup", "getSize"));
            }
            if (object instanceof JBIterable) {
                return ((JBIterable)object).skip(1).isEmpty() ? 1 : 2;
            }
            if (object instanceof List) {
                return ((List)object).size();
            }
            return 1;
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = ChooseExtractorAction.ChooserGroup.getActions((Function<DataExtractorFactory, ? extends AnAction>)((Function)ToFileWithCopyAction::new));
            if (anActionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/DumpAction$FileGroup", "getChildren"));
            }
            return anActionArray;
        }

        private static class ToFileWithCopyAction
        extends ToFile {
            private final DataExtractorFactory myExtractorFactory;

            public ToFileWithCopyAction(@NotNull DataExtractorFactory factory) {
                if (factory == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/database/run/actions/DumpAction$FileGroup$ToFileWithCopyAction", "<init>"));
                }
                this.myExtractorFactory = factory;
                this.getTemplatePresentation().setText(factory.getName());
            }

            @Override
            @NotNull
            protected ExtractionHelper createHelper() {
                ExtractionHelper.FileExtractionHelper fileExtractionHelper = new ExtractionHelper.FileExtractionHelper(){

                    @Override
                    @Nullable
                    public DataExtractorFactory chooseExtractorFactory(@NotNull DataContext context, @NotNull Project project) {
                        if (context == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/run/actions/DumpAction$FileGroup$ToFileWithCopyAction$1", "chooseExtractorFactory"));
                        }
                        if (project == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/run/actions/DumpAction$FileGroup$ToFileWithCopyAction$1", "chooseExtractorFactory"));
                        }
                        return myExtractorFactory;
                    }
                };
                if (fileExtractionHelper == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/DumpAction$FileGroup$ToFileWithCopyAction", "createHelper"));
                }
                return fileExtractionHelper;
            }
        }
    }

    public static class ToFile
    extends DumpAction {
        @Override
        @NotNull
        protected ExtractionHelper createHelper() {
            ExtractionHelper.FileExtractionHelper fileExtractionHelper = new ExtractionHelper.FileExtractionHelper();
            if (fileExtractionHelper == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/DumpAction$ToFile", "createHelper"));
            }
            return fileExtractionHelper;
        }
    }

    public static class ToClipboard
    extends DumpAction {
        @Override
        @NotNull
        protected ExtractionHelper createHelper() {
            ExtractionHelper.ClipboardExtractionHelper clipboardExtractionHelper = new ExtractionHelper.ClipboardExtractionHelper();
            if (clipboardExtractionHelper == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/DumpAction$ToClipboard", "createHelper"));
            }
            return clipboardExtractionHelper;
        }
    }
}

