/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.datagrid.ViewIndexSet;
import com.intellij.database.run.ui.TableResultPanel;
import com.intellij.database.run.ui.TableResultView;
import java.awt.Point;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

enum GridSelectionGrowerStrategy {
    CELL{

        @Override
        boolean isSuitable(@NotNull ViewIndexSet<DataConsumer.Row> selectedRows, @NotNull ViewIndexSet<DataConsumer.Column> selectedColumns, int rowCount, int columnCount, boolean transposed) {
            if (selectedRows == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedRows", "com/intellij/database/run/ui/GridSelectionGrowerStrategy$1", "isSuitable"));
            }
            if (selectedColumns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedColumns", "com/intellij/database/run/ui/GridSelectionGrowerStrategy$1", "isSuitable"));
            }
            return selectedRows.size() == 0 || selectedColumns.size() == 0;
        }

        @Override
        public void changeSelection(@NotNull TableResultPanel panel) {
            if (panel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/database/run/ui/GridSelectionGrowerStrategy$1", "changeSelection"));
            }
            SelectionModel<DataConsumer.Row, DataConsumer.Column> selectionModel = panel.getSelectionModel();
            JScrollPane pane = panel.getScrollPane();
            Point position = pane.getViewport() == null ? new Point(0, 0) : pane.getViewport().getViewPosition();
            TableResultView table = panel.getTable();
            int rowAtPoint = this.get(table.rowAtPoint(position), table.getRowCount());
            int columnAtPoint = this.get(table.columnAtPoint(position), table.getColumnCount());
            boolean transposed = panel.isTransposed();
            selectionModel.setRowSelection(ViewIndex.forRow(panel, !transposed ? rowAtPoint : columnAtPoint).toModel(panel));
            selectionModel.setColumnSelection(ViewIndex.forColumn(panel, !transposed ? columnAtPoint : rowAtPoint).toModel(panel));
        }

        private int get(int value, int upperBound) {
            return value < 0 || value >= upperBound ? 0 : value;
        }
    }
    ,
    COLUMN(true){

        @Override
        boolean isSuitable(@NotNull ViewIndexSet<DataConsumer.Row> selectedRows, @NotNull ViewIndexSet<DataConsumer.Column> selectedColumns, int rowCount, int columnCount, boolean transposed) {
            if (selectedRows == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedRows", "com/intellij/database/run/ui/GridSelectionGrowerStrategy$2", "isSuitable"));
            }
            if (selectedColumns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedColumns", "com/intellij/database/run/ui/GridSelectionGrowerStrategy$2", "isSuitable"));
            }
            return GridSelectionGrowerStrategy.notAllSelected(selectedRows, selectedColumns, rowCount, columnCount) && (!transposed && selectedRows.size() < rowCount || transposed && selectedColumns.size() < columnCount);
        }

        @Override
        public void changeSelection(@NotNull TableResultPanel panel) {
            if (panel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/database/run/ui/GridSelectionGrowerStrategy$2", "changeSelection"));
            }
            SelectionModel<DataConsumer.Row, DataConsumer.Column> selectionModel = panel.getSelectionModel();
            selectionModel.selectWholeColumn();
        }
    }
    ,
    LINE(true, false){

        @Override
        boolean isSuitable(@NotNull ViewIndexSet<DataConsumer.Row> selectedRows, @NotNull ViewIndexSet<DataConsumer.Column> selectedColumns, int rowCount, int columnCount, boolean transposed) {
            if (selectedRows == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedRows", "com/intellij/database/run/ui/GridSelectionGrowerStrategy$3", "isSuitable"));
            }
            if (selectedColumns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedColumns", "com/intellij/database/run/ui/GridSelectionGrowerStrategy$3", "isSuitable"));
            }
            return GridSelectionGrowerStrategy.notAllSelected(selectedRows, selectedColumns, rowCount, columnCount) && (!transposed && selectedRows.size() == rowCount || transposed && selectedColumns.size() == columnCount);
        }

        @Override
        public void changeSelection(@NotNull TableResultPanel panel) {
            if (panel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/database/run/ui/GridSelectionGrowerStrategy$3", "changeSelection"));
            }
            SelectionModel<DataConsumer.Row, DataConsumer.Column> selectionModel = panel.getSelectionModel();
            selectionModel.selectWholeRow();
        }
    }
    ,
    ALL{

        @Override
        boolean isSuitable(@NotNull ViewIndexSet<DataConsumer.Row> selectedRows, @NotNull ViewIndexSet<DataConsumer.Column> selectedColumns, int rowCount, int columnCount, boolean transposed) {
            if (selectedRows == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedRows", "com/intellij/database/run/ui/GridSelectionGrowerStrategy$4", "isSuitable"));
            }
            if (selectedColumns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedColumns", "com/intellij/database/run/ui/GridSelectionGrowerStrategy$4", "isSuitable"));
            }
            return GridSelectionGrowerStrategy.notAllSelected(selectedRows, selectedColumns, rowCount, columnCount) && (transposed && selectedColumns.size() == columnCount || !transposed && selectedRows.size() == rowCount);
        }

        @Override
        public void changeSelection(@NotNull TableResultPanel panel) {
            if (panel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/database/run/ui/GridSelectionGrowerStrategy$4", "changeSelection"));
            }
            SelectionModel<DataConsumer.Row, DataConsumer.Column> selectionModel = panel.getSelectionModel();
            selectionModel.selectWholeRow();
            selectionModel.selectWholeColumn();
        }
    };

    private final boolean myNeedRestore;
    private final boolean myNeedStore;

    private GridSelectionGrowerStrategy() {
        this(false, false);
    }

    private GridSelectionGrowerStrategy(boolean needStore) {
        this(false, needStore);
    }

    private GridSelectionGrowerStrategy(boolean needRestore, boolean needStore) {
        this.myNeedRestore = needRestore;
        this.myNeedStore = needStore;
    }

    boolean isNeedRestore() {
        return this.myNeedRestore;
    }

    boolean isNeedStore() {
        return this.myNeedStore;
    }

    abstract void changeSelection(@NotNull TableResultPanel var1);

    abstract boolean isSuitable(@NotNull ViewIndexSet<DataConsumer.Row> var1, @NotNull ViewIndexSet<DataConsumer.Column> var2, int var3, int var4, boolean var5);

    @Nullable
    static GridSelectionGrowerStrategy of(@NotNull DataGrid grid) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/GridSelectionGrowerStrategy", "of"));
        }
        SelectionModel model = grid.getSelectionModel();
        ViewIndexSet<DataConsumer.Row> rows = model.getSelectedRows().toView(grid);
        ViewIndexSet<DataConsumer.Column> columns2 = model.getSelectedColumns().toView(grid);
        int rowCount = grid.getVisibleRows().size();
        int columnCount = grid.getVisibleColumns().size();
        boolean transposed = grid.isTransposed();
        for (GridSelectionGrowerStrategy grower : GridSelectionGrowerStrategy.values()) {
            if (!grower.isSuitable(rows, columns2, rowCount, columnCount, transposed)) continue;
            return grower;
        }
        return null;
    }

    private static boolean notAllSelected(@NotNull ViewIndexSet<DataConsumer.Row> rows, @NotNull ViewIndexSet<DataConsumer.Column> columns2, int rowCount, int columnCount) {
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/run/ui/GridSelectionGrowerStrategy", "notAllSelected"));
        }
        if (columns2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/run/ui/GridSelectionGrowerStrategy", "notAllSelected"));
        }
        return rows.size() * columns2.size() < rowCount * columnCount;
    }
}

