/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.run.ui.grid.CellAttributes;
import com.intellij.database.run.ui.grid.CellAttributesKey;
import com.intellij.database.run.ui.grid.GridColorsScheme;
import com.intellij.database.run.ui.grid.GridMarkupModel;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridMarkupModelImpl<Row, Column>
implements GridMarkupModel<Row, Column> {
    private final List<GridMarkupModel.CellHighlighting> myCellHighlightings = ContainerUtil.newArrayList();
    private final List<GridMarkupModel.HeaderHighlighting<Row>> myRowHeaderHighlightings = ContainerUtil.newArrayList();
    private final List<GridMarkupModel.HeaderHighlighting<Column>> myColumnHeaderHighlightings = ContainerUtil.newArrayList();
    private static final Comparator<GridMarkupModel.Highlighting> highlightingComparator = (o1, o2) -> {
        if (o1 == null || o2 == null) {
            return o1 == null && o2 == null ? 0 : (o1 == null ? -1 : 1);
        }
        return Comparing.compare((int)o1.getLevel(), (int)o2.getLevel());
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public CellAttributes getCellAttributes(@NotNull ModelIndex<Row> row, @NotNull ModelIndex<Column> column, @NotNull GridColorsScheme scheme) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/run/ui/grid/GridMarkupModelImpl", "getCellAttributes"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/GridMarkupModelImpl", "getCellAttributes"));
        }
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/database/run/ui/grid/GridMarkupModelImpl", "getCellAttributes"));
        }
        List<GridMarkupModel.CellHighlighting> list = this.myCellHighlightings;
        synchronized (list) {
            CellAttributes res = null;
            ArrayList tmp = ContainerUtil.newArrayList();
            for (GridMarkupModel.CellHighlighting cellHighlighting : this.myCellHighlightings) {
                if (!cellHighlighting.contains(row.asInteger(), column.asInteger())) continue;
                tmp.add(cellHighlighting);
            }
            Collections.sort(tmp, highlightingComparator);
            for (GridMarkupModel.Highlighting highlighting : tmp) {
                res = CellAttributes.merge(res, scheme.getAttributes(highlighting.getAttributes()));
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public CellAttributes getRowHeaderAttributes(@NotNull ModelIndex<Row> row, @NotNull GridColorsScheme scheme) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/run/ui/grid/GridMarkupModelImpl", "getRowHeaderAttributes"));
        }
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/database/run/ui/grid/GridMarkupModelImpl", "getRowHeaderAttributes"));
        }
        List<GridMarkupModel.HeaderHighlighting<Row>> list = this.myRowHeaderHighlightings;
        synchronized (list) {
            CellAttributes res = null;
            ArrayList tmp = ContainerUtil.newArrayList();
            for (GridMarkupModel.HeaderHighlighting<Row> headerHighlighting : this.myRowHeaderHighlightings) {
                if (!headerHighlighting.contains(row.asInteger())) continue;
                tmp.add(headerHighlighting);
            }
            Collections.sort(tmp, highlightingComparator);
            for (GridMarkupModel.Highlighting highlighting : tmp) {
                res = CellAttributes.merge(res, scheme.getAttributes(highlighting.getAttributes()));
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public GridMarkupModel.CellHighlighting highlightCells(@NotNull ModelIndexSet<Row> rows, @NotNull ModelIndexSet<Column> columns2, @NotNull CellAttributesKey attributes, int level) {
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/run/ui/grid/GridMarkupModelImpl", "highlightCells"));
        }
        if (columns2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/run/ui/grid/GridMarkupModelImpl", "highlightCells"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/database/run/ui/grid/GridMarkupModelImpl", "highlightCells"));
        }
        List<GridMarkupModel.CellHighlighting> list = this.myCellHighlightings;
        // MONITORENTER : list
        CellHighlightingImpl res = new CellHighlightingImpl(rows, columns2, attributes, level);
        this.myCellHighlightings.add(res);
        CellHighlightingImpl cellHighlightingImpl = res;
        // MONITOREXIT : list
        if (cellHighlightingImpl != null) return cellHighlightingImpl;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/GridMarkupModelImpl", "highlightCells"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCellHighlighting(@NotNull GridMarkupModel.CellHighlighting highlighting) {
        if (highlighting == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighting", "com/intellij/database/run/ui/grid/GridMarkupModelImpl", "removeCellHighlighting"));
        }
        List<GridMarkupModel.CellHighlighting> list = this.myCellHighlightings;
        synchronized (list) {
            this.myCellHighlightings.remove(highlighting);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllCellHighlightings(@NotNull Collection<GridMarkupModel.CellHighlighting> highlightings) {
        if (highlightings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightings", "com/intellij/database/run/ui/grid/GridMarkupModelImpl", "removeAllCellHighlightings"));
        }
        List<GridMarkupModel.CellHighlighting> list = this.myCellHighlightings;
        synchronized (list) {
            this.myCellHighlightings.removeAll(highlightings);
        }
    }

    @Override
    public void removeHighlighting(@NotNull GridMarkupModel.Highlighting highlighting) {
        if (highlighting == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighting", "com/intellij/database/run/ui/grid/GridMarkupModelImpl", "removeHighlighting"));
        }
        if (highlighting instanceof GridMarkupModel.CellHighlighting) {
            this.removeCellHighlighting((GridMarkupModel.CellHighlighting)highlighting);
        } else if (highlighting instanceof GridMarkupModel.HeaderHighlighting) {
            this.removeRowHeaderHighlighting((GridMarkupModel.HeaderHighlighting)highlighting);
            this.removeColumnHeaderHighlighting((GridMarkupModel.HeaderHighlighting)highlighting);
        }
    }

    @Override
    public void removeAllHighlightings(@NotNull Collection<GridMarkupModel.Highlighting> highlightings) {
        if (highlightings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightings", "com/intellij/database/run/ui/grid/GridMarkupModelImpl", "removeAllHighlightings"));
        }
        for (GridMarkupModel.Highlighting highlighting : highlightings) {
            this.removeHighlighting(highlighting);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public GridMarkupModel.HeaderHighlighting<Row> highlightRowHeaders(@NotNull ModelIndexSet<Row> rows, @NotNull CellAttributesKey attributes, int level) {
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/run/ui/grid/GridMarkupModelImpl", "highlightRowHeaders"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/database/run/ui/grid/GridMarkupModelImpl", "highlightRowHeaders"));
        }
        List<GridMarkupModel.HeaderHighlighting<Row>> list = this.myRowHeaderHighlightings;
        // MONITORENTER : list
        HeaderHighlightingImpl res = new HeaderHighlightingImpl(rows, attributes, level);
        this.myRowHeaderHighlightings.add(res);
        HeaderHighlightingImpl headerHighlightingImpl = res;
        // MONITOREXIT : list
        if (headerHighlightingImpl != null) return headerHighlightingImpl;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/GridMarkupModelImpl", "highlightRowHeaders"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRowHeaderHighlighting(@NotNull GridMarkupModel.HeaderHighlighting<Row> highlighting) {
        if (highlighting == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighting", "com/intellij/database/run/ui/grid/GridMarkupModelImpl", "removeRowHeaderHighlighting"));
        }
        List<GridMarkupModel.HeaderHighlighting<Row>> list = this.myRowHeaderHighlightings;
        synchronized (list) {
            this.myRowHeaderHighlightings.remove(highlighting);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllRowHeaderHighlightings(@NotNull Collection<GridMarkupModel.HeaderHighlighting<Row>> highlightings) {
        if (highlightings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightings", "com/intellij/database/run/ui/grid/GridMarkupModelImpl", "removeAllRowHeaderHighlightings"));
        }
        List<GridMarkupModel.HeaderHighlighting<Row>> list = this.myRowHeaderHighlightings;
        synchronized (list) {
            this.myRowHeaderHighlightings.removeAll(highlightings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public CellAttributes getColumnHeaderAttributes(@NotNull ModelIndex<Column> column, @NotNull GridColorsScheme scheme) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/GridMarkupModelImpl", "getColumnHeaderAttributes"));
        }
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/database/run/ui/grid/GridMarkupModelImpl", "getColumnHeaderAttributes"));
        }
        List<GridMarkupModel.HeaderHighlighting<Column>> list = this.myColumnHeaderHighlightings;
        synchronized (list) {
            CellAttributes res = null;
            ArrayList tmp = ContainerUtil.newArrayList();
            for (GridMarkupModel.HeaderHighlighting<Column> headerHighlighting : this.myColumnHeaderHighlightings) {
                if (!headerHighlighting.contains(column.asInteger())) continue;
                tmp.add(headerHighlighting);
            }
            Collections.sort(tmp, highlightingComparator);
            for (GridMarkupModel.Highlighting highlighting : tmp) {
                res = CellAttributes.merge(res, scheme.getAttributes(highlighting.getAttributes()));
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public GridMarkupModel.HeaderHighlighting<Column> highlightColumnHeaders(@NotNull ModelIndexSet<Column> columns2, @NotNull CellAttributesKey attributes, int level) {
        if (columns2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/run/ui/grid/GridMarkupModelImpl", "highlightColumnHeaders"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/database/run/ui/grid/GridMarkupModelImpl", "highlightColumnHeaders"));
        }
        List<GridMarkupModel.HeaderHighlighting<Column>> list = this.myColumnHeaderHighlightings;
        // MONITORENTER : list
        HeaderHighlightingImpl res = new HeaderHighlightingImpl(columns2, attributes, level);
        this.myColumnHeaderHighlightings.add(res);
        HeaderHighlightingImpl headerHighlightingImpl = res;
        // MONITOREXIT : list
        if (headerHighlightingImpl != null) return headerHighlightingImpl;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/GridMarkupModelImpl", "highlightColumnHeaders"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeColumnHeaderHighlighting(@NotNull GridMarkupModel.HeaderHighlighting<Column> highlighting) {
        if (highlighting == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighting", "com/intellij/database/run/ui/grid/GridMarkupModelImpl", "removeColumnHeaderHighlighting"));
        }
        List<GridMarkupModel.HeaderHighlighting<Column>> list = this.myColumnHeaderHighlightings;
        synchronized (list) {
            this.myColumnHeaderHighlightings.remove(highlighting);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllColumnHeaderHighlightings(@NotNull Collection<GridMarkupModel.HeaderHighlighting<Column>> highlightings) {
        if (highlightings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightings", "com/intellij/database/run/ui/grid/GridMarkupModelImpl", "removeAllColumnHeaderHighlightings"));
        }
        List<GridMarkupModel.HeaderHighlighting<Column>> list = this.myColumnHeaderHighlightings;
        synchronized (list) {
            this.myColumnHeaderHighlightings.removeAll(highlightings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        List<GridMarkupModel.Highlighting> list = this.myCellHighlightings;
        synchronized (list) {
            this.myCellHighlightings.clear();
        }
        list = this.myRowHeaderHighlightings;
        synchronized (list) {
            this.myRowHeaderHighlightings.clear();
        }
        list = this.myColumnHeaderHighlightings;
        synchronized (list) {
            this.myColumnHeaderHighlightings.clear();
        }
    }

    private static class HeaderHighlightingImpl<S>
    extends AbstractHighlighting
    implements GridMarkupModel.HeaderHighlighting<S> {
        private final TIntHashSet myRowOrCols;

        private HeaderHighlightingImpl(ModelIndexSet<S> rows, CellAttributesKey attributes, int level) {
            super(attributes, level);
            this.myRowOrCols = new TIntHashSet(rows.asArray());
        }

        @Override
        public boolean contains(int rowOrCol) {
            return this.myRowOrCols.contains(rowOrCol);
        }
    }

    private static class CellHighlightingImpl
    extends AbstractHighlighting
    implements GridMarkupModel.CellHighlighting {
        private final TIntHashSet myColumns;
        private final TIntHashSet myRows;

        private <Row, Column> CellHighlightingImpl(ModelIndexSet<Row> rows, ModelIndexSet<Column> columns2, CellAttributesKey attributes, int level) {
            super(attributes, level);
            this.myColumns = new TIntHashSet(columns2.asArray());
            this.myRows = new TIntHashSet(rows.asArray());
        }

        @Override
        public boolean contains(int row, int column) {
            return this.myColumns.contains(column) && this.myRows.contains(row);
        }
    }

    private static abstract class AbstractHighlighting
    implements GridMarkupModel.Highlighting {
        private final CellAttributesKey myAttributes;
        private final int myLevel;

        private AbstractHighlighting(CellAttributesKey attributes, int level) {
            this.myAttributes = attributes;
            this.myLevel = level;
        }

        @Override
        @NotNull
        public CellAttributesKey getAttributes() {
            CellAttributesKey cellAttributesKey = this.myAttributes;
            if (cellAttributesKey == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/GridMarkupModelImpl$AbstractHighlighting", "getAttributes"));
            }
            return cellAttributesKey;
        }

        @Override
        public int getLevel() {
            return this.myLevel;
        }
    }
}

