/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.data.types.DataTypeConversion;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.datagrid.mutating.CellMutation;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.run.ui.grid.GridTransferableData;
import com.intellij.ide.PasteProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.ide.CopyPasteManager;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class GridPasteProvider
implements PasteProvider {
    private final DataGrid myGrid;

    public GridPasteProvider(@NotNull DataGrid grid) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/GridPasteProvider", "<init>"));
        }
        this.myGrid = grid;
    }

    public void performPaste(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/database/run/ui/grid/GridPasteProvider", "performPaste"));
        }
        Object contents = CopyPasteManager.getInstance().getContents(GridTransferableData.ourFlavor);
        if (!(contents instanceof GridTransferableData)) {
            return;
        }
        GridTransferableData data = (GridTransferableData)contents;
        SelectionModel model = this.myGrid.getSelectionModel();
        ModelIndexSet rows = model.getSelectedRows();
        ModelIndexSet columns2 = model.getSelectedColumns();
        int minRow = DataGridUtil.min(rows.toView(this.myGrid));
        int minCol = DataGridUtil.min(columns2.toView(this.myGrid));
        int rowOffset = minRow - data.getFirstRowIdx();
        int colOffset = minCol - data.getFirstColumnIdx();
        List<CellMutation.Builder> conversions = data.getConversions().stream().map(conversion -> conversion.secondGrid(this.myGrid).secondSystem((DatabaseSystem)DataGridUtil.getDatabaseSystem(this.myGrid)).secondDialect(DataGridUtil.getDatabaseDialect(this.myGrid)).offset(rowOffset, colOffset).build()).filter(DataTypeConversion::isValid).map(DataTypeConversion::convert).collect(Collectors.toList());
        this.myGrid.getDataSupport().finishBuildingAndApply(conversions);
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/database/run/ui/grid/GridPasteProvider", "isPastePossible"));
        }
        Object contents = CopyPasteManager.getInstance().getContents(GridTransferableData.ourFlavor);
        return contents instanceof GridTransferableData;
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/database/run/ui/grid/GridPasteProvider", "isPasteEnabled"));
        }
        return this.myGrid.isReady() && this.myGrid.isEditable();
    }
}

