/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.selection;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.datagrid.ViewIndexSet;
import com.intellij.database.run.ui.HiddenColumnsSelectionHolder;
import com.intellij.database.run.ui.TableResultView;
import com.intellij.database.run.ui.grid.GridSelection;
import com.intellij.database.run.ui.grid.selection.GridSelectionTracker;
import com.intellij.ui.JBAutoscroller;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;

public class GridSelectionModel
implements SelectionModel<DataConsumer.Row, DataConsumer.Column> {
    private final TableResultView myTable;
    private final DataGrid myGrid;
    private final JBAutoscroller.AutoscrollLocker myLocker;
    private final HiddenColumnsSelectionHolder myHolder;
    private final GridSelectionTracker myTracker;

    public GridSelectionModel(@NotNull TableResultView table, @NotNull DataGrid grid, @NotNull JBAutoscroller.AutoscrollLocker locker, @NotNull HiddenColumnsSelectionHolder holder) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/run/ui/grid/selection/GridSelectionModel", "<init>"));
        }
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/selection/GridSelectionModel", "<init>"));
        }
        if (locker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locker", "com/intellij/database/run/ui/grid/selection/GridSelectionModel", "<init>"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/database/run/ui/grid/selection/GridSelectionModel", "<init>"));
        }
        this.myTable = table;
        this.myGrid = grid;
        this.myLocker = locker;
        this.myHolder = holder;
        this.myTracker = new GridSelectionTracker(grid, table);
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.myTable.getSelectionModel().isSelectionEmpty() || this.myTable.getColumnModel().getSelectionModel().isSelectionEmpty();
    }

    @Override
    public boolean isSelected(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/run/ui/grid/selection/GridSelectionModel", "isSelected"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/selection/GridSelectionModel", "isSelected"));
        }
        ViewIndex<DataConsumer.Row> viewRow = row.toView(this.myGrid);
        ViewIndex<DataConsumer.Column> viewColumn = column.toView(this.myGrid);
        int displayRow = this.myGrid.isTransposed() ? viewColumn.asInteger() : viewRow.asInteger();
        int displayColumn = this.myGrid.isTransposed() ? viewRow.asInteger() : viewColumn.asInteger();
        return this.myTable.isRowSelected(displayRow) && this.myTable.isColumnSelected(displayColumn);
    }

    @Override
    public boolean isSelectedColumn(@NotNull ModelIndex<DataConsumer.Column> column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/selection/GridSelectionModel", "isSelectedColumn"));
        }
        ViewIndex<DataConsumer.Column> colIdx = column.toView(this.myGrid);
        int index = colIdx.asInteger();
        return this.myGrid.isTransposed() ? this.myTable.isRowSelected(index) : this.myTable.isColumnSelected(index);
    }

    @Override
    public boolean isSelectedRow(@NotNull ModelIndex<DataConsumer.Row> row) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/run/ui/grid/selection/GridSelectionModel", "isSelectedRow"));
        }
        ViewIndex<DataConsumer.Row> rowIdx = row.toView(this.myGrid);
        int index = rowIdx.asInteger();
        return this.myGrid.isTransposed() ? this.myTable.isColumnSelected(index) : this.myTable.isRowSelected(index);
    }

    @Override
    public void clearSelection() {
        this.myTable.clearSelection();
    }

    @Override
    public int getSelectedRowCount() {
        return this.myGrid.isTransposed() ? this.myTable.getSelectedColumnCount() : this.myTable.getSelectedRowCount();
    }

    @Override
    public int getSelectedColumnCount() {
        return this.myGrid.isTransposed() ? this.myTable.getSelectedRowCount() : this.myTable.getSelectedColumnCount();
    }

    @Override
    @NotNull
    public ModelIndex<DataConsumer.Row> getSelectedRow() {
        int viewRowIndex = this.myGrid.isTransposed() ? this.myTable.getSelectedColumn() : this.myTable.getSelectedRow();
        ModelIndex<DataConsumer.Row> modelIndex = ViewIndex.forRow(this.myGrid, viewRowIndex >= 0 ? viewRowIndex : -1).toModel(this.myGrid);
        if (modelIndex == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/selection/GridSelectionModel", "getSelectedRow"));
        }
        return modelIndex;
    }

    @Override
    @NotNull
    public ModelIndexSet<DataConsumer.Row> getSelectedRows() {
        ModelIndexSet<DataConsumer.Row> modelIndexSet = ViewIndexSet.forRows(this.myGrid, this.myGrid.isTransposed() ? this.myTable.getSelectedColumns() : this.myTable.getSelectedRows()).toModel(this.myGrid);
        if (modelIndexSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/selection/GridSelectionModel", "getSelectedRows"));
        }
        return modelIndexSet;
    }

    @Override
    @NotNull
    public ModelIndex<DataConsumer.Column> getSelectedColumn() {
        ModelIndex<DataConsumer.Column> modelIndex = ViewIndex.forColumn(this.myGrid, this.myGrid.isTransposed() ? this.myTable.getSelectedRow() : this.myTable.getSelectedColumn()).toModel(this.myGrid);
        if (modelIndex == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/selection/GridSelectionModel", "getSelectedColumn"));
        }
        return modelIndex;
    }

    @Override
    @NotNull
    public ModelIndexSet<DataConsumer.Column> getSelectedColumns() {
        ModelIndexSet<DataConsumer.Column> modelIndexSet = ViewIndexSet.forColumns(this.myGrid, this.myGrid.isTransposed() ? this.myTable.getSelectedRows() : this.myTable.getSelectedColumns()).toModel(this.myGrid);
        if (modelIndexSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/selection/GridSelectionModel", "getSelectedColumns"));
        }
        return modelIndexSet;
    }

    @Override
    @NotNull
    public GridSelectionTracker getTracker() {
        GridSelectionTracker gridSelectionTracker = this.myTracker;
        if (gridSelectionTracker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/selection/GridSelectionModel", "getTracker"));
        }
        return gridSelectionTracker;
    }

    @Override
    public void setColumnSelection(@NotNull ModelIndexSet<DataConsumer.Column> columns2) {
        if (columns2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/run/ui/grid/selection/GridSelectionModel", "setColumnSelection"));
        }
        this.doSetSelection(true, columns2.toView(this.myGrid).asArray());
    }

    @Override
    public void setRowSelection(@NotNull ModelIndexSet<DataConsumer.Row> rows) {
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/run/ui/grid/selection/GridSelectionModel", "setRowSelection"));
        }
        this.doSetSelection(false, rows.toView(this.myGrid).asArray());
    }

    @Override
    public void setRowSelection(@NotNull ModelIndex<DataConsumer.Row> rows) {
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/run/ui/grid/selection/GridSelectionModel", "setRowSelection"));
        }
        this.doSetSelection(false, rows.toView(this.myGrid).asInteger());
    }

    @Override
    public void setColumnSelection(@NotNull ModelIndex<DataConsumer.Column> columns2) {
        if (columns2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/run/ui/grid/selection/GridSelectionModel", "setColumnSelection"));
        }
        this.doSetSelection(true, columns2.toView(this.myGrid).asInteger());
    }

    @Override
    public void selectWholeRow() {
        this.myLocker.runWithLock(() -> {
            this.myHolder.setWholeRowSelected(!this.myGrid.isTransposed());
            GridSelection.setColumnSelectionInterval((JTable)((Object)this.myTable), this.myTable.getColumnCount() - 1, 0);
        });
    }

    @Override
    public void selectWholeColumn() {
        this.myLocker.runWithLock(() -> GridSelection.setRowSelectionInterval((JTable)((Object)this.myTable), this.myTable.getRowCount() - 1, 0));
    }

    private void doSetSelection(boolean isColumnSelection, int ... selection) {
        boolean transposed = this.myGrid.isTransposed();
        if (isColumnSelection && !transposed || !isColumnSelection && transposed) {
            GridSelection.setColumnSelection((JTable)((Object)this.myTable), selection);
            if (this.myTable.getSelectedRow() == -1) {
                GridSelection.setRowSelection((JTable)((Object)this.myTable), 0);
            }
        } else {
            GridSelection.setRowSelection((JTable)((Object)this.myTable), selection);
            if (this.myTable.getSelectedColumn() == -1) {
                GridSelection.setColumnSelection((JTable)((Object)this.myTable), 0);
            }
        }
    }
}

