/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor;

import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.schemaEditor.SchemaExportHelper;
import com.intellij.database.schemaEditor.SchemaExporters;
import com.intellij.database.schemaEditor.generation.DdlGenerator;
import com.intellij.database.schemaEditor.generation.DdlOperations;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorContext;
import org.jetbrains.annotations.NotNull;

public class SchemaEditor {
    private final SchemaExporters mySchemaExporters;
    private final DdlOperations myDdlOperations;
    private final DatabaseEditorCapabilities.DbEditorCaps myDbEditorCaps;

    @NotNull
    public DdlGenerator createGenerator(@NotNull DatabaseEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/schemaEditor/SchemaEditor", "createGenerator"));
        }
        DdlGenerator ddlGenerator = new DdlGenerator(this.myDdlOperations, this.mySchemaExporters, context);
        if (ddlGenerator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/SchemaEditor", "createGenerator"));
        }
        return ddlGenerator;
    }

    @NotNull
    public SchemaExportHelper createExportHelper(@NotNull DatabaseEditorContext context, @NotNull DasModel model) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/schemaEditor/SchemaEditor", "createExportHelper"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/schemaEditor/SchemaEditor", "createExportHelper"));
        }
        SchemaExportHelper schemaExportHelper = new SchemaExportHelper(this.mySchemaExporters, context, model);
        if (schemaExportHelper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/SchemaEditor", "createExportHelper"));
        }
        return schemaExportHelper;
    }

    public boolean canExport(@NotNull DasObject object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/SchemaEditor", "canExport"));
        }
        return this.mySchemaExporters.get(object) != null;
    }

    public SchemaEditor(@NotNull SchemaExporters exporters, @NotNull DdlOperations operations, @NotNull DatabaseEditorCapabilities.DbEditorCaps caps) {
        if (exporters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exporters", "com/intellij/database/schemaEditor/SchemaEditor", "<init>"));
        }
        if (operations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operations", "com/intellij/database/schemaEditor/SchemaEditor", "<init>"));
        }
        if (caps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caps", "com/intellij/database/schemaEditor/SchemaEditor", "<init>"));
        }
        this.mySchemaExporters = exporters;
        this.myDdlOperations = operations;
        this.myDbEditorCaps = caps;
    }

    @NotNull
    public DdlOperations getDdlOperations() {
        DdlOperations ddlOperations = this.myDdlOperations;
        if (ddlOperations == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/SchemaEditor", "getDdlOperations"));
        }
        return ddlOperations;
    }

    @NotNull
    public DatabaseEditorCapabilities.DbEditorCaps getDbEditorCaps() {
        DatabaseEditorCapabilities.DbEditorCaps dbEditorCaps = this.myDbEditorCaps;
        if (dbEditorCaps == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/SchemaEditor", "getDbEditorCaps"));
        }
        return dbEditorCaps;
    }
}

