/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicColumn;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.mssql.MsAliasType;
import com.intellij.database.model.mssql.MsCheck;
import com.intellij.database.model.mssql.MsDatabase;
import com.intellij.database.model.mssql.MsIndex;
import com.intellij.database.model.mssql.MsKey;
import com.intellij.database.model.mssql.MsLikeTable;
import com.intellij.database.model.mssql.MsModel;
import com.intellij.database.model.mssql.MsSchema;
import com.intellij.database.model.mssql.MsSourceAware;
import com.intellij.database.model.mssql.MsTableType;
import com.intellij.database.model.mssql.MsTableTypeColumn;
import com.intellij.database.model.mssql.MsTrigger;
import com.intellij.database.scripting.AbstractScriptingService;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.ScriptContext;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.scripting.TsqlScriptingService;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0002\u0013\u0014B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J&\u0010\u000e\u001a\u00180\u000fR\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R \u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/scripting/MsScriptingService;", "Lcom/intellij/database/scripting/TsqlScriptingService;", "Lcom/intellij/database/model/mssql/MsModel;", "Lcom/intellij/database/model/mssql/MsDatabase;", "Lcom/intellij/database/model/mssql/MsSchema;", "model", "database", "(Lcom/intellij/database/model/mssql/MsModel;Lcom/intellij/database/model/mssql/MsDatabase;)V", "defaultPrimitiveSizes", "", "", "Lcom/intellij/database/scripting/AbstractScriptingService$SizeAndScale;", "getDefaultPrimitiveSizes", "()Ljava/util/Map;", "createCreatingGenerator", "Lcom/intellij/database/scripting/AbstractScriptingService$CodeGenerator;", "Lcom/intellij/database/scripting/AbstractScriptingService;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "MsCreatingGenerator", "VERSION", "database-scripting"})
public final class MsScriptingService
extends TsqlScriptingService<MsModel, MsDatabase, MsSchema> {
    @NotNull
    private final Map<String, AbstractScriptingService.SizeAndScale> defaultPrimitiveSizes;

    @Override
    @NotNull
    protected AbstractScriptingService.CodeGenerator createCreatingGenerator(@NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        return new MsCreatingGenerator(task);
    }

    @Override
    @NotNull
    protected Map<String, AbstractScriptingService.SizeAndScale> getDefaultPrimitiveSizes() {
        return this.defaultPrimitiveSizes;
    }

    public MsScriptingService(@NotNull MsModel model, @NotNull MsDatabase database) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        super((BasicModel)model, (BasicDatabase)database);
        this.defaultPrimitiveSizes = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"BIT", (Object)this.getSizeAndScale1()), TuplesKt.to((Object)"BOOLEAN", (Object)this.getSizeAndScale1()), TuplesKt.to((Object)"CHAR", (Object)this.getSizeAndScale1())});
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00180\u0001R\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0017H\u0002J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00150\"2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020'H\u0014J\u0010\u0010(\u001a\u00020$2\u0006\u0010)\u001a\u00020*H\u0014J\n\u0010+\u001a\u00020$*\u00020$\u00a8\u0006,"}, d2={"Lcom/intellij/database/scripting/MsScriptingService$MsCreatingGenerator;", "Lcom/intellij/database/scripting/AbstractScriptingService$CreatingGenerator;", "Lcom/intellij/database/scripting/AbstractScriptingService;", "Lcom/intellij/database/model/mssql/MsModel;", "Lcom/intellij/database/model/mssql/MsDatabase;", "Lcom/intellij/database/model/mssql/MsSchema;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/MsScriptingService;Lcom/intellij/database/scripting/ScriptingTask;)V", "generateAliasType", "", "aliasType", "Lcom/intellij/database/model/mssql/MsAliasType;", "generateColumnComment", "column", "Lcom/intellij/database/model/basic/BasicColumn;", "generateDisableTrigger", "trigger", "Lcom/intellij/database/model/basic/BasicTrigger;", "generateElement", "element", "Lcom/intellij/database/model/basic/BasicElement;", "generateEncryptedTrigger", "Lcom/intellij/database/model/mssql/MsTrigger;", "generateSourceAware", "Lcom/intellij/database/model/mssql/MsSourceAware;", "generateTableComment", "table", "Lcom/intellij/database/model/basic/BasicLikeTable;", "generateTableType", "tableType", "Lcom/intellij/database/model/mssql/MsTableType;", "generateTrigger", "getSingleColumnElements", "", "makeColumnSpecification", "", "makeIndexWord", "index", "Lcom/intellij/database/model/basic/BasicIndex;", "makeKeyWord", "key", "Lcom/intellij/database/model/basic/BasicKey;", "quoteNameAsString", "database-scripting"})
    private final class MsCreatingGenerator
    extends AbstractScriptingService.CreatingGenerator {
        @Override
        protected void generateElement(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            BasicElement basicElement = element;
            if (basicElement instanceof MsAliasType) {
                this.generateAliasType((MsAliasType)element);
            } else if (basicElement instanceof MsTableType) {
                this.generateTableType((MsTableType)element);
            } else if (basicElement instanceof MsTrigger) {
                this.generateTrigger((MsTrigger)element);
            } else if (basicElement instanceof MsSourceAware) {
                this.generateSourceAware((MsSourceAware)element);
            } else {
                super.generateElement(element);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void generateAliasType(MsAliasType aliasType) {
            void statement;
            String name = MsScriptingService.this.currentScopeName(aliasType);
            String type = aliasType.getDataType().getSpecification();
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = "create type " + name + " from " + type;
            if (aliasType.isNotNull()) {
                statement.element = (String)statement.element + " not null";
            }
            AbstractScriptingService.CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, (Ref.ObjectRef)statement){
                final /* synthetic */ MsCreatingGenerator this$0;
                final /* synthetic */ Ref.ObjectRef $statement;

                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), (String)this.$statement.element, null, false, 6, null);
                }
                {
                    this.this$0 = msCreatingGenerator;
                    this.$statement = objectRef;
                    super(0);
                }
            }, 3, null);
        }

        private final void generateTableType(MsTableType tableType) {
            String name = MsScriptingService.this.currentScopeName(tableType);
            AbstractScriptingService.CodeGenerator.coding$default(this, ScriptContext.IN_TABLE, false, (Function0)new Function0<Unit>(this, name, tableType){
                final /* synthetic */ MsCreatingGenerator this$0;
                final /* synthetic */ String $name;
                final /* synthetic */ MsTableType $tableType;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "create type " + this.$name + " as table", null, false, 6, null);
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "(", null, false, 6, null);
                    CodeTextBuilder this_$iv = this.this$0.getBuilder();
                    CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                    try {
                        if (this.$tableType.getColumns().isEmpty()) {
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), "-- the table type " + this.$tableType.getName() + " has no columns", null, false, 6, null);
                        }
                        Iterator<T> iterator = this.$tableType.getColumns().iterator();
                        while (iterator.hasNext()) {
                            MsTableTypeColumn column;
                            MsTableTypeColumn msTableTypeColumn = column = (MsTableTypeColumn)iterator.next();
                            Intrinsics.checkExpressionValueIsNotNull((Object)msTableTypeColumn, (String)"column");
                            this.this$0.processElement(msTableTypeColumn);
                        }
                        for (MsKey key : this.$tableType.getKeys()) {
                            if (!(this.this$0.MsScriptingService.this.getGenerated().contains(key) ^ true)) continue;
                            MsKey msKey = key;
                            Intrinsics.checkExpressionValueIsNotNull((Object)msKey, (String)"key");
                            this.this$0.processElement(msKey);
                        }
                        for (MsCheck check : this.$tableType.getChecks()) {
                            if (!(this.this$0.MsScriptingService.this.getGenerated().contains(check) ^ true)) continue;
                            MsCheck msCheck = check;
                            Intrinsics.checkExpressionValueIsNotNull((Object)msCheck, (String)"check");
                            this.this$0.processElement(msCheck);
                        }
                    }
                    finally {
                        this_$iv.unindent();
                    }
                    this.this$0.getBuilder().removeSuffixFromTheLastLine(',');
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), ")", null, false, 6, null);
                }
                {
                    this.this$0 = msCreatingGenerator;
                    this.$name = string;
                    this.$tableType = msTableType;
                    super(0);
                }
            }, 2, null);
        }

        @Override
        @NotNull
        protected Iterable<BasicElement> getSingleColumnElements(@NotNull BasicColumn column) {
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            return super.getSingleColumnElements(column);
        }

        @Override
        @Nullable
        protected String makeColumnSpecification(@NotNull BasicColumn column) {
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            String s = super.makeColumnSpecification(column);
            SequenceIdentity q = column.getSequenceIdentity();
            if (q != null) {
                String identityClause = Intrinsics.areEqual((Object)q.min, (Object)BigInteger.ONE) && Intrinsics.areEqual((Object)q.increment, (Object)BigInteger.ONE) ? " identity" : " identity(" + q.min + ", " + q.increment + ')';
                s = Intrinsics.stringPlus((String)s, (Object)identityClause);
            }
            return s;
        }

        @Override
        @NotNull
        protected String makeKeyWord(@NotNull BasicKey key) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            return key instanceof MsKey ? (((MsKey)key).isPrimary() ? (ModelFun.isClustering((MsKey)key) ? "primary key" : "primary key nonclustered") : (ModelFun.isClustering((MsKey)key) ? "unique clustered" : "unique")) : super.makeKeyWord(key);
        }

        @Override
        @NotNull
        protected String makeIndexWord(@NotNull BasicIndex index) {
            BasicLikeTable table;
            BasicElement basicElement;
            boolean primary;
            Intrinsics.checkParameterIsNotNull((Object)index, (String)"index");
            MsIndex i2 = (MsIndex)index;
            return i2.isUnique() ? ((primary = Intrinsics.areEqual((Object)((basicElement = (table = ((MsIndex)index).getTable())) != null && (basicElement = basicElement.getPrimaryKey()) != null ? basicElement.getUnderlyingIndexName() : null), (Object)i2.getName())) ? (i2.isClustering() ? "unique index" : "unique nonclustered index") : (i2.isClustering() ? "unique clustered index" : "unique index")) : (i2.isClustering() ? "clustered index" : "index");
        }

        @Override
        protected void generateTableComment(@NotNull BasicLikeTable table) {
            String string;
            ObjectKind kind;
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            String name = this.quoteNameAsString(table.getName());
            String string2 = table.getComment();
            if (string2 == null || (string2 = this.quoteNameAsString(string2)) == null) {
                return;
            }
            String comment = string2;
            ObjectKind objectKind = kind = table.getKind();
            if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.TABLE)) {
                string = "TABLE";
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.VIEW)) {
                string = "VIEW";
            } else {
                return;
            }
            String tableWord = string;
            String s = StringsKt.trimMargin$default((String)("\n              |declare @sn nvarchar(30)\n              |set @sn = schema_name()\n              |execute sp_addextendedproperty N'MS_Description', N" + comment + ", N'SCHEMA', @sn, N'" + tableWord + "', N" + name + "\n              "), null, (int)1, null);
            AbstractScriptingService.CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, s){
                final /* synthetic */ MsCreatingGenerator this$0;
                final /* synthetic */ String $s;

                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$s, null, false, 6, null);
                }
                {
                    this.this$0 = msCreatingGenerator;
                    this.$s = string;
                    super(0);
                }
            }, 3, null);
        }

        @Override
        protected void generateColumnComment(@NotNull BasicColumn column) {
            String string;
            ObjectKind kind;
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            BasicLikeTable basicLikeTable = column.getTable();
            if (basicLikeTable == null) {
                return;
            }
            BasicLikeTable table = basicLikeTable;
            String string2 = table.getRealName();
            if (string2 == null || (string2 = this.quoteNameAsString(string2)) == null) {
                return;
            }
            String tableName = string2;
            String string3 = column.getRealName();
            if (string3 == null || (string3 = this.quoteNameAsString(string3)) == null) {
                return;
            }
            String columnName = string3;
            String string4 = column.getComment();
            if (string4 == null || (string4 = this.quoteNameAsString(string4)) == null) {
                return;
            }
            String comment = string4;
            ObjectKind objectKind = kind = table.getKind();
            if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.TABLE)) {
                string = "TABLE";
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.VIEW)) {
                string = "VIEW";
            } else {
                return;
            }
            String tableWord = string;
            String s = StringsKt.trimMargin$default((String)("\n              |declare @sn nvarchar(30)\n              |set @sn = schema_name()\n              |execute sp_addextendedproperty N'MS_Description', N" + comment + ", N'SCHEMA', @sn, N'" + tableWord + "', N" + tableName + ", N'COLUMN', N" + columnName + "\n              "), null, (int)1, null);
            AbstractScriptingService.CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, s){
                final /* synthetic */ MsCreatingGenerator this$0;
                final /* synthetic */ String $s;

                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$s, null, false, 6, null);
                }
                {
                    this.this$0 = msCreatingGenerator;
                    this.$s = string;
                    super(0);
                }
            }, 3, null);
        }

        private final void generateTrigger(MsTrigger trigger2) {
            if (trigger2.isEncrypted()) {
                this.generateEncryptedTrigger(trigger2);
            } else {
                this.generateSourceAware(trigger2);
            }
            if (trigger2.isDisabled()) {
                this.generateDisableTrigger(trigger2);
            }
        }

        private final void generateEncryptedTrigger(MsTrigger trigger2) {
            AbstractScriptingService.CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, trigger2){
                final /* synthetic */ MsCreatingGenerator this$0;
                final /* synthetic */ MsTrigger $trigger;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "create trigger " + this.this$0.MsScriptingService.this.currentScopeName(this.$trigger), null, false, 6, null);
                    CodeTextBuilder this_$iv = this.this$0.getBuilder();
                    CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                    try {
                        CodeTextBuilder codeTextBuilder = this.this$0.getBuilder();
                        StringBuilder stringBuilder = new StringBuilder().append("on ");
                        Object object = this.$trigger.getTable();
                        if (object == null || (object = this.this$0.MsScriptingService.this.currentScopeName((BasicElement)object)) == null) {
                            object = this.$trigger.getTableName();
                        }
                        CodeTextBuilder.append$default(codeTextBuilder, stringBuilder.append((String)object).toString(), null, false, 6, null);
                        CodeTextBuilder.append$default(this.this$0.getBuilder(), "with encryption", null, false, 6, null);
                        CodeTextBuilder.append$default(this.this$0.getBuilder(), "for " + CollectionsKt.joinToString$default((Iterable)this.$trigger.getEvents(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null), null, false, 6, null);
                    }
                    finally {
                        this_$iv.unindent();
                    }
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "as", null, false, 6, null);
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "select null -- the original source text was encrypted", null, false, 6, null);
                }
                {
                    this.this$0 = msCreatingGenerator;
                    this.$trigger = msTrigger;
                    super(0);
                }
            }, 3, null);
        }

        @Override
        protected void generateDisableTrigger(@NotNull BasicTrigger trigger2) {
            Intrinsics.checkParameterIsNotNull((Object)trigger2, (String)"trigger");
            String triggerName = MsScriptingService.this.currentScopeName(trigger2);
            BasicLikeTable basicLikeTable = trigger2.getTable();
            if (basicLikeTable == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.mssql.MsLikeTable");
            }
            String tableName = MsScriptingService.this.currentScopeName((MsLikeTable)basicLikeTable);
            AbstractScriptingService.CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, triggerName, tableName){
                final /* synthetic */ MsCreatingGenerator this$0;
                final /* synthetic */ String $triggerName;
                final /* synthetic */ String $tableName;

                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "disable trigger " + this.$triggerName + " on " + this.$tableName, null, false, 6, null);
                }
                {
                    this.this$0 = msCreatingGenerator;
                    this.$triggerName = string;
                    this.$tableName = string2;
                    super(0);
                }
            }, 3, null);
        }

        private final void generateSourceAware(MsSourceAware element) {
            if (element.isEncrypted()) {
                MsSourceAware msSourceAware = element;
                if (msSourceAware instanceof MsTrigger) {
                    this.generateEncryptedTrigger((MsTrigger)element);
                }
            } else {
                this.generateUnspecificSourceAwareElement(element, true);
            }
        }

        @NotNull
        public final String quoteNameAsString(@NotNull String $receiver) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            return "'" + StringsKt.replace$default((String)$receiver, (String)"'", (String)"''", (boolean)false, (int)4, null) + "'";
        }

        public MsCreatingGenerator(ScriptingTask task) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            super(task);
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/scripting/MsScriptingService$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "()V", "database-scripting"})
    public static final class VERSION
    extends PerObjectVersion {
        public static final VERSION INSTANCE;

        private VERSION() {
            INSTANCE = this;
        }

        static {
            new VERSION();
        }
    }
}

