/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.scripting.AbstractNamingService;
import com.intellij.database.scripting.SqlWords;
import java.util.NavigableSet;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/database/scripting/OraNamingService;", "Lcom/intellij/database/scripting/AbstractNamingService;", "()V", "aptNamePattern", "Ljava/util/regex/Pattern;", "getAptNamePattern", "()Ljava/util/regex/Pattern;", "oracleGoodNamePattern", "reservedWords", "Ljava/util/NavigableSet;", "", "getReservedWords", "()Ljava/util/NavigableSet;", "database-scripting"})
public final class OraNamingService
extends AbstractNamingService {
    private static final Pattern oracleGoodNamePattern;
    public static final OraNamingService INSTANCE;

    @Override
    @NotNull
    public NavigableSet<String> getReservedWords() {
        NavigableSet<String> navigableSet = SqlWords.ORACLE_RESERVED_WORDS;
        Intrinsics.checkExpressionValueIsNotNull(navigableSet, (String)"ORACLE_RESERVED_WORDS");
        return navigableSet;
    }

    @Override
    @NotNull
    public Pattern getAptNamePattern() {
        return oracleGoodNamePattern;
    }

    private OraNamingService() {
        INSTANCE = this;
        Pattern pattern = Pattern.compile("\\p{IsUpper}[\\p{IsUpper}\\d$#_]*");
        if (pattern == null) {
            Intrinsics.throwNpe();
        }
        oracleGoodNamePattern = pattern;
    }

    static {
        new OraNamingService();
    }
}

