/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.settings;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.ui.CsvFormatsSettingsUI;
import com.intellij.database.csv.ui.CsvFormatsUI;
import com.intellij.database.csv.ui.FormatsListAndPreviewPanel;
import com.intellij.database.csv.ui.preview.CsvFormatPreview;
import com.intellij.database.csv.ui.preview.TableAndTextCsvFormatPreview;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.project.Project;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class CsvFormatsComponent
implements ConfigurableUi<DatabaseSettings>,
Disposable {
    private final JPanel myPanel;
    private final CsvFormatsUI myFormatsEditor;

    public CsvFormatsComponent() {
        Project project = DefaultProjectFactory.getInstance().getDefaultProject();
        this.myFormatsEditor = new CsvFormatsSettingsUI(this);
        this.myPanel = new FormatsListAndPreviewPanel(this.myFormatsEditor, new TableAndTextCsvFormatPreview(project, this));
    }

    public CsvFormatsComponent(@NotNull CsvFormatPreview preview) {
        if (preview == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preview", "com/intellij/database/settings/CsvFormatsComponent", "<init>"));
        }
        this.myFormatsEditor = new CsvFormatsSettingsUI(this);
        this.myPanel = new FormatsListAndPreviewPanel(this.myFormatsEditor, preview);
    }

    public void reset(@NotNull DatabaseSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/settings/CsvFormatsComponent", "reset"));
        }
        this.myFormatsEditor.reset(settings.getCsvFormats(), null);
    }

    public boolean isModified(@NotNull DatabaseSettings settings) {
        List<CsvFormat> formatsInEditor;
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/settings/CsvFormatsComponent", "isModified"));
        }
        List<CsvFormat> formats = settings.getCsvFormats();
        return !formats.equals(formatsInEditor = this.myFormatsEditor.getFormats());
    }

    public void apply(@NotNull DatabaseSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/settings/CsvFormatsComponent", "apply"));
        }
        settings.setCsvFormats(this.myFormatsEditor.getFormats());
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/settings/CsvFormatsComponent", "getComponent"));
        }
        return jPanel;
    }

    public void dispose() {
    }
}

