/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.ImmutableCharSequence;
import java.io.IOException;
import java.io.Writer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CharOut {
    @NotNull
    public CharOut append(@NotNull CharSequence var1);

    public long length();

    @Nullable
    public <T> T tryCast(Class<T> var1);

    public static class Util {
        public static CharOut newSink(final StringBuilder sb) {
            return new CharOut(){

                @Override
                @NotNull
                public CharOut append(@NotNull CharSequence seq) {
                    if (seq == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "seq", "com/intellij/database/util/CharOut$Util$1", "append"));
                    }
                    sb.append(seq);
                    1 v0 = this;
                    if (v0 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/CharOut$Util$1", "append"));
                    }
                    return v0;
                }

                @Override
                @Nullable
                public <T> T tryCast(Class<T> clazz) {
                    return (T)ObjectUtils.tryCast((Object)sb, clazz);
                }

                @Override
                public long length() {
                    return sb.length();
                }

                public String toString() {
                    return sb.toString();
                }
            };
        }

        public static CharOut newSink(final Writer out) {
            return new CharOut(){
                long length;

                @Override
                @NotNull
                public CharOut append(@NotNull CharSequence seq) {
                    if (seq == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "seq", "com/intellij/database/util/CharOut$Util$2", "append"));
                    }
                    try {
                        out.append(seq);
                        this.length += (long)seq.length();
                    }
                    catch (IOException e) {
                        throw new ProcessCanceledException((Throwable)e);
                    }
                    2 v0 = this;
                    if (v0 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/CharOut$Util$2", "append"));
                    }
                    return v0;
                }

                @Override
                public long length() {
                    return this.length;
                }

                @Override
                @Nullable
                public <T> T tryCast(Class<T> clazz) {
                    return (T)ObjectUtils.tryCast((Object)out, clazz);
                }
            };
        }

        public static CharOut newSink() {
            return new CharOut(){
                volatile ImmutableCharSequence text = CharArrayUtil.createImmutableCharSequence((CharSequence)"");

                @Override
                @NotNull
                public CharOut append(@NotNull CharSequence seq) {
                    if (seq == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "seq", "com/intellij/database/util/CharOut$Util$3", "append"));
                    }
                    this.text = this.text.concat(seq);
                    3 v0 = this;
                    if (v0 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/CharOut$Util$3", "append"));
                    }
                    return v0;
                }

                @Override
                @Nullable
                public <T> T tryCast(Class<T> clazz) {
                    return (T)ObjectUtils.tryCast((Object)this.text, clazz);
                }

                @Override
                public long length() {
                    return this.text.length();
                }

                public String toString() {
                    return this.text.toString();
                }
            };
        }
    }

    public static abstract class Wrapper
    implements CharOut {
        private final CharOut myDelegate;

        public Wrapper(CharOut delegate) {
            this.myDelegate = delegate;
        }

        public CharOut getDelegate() {
            return this.myDelegate;
        }

        @Override
        @NotNull
        public CharOut append(@NotNull CharSequence seq) {
            if (seq == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "seq", "com/intellij/database/util/CharOut$Wrapper", "append"));
            }
            this.myDelegate.append(seq);
            Wrapper wrapper = this;
            if (wrapper == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/CharOut$Wrapper", "append"));
            }
            return wrapper;
        }

        @Override
        public long length() {
            return this.myDelegate.length();
        }

        @Override
        @Nullable
        public <T> T tryCast(Class<T> clazz) {
            return this.myDelegate.tryCast(clazz);
        }
    }
}

