/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.IntrospectionScopeUpdater;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import gnu.trove.THashSet;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoaderContext {
    private static final Logger LOG = Logger.getInstance(LoaderContext.class);
    private final Project myProject;
    private final LocalDataSource myDataSource;
    private DatabaseFamilyId myFamilyId;
    private ErrorHandler myErrorHandler;
    private final THashSet<Object> mySelection;
    private Object mySelectedElement;
    private boolean myNamespacesOnly;
    private final IntrospectionScopeUpdater myScopeUpdater;

    public static LoaderContext loadAll(@NotNull Project project, @NotNull LocalDataSource dataSource) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/util/LoaderContext", "loadAll"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/util/LoaderContext", "loadAll"));
        }
        return new LoaderContext(project, dataSource).includeAllSchemas();
    }

    @Deprecated
    public static LoaderContext loadOne(@NotNull Project project, @NotNull LocalDataSource dataSource, Object o) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/util/LoaderContext", "loadOne"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/util/LoaderContext", "loadOne"));
        }
        return new LoaderContext(project, dataSource).include(o);
    }

    public LoaderContext(@NotNull Project project, @NotNull LocalDataSource dataSource) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/util/LoaderContext", "<init>"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/util/LoaderContext", "<init>"));
        }
        this.myErrorHandler = new ErrorHandler();
        this.mySelection = new THashSet();
        this.myNamespacesOnly = false;
        this.myScopeUpdater = new IntrospectionScopeUpdater();
        this.myProject = project;
        this.myDataSource = dataSource;
        this.myFamilyId = DatabaseFamilyId.forDataSource((DatabaseSystem)this.myDataSource);
    }

    @NotNull
    public LoaderContext merge(@NotNull LoaderContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/util/LoaderContext", "merge"));
        }
        if (this.myProject != context.myProject || this.myDataSource != context.myDataSource) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.error("Merging different contexts");
            } else {
                LOG.warn("Merging different contexts");
            }
        }
        LoaderContext result2 = new LoaderContext(this.myProject, this.myDataSource);
        result2.mySelection.addAll(this.mySelection);
        result2.mySelection.addAll(context.mySelection);
        result2.mySelectedElement = ObjectUtils.chooseNotNull((Object)this.mySelectedElement, (Object)context.mySelectedElement);
        result2.myNamespacesOnly = this.myNamespacesOnly && context.myNamespacesOnly;
        result2.myScopeUpdater.addAll(this.myScopeUpdater).addAll(context.myScopeUpdater);
        LoaderContext loaderContext = result2;
        if (loaderContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/LoaderContext", "merge"));
        }
        return loaderContext;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/LoaderContext", "getProject"));
        }
        return project;
    }

    @NotNull
    public IntrospectionScopeUpdater getScopeUpdater() {
        IntrospectionScopeUpdater introspectionScopeUpdater = this.myScopeUpdater;
        if (introspectionScopeUpdater == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/LoaderContext", "getScopeUpdater"));
        }
        return introspectionScopeUpdater;
    }

    public void renewFamilyId(@NotNull DatabaseMetaData meta) throws SQLException {
        if (meta == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/database/util/LoaderContext", "renewFamilyId"));
        }
        this.myDataSource.refreshDatabaseInfo(meta);
        this.myFamilyId = DatabaseFamilyId.forDataSource((DatabaseSystem)this.myDataSource);
    }

    @NotNull
    public LocalDataSource getDataSource() {
        LocalDataSource localDataSource = this.myDataSource;
        if (localDataSource == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/LoaderContext", "getDataSource"));
        }
        return localDataSource;
    }

    public DatabaseFamilyId getFamilyId() {
        return this.myFamilyId;
    }

    public Set<Object> getSelection() {
        return this.mySelection;
    }

    public LoaderContext setErrorHandler(ErrorHandler handler) {
        this.myErrorHandler = handler;
        return this;
    }

    public LoaderContext setNamespacesOnly(boolean namespacesOnly) {
        this.myNamespacesOnly = namespacesOnly;
        return this;
    }

    public boolean isSchemaListOnly() {
        return this.myNamespacesOnly;
    }

    public LoaderContext include(@Nullable ObjectPath o) {
        if (o != null) {
            this.mySelection.add((Object)LoaderContext.getScope(JdbcUrlParserUtil.getObjectItem(o, ObjectKind.DATABASE), JdbcUrlParserUtil.getObjectItem(o, ObjectKind.SCHEMA)));
        }
        return this;
    }

    public LoaderContext include(@Nullable Object o) {
        if (o == null) {
            return this;
        }
        if (o instanceof DasNamespace) {
            this.includeNamespace((DasNamespace)o);
        } else {
            this.mySelection.add(o instanceof DbElement ? ((DbElement)o).getDelegate() : o);
        }
        return this;
    }

    @Deprecated
    public LoaderContext includeSchema(String catalog, String schema) {
        this.mySelection.add((Object)LoaderContext.getScope(catalog, schema));
        return this;
    }

    public LoaderContext includeNamespace(@NotNull DasNamespace namespace) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/database/util/LoaderContext", "includeNamespace"));
        }
        this.mySelection.add((Object)LoaderContext.getScopeFor(namespace, this.myFamilyId));
        return this;
    }

    @NotNull
    public static String getScopeFor(@NotNull DasNamespace namespace, DatabaseFamilyId familyId) {
        String pattern;
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/database/util/LoaderContext", "getScopeFor"));
        }
        ObjectKind namespaceKind = namespace.getKind();
        if (namespaceKind == ObjectKind.DATABASE) {
            pattern = LoaderContext.getScope(namespace.getName(), null);
        } else if (namespaceKind == ObjectKind.SCHEMA) {
            DasObject parent = namespace.getDbParent();
            pattern = familyId.isOracle() ? LoaderContext.getScope(null, namespace.getName()) : (parent != null && parent.getKind() == ObjectKind.DATABASE ? LoaderContext.getScope(parent.getName(), namespace.getName()) : LoaderContext.getScope(null, namespace.getName()));
        } else {
            throw new IllegalArgumentException("Strange kind of the given namespace: " + namespaceKind.name());
        }
        String string = pattern;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/LoaderContext", "getScopeFor"));
        }
        return string;
    }

    public LoaderContext includeAllSchemas() {
        this.mySelection.add((Object)LoaderContext.getScope(null, null));
        return this;
    }

    public boolean loadNothing() {
        return this.mySelection.isEmpty() && !this.myNamespacesOnly;
    }

    public boolean load(Object o) {
        return this.mySelection.contains(o);
    }

    public boolean load(String catalog, String schema) {
        return this.mySelection.contains((Object)LoaderContext.getScope(catalog, schema)) || this.mySelection.contains((Object)LoaderContext.getScope(catalog, null)) || this.mySelection.contains((Object)LoaderContext.getScope(null, null));
    }

    public ErrorHandler getErrorHandler() {
        return this.myErrorHandler;
    }

    public Object getElementToFocus() {
        return this.mySelectedElement;
    }

    public void setElementToFocus(@Nullable Object selectedElement) {
        this.mySelectedElement = selectedElement;
    }

    @NotNull
    public static String getScope(@Nullable String catalog, @Nullable String schema) {
        if (StringUtil.isNotEmpty((String)catalog)) {
            if (StringUtil.isNotEmpty((String)schema)) {
                String string = catalog + ":" + schema;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/LoaderContext", "getScope"));
                }
                return string;
            }
            String string = catalog + ":*";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/LoaderContext", "getScope"));
            }
            return string;
        }
        if (StringUtil.isNotEmpty((String)schema)) {
            String string = "*:" + schema;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/LoaderContext", "getScope"));
            }
            return string;
        }
        if ("*" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/LoaderContext", "getScope"));
        }
        return "*";
    }
}

