/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vendors.oracle;

import com.intellij.database.console.JdbcConsole;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.scripting.Names;
import com.intellij.database.util.Case;
import com.intellij.database.vendors.oracle.OracleConsoleUtils;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class OracleCompilationErrorsObtainer
extends DataAuditor.Adapter
implements JdbcConsole.RawErrorsObtainer {
    private static final Pattern COMPILATION_COMMAND_PATTERN = Pattern.compile("^\\s*(create(\\s+or\\s+replace)?|alter|drop)\\s+((type|package|procedure|function|view)(\\s+body)?)\\s+((\\w[\\w\\.]+\\.)?\\w+)(\\s+compile(\\s+body))?", 34);
    private static final Pattern COMPILATION_ERROR_POSITION_PATTERN = Pattern.compile("^(\\d{1,6}):(\\d{1,6}):");
    private static final String RETRIEVE_ERRORS_QUERY = "select line||':'||position||':'||text as message \nfrom sys.all_errors                              \nwhere owner = nvl(?, user)                       \n  and type = upper(?)                            \n  and name = ?                                   \norder by sequence                                \n";
    private final DataAuditor mySink;

    public OracleCompilationErrorsObtainer(@NotNull DataAuditor sink) {
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/database/vendors/oracle/OracleCompilationErrorsObtainer", "<init>"));
        }
        this.mySink = sink;
    }

    @Override
    public void requestFinished(@NotNull DataRequest.Context context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/vendors/oracle/OracleCompilationErrorsObtainer", "requestFinished"));
        }
        String query = context.getQuery();
        if (StringUtil.isNotEmpty((String)query)) {
            this.obtainErrors(context, query);
        }
    }

    @Override
    public boolean obtainErrors(@NotNull DataRequest.Context context, @NotNull String queryText) {
        String objectName;
        String schemaName;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/vendors/oracle/OracleCompilationErrorsObtainer", "obtainErrors"));
        }
        if (queryText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryText", "com/intellij/database/vendors/oracle/OracleCompilationErrorsObtainer", "obtainErrors"));
        }
        DatabaseConnection connection = OracleConsoleUtils.getConnection(context);
        if (connection == null) {
            return true;
        }
        Matcher m = COMPILATION_COMMAND_PATTERN.matcher(queryText);
        boolean found = m.find();
        if (!found) {
            return true;
        }
        String operation = m.group(1);
        String objectType = m.group(3) + StringUtil.notNullize((String)m.group(9));
        String objectFullName = m.group(6);
        if (operation.equalsIgnoreCase("drop")) {
            return true;
        }
        String[] nameParts = Names.unpackName(objectFullName, Case.UPPER);
        switch (nameParts.length) {
            case 1: {
                schemaName = null;
                objectName = nameParts[0];
                break;
            }
            case 2: {
                schemaName = nameParts[0];
                objectName = nameParts[1];
                break;
            }
            default: {
                return true;
            }
        }
        String type = objectType.trim().replaceAll("\\s{2,}", " ");
        try {
            List<String> errors = OracleConsoleUtils.queryForStrings(connection, RETRIEVE_ERRORS_QUERY, schemaName, type, objectName);
            if (!errors.isEmpty()) {
                this.showErrors(context, errors);
                this.navigateToTheErrorPosition(errors.get(0));
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private void showErrors(@NotNull DataRequest.Context context, @NotNull List<String> errors) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/vendors/oracle/OracleCompilationErrorsObtainer", "showErrors"));
        }
        if (errors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/intellij/database/vendors/oracle/OracleCompilationErrorsObtainer", "showErrors"));
        }
        for (String error : errors) {
            this.mySink.error(context, error, null);
        }
    }

    private void navigateToTheErrorPosition(@NotNull String errorMessage) {
        if (errorMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/database/vendors/oracle/OracleCompilationErrorsObtainer", "navigateToTheErrorPosition"));
        }
        try {
            Matcher m = COMPILATION_ERROR_POSITION_PATTERN.matcher(errorMessage);
            if (m.find()) {
                int line = Integer.parseInt(m.group(1));
                int n = Integer.parseInt(m.group(2));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void dispose() {
    }
}

