/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vendors.postgres;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.PostgresDialect;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostgresDialectHelper {
    public static String getTableDefinition(DasTable table, DatabaseConnection connection) throws SQLException {
        String tableName = table.getName();
        String schemaName = DasUtil.getSchema((DasObject)table);
        String columnsQuery = "select  att.*,  def.*,  pg_catalog.pg_get_expr(def.adbin, def.adrelid) as defval,  case when att.attndims > 0 then 1 else 0 end as isarray,  format_type(ty.oid, NULL) as typname,  format_type(ty.oid, att.atttypmod) as displaytypname,  tn.nspname as typnspname,  et.typname as elemtypname,  ty.typstorage as defaultstorage,  cl.relname,  na.nspname,  att.attstattarget,  description,  cs.relname as sername,  ns.nspname as serschema,  (select     count(1)   from pg_type t2 where t2.typname = ty.typname) > 1 as isdup,  indkey from pg_attribute att  join pg_type ty on ty.oid = atttypid  join pg_namespace tn on tn.oid = ty.typnamespace  join pg_class cl on cl.oid = att.attrelid  join pg_namespace na on na.oid = cl.relnamespace  left outer join pg_type et on et.oid = ty.typelem  left outer join pg_attrdef def on adrelid = att.attrelid and adnum = att.attnum  left outer join pg_description des on des.objoid = att.attrelid and des.objsubid = att.attnum  left outer join (pg_depend join pg_class cs on objid = cs.oid and cs.relkind = 'S') on refobjid = att.attrelid and refobjsubid = att.attnum  left outer join pg_namespace ns on ns.oid = cs.relnamespace  left outer join pg_index pi on pi.indrelid = att.attrelid and indisprimary where     cl.relname = " + PostgresDialectHelper.str(tableName) + "      and na.nspname = " + PostgresDialectHelper.str(schemaName) + "      and att.attstattarget = -1order by att.attnum";
        DdlBuilder builder = new DdlBuilder().withDialect(PostgresDialect.INSTANCE).qualifyReferences(true);
        if (table instanceof DbElement) {
            builder.configureFor((DbElement)table);
        }
        Statement statement = connection.createStatement();
        ResultSet rs = statement.executeQuery(columnsQuery);
        int spaces = 2;
        HashMap map = ContainerUtil.newHashMap();
        LinkedHashMap columnsComments = ContainerUtil.newLinkedHashMap();
        HashSet pkIndices = ContainerUtil.newHashSet();
        DdlBuilder.Marker marker = null;
        builder.keywords("create", "table").space().qualifiedRef((DasObject)table).space().symbol("(");
        while (rs.next()) {
            String defval;
            builder.newLine();
            String attname = rs.getString("attname");
            Integer idx = rs.getInt("attnum");
            map.put(String.valueOf(idx), attname);
            builder.space(spaces).identifier(attname).space().type(rs.getString("displaytypname"));
            String indkey = rs.getString("indkey");
            if (indkey != null) {
                List indKeys = StringUtil.split((String)indkey, (String)" ");
                pkIndices.addAll(indKeys);
            }
            if (pkIndices.size() == 1 && pkIndices.contains(String.valueOf(idx))) {
                builder.space().keywords("primary", "key");
            }
            if (rs.getBoolean("attnotnull")) {
                builder.space().keywords("not", "null");
            }
            if ((defval = rs.getString("defval")) != null) {
                builder.space().keywords("default").space().literal(PostgresDialectHelper.normalizeDefaultExpression(defval));
            }
            if (marker != null) {
                marker.finish();
            }
            marker = builder.mark();
            builder.symbol(",");
            String comment = rs.getString("description");
            if (comment == null) continue;
            columnsComments.put(attname, comment);
            builder.space().comment(comment);
        }
        boolean needComma = false;
        if (pkIndices.size() > 1) {
            builder.newLine().space(spaces).keywords("primary", "key").space().symbol("(");
            needComma = true;
            boolean first = true;
            for (String pk : pkIndices) {
                if (first) {
                    first = false;
                } else {
                    builder.symbol(",").space();
                }
                builder.constraintRef(null, (String)ObjectUtils.notNull(map.get(pk), (Object)pk));
            }
            builder.symbol(")");
        }
        if (map.size() == 1) {
            builder.newLine().symbol(")").symbol(";");
        } else {
            String foreignKeysQuery = "select  ct.oid,  conname,  condeferrable,  condeferred,  confupdtype,  confdeltype,  confmatchtype,  array_to_string(conkey, ' ') as conkey,  array_to_string(confkey, ' ') as confkey,  confrelid,  nl.nspname as fknsp,  cl.relname as fktab,  nr.nspname as refnsp,  cr.relname as reftab,  description from pg_constraint ct  join pg_class cl on cl.oid = conrelid  join pg_namespace nl on nl.oid = cl.relnamespace  join pg_class cr on cr.oid = confrelid  join pg_namespace nr on nr.oid = cr.relnamespace  left outer join pg_description des on des.objoid = ct.oid where contype = 'f'      and cl.relname = " + PostgresDialectHelper.str(tableName) + "      and nl.nspname = " + PostgresDialectHelper.str(schemaName) + "order by conname";
            ArrayList<ForeignKeyWrapper> fkws = new ArrayList<ForeignKeyWrapper>(0);
            statement = connection.createStatement();
            rs = statement.executeQuery(foreignKeysQuery);
            while (rs.next()) {
                String conkey = rs.getString("conkey");
                String confkey = rs.getString("confkey");
                String refnsp = rs.getString("refnsp");
                String reftab = rs.getString("reftab");
                String confrelid = rs.getString("confrelid");
                String update2 = rs.getString("confupdtype");
                String delete = rs.getString("confdeltype");
                String match = rs.getString("confmatchtype");
                fkws.add(new ForeignKeyWrapper(conkey, confkey, refnsp, reftab, confrelid, update2, delete, match));
            }
            for (ForeignKeyWrapper f : fkws) {
                boolean first;
                List split;
                String conkey = f.myConkey;
                String confkey = f.myConfkey;
                String refnsp = f.myRefnsp;
                String reftab = f.myReftab;
                String confrelid = f.myConfrelid;
                String update3 = f.myUpdate;
                String delete = f.myDelete;
                String match = f.myMatch;
                (needComma ? builder.symbol(",") : builder).newLine().space(spaces).keywords("foreign", "key").space().symbol("(");
                needComma = true;
                if (conkey != null) {
                    split = StringUtil.split((String)conkey, (String)" ");
                    first = true;
                    for (String id : split) {
                        if (first) {
                            first = false;
                        } else {
                            builder.symbol(",").space();
                        }
                        builder.identifier((String)ObjectUtils.notNull(map.get(id), (Object)id));
                    }
                }
                builder.symbol(")").space().keyword("references").space();
                if (refnsp != null) {
                    builder.identifier(refnsp).symbol(".");
                }
                builder.identifier(StringUtil.notNullize((String)reftab)).space().symbol("(");
                if (confkey != null) {
                    split = StringUtil.split((String)confkey, (String)" ");
                    first = true;
                    for (String id : split) {
                        String attrQuery = "select * from pg_catalog.pg_attribute where attrelid = " + confrelid + " AND attnum = " + id;
                        statement = connection.createStatement();
                        rs = statement.executeQuery(attrQuery);
                        if (!rs.next()) continue;
                        String attname = rs.getString("attname");
                        if (first) {
                            first = false;
                        } else {
                            builder.symbol(",").space();
                        }
                        builder.identifier(attname);
                    }
                }
                builder.symbol(")");
                builder.newLine().space(spaces).keyword("match").space();
                builder.keyword("f".equals(match) ? "full" : ("u".equals(match) || "s".equals(match) ? "simple" : "Unknown"));
                builder.space().keywords("on", "update").space().keyword(PostgresDialectHelper.getAction(update3));
                builder.space().keywords("on", "delete").space().keyword(PostgresDialectHelper.getAction(delete));
            }
            builder.newLine().symbol(")").symbol(";");
            String indexQuery = "select  ind_name.relname,  am.amname,  pg_get_expr(indexprs, indrelid) indexprs_txt,  pg_get_expr(indpred, indrelid) indpred_txt,  *from pg_catalog.pg_index ind  join pg_catalog.pg_class rel on rel.oid = ind.indrelid  join pg_namespace na on na.oid = rel.relnamespace  join pg_catalog.pg_class ind_name on ind_name.oid = ind.indexrelid  join pg_catalog.pg_am am on am.oid=ind_name.relam where ind.indisprimary = false and rel.relname = " + PostgresDialectHelper.str(tableName) + "and na.nspname = " + PostgresDialectHelper.str(schemaName);
            statement = connection.createStatement();
            rs = statement.executeQuery(indexQuery);
            while (rs.next()) {
                String exprList;
                builder.newLine().keyword("create");
                boolean isUnique = rs.getBoolean("indisunique");
                if (isUnique) {
                    builder.space().keyword("unique");
                }
                String[] exprs = (exprList = rs.getString("indexprs_txt")) == null ? null : exprList.split(",\\s+");
                int exprId = 0;
                String pred = rs.getString("indpred_txt");
                String indexName = rs.getString("relname");
                builder.space().keyword("index").space().identifier(indexName).space().keyword("on").space();
                builder.identifier(table.getName());
                builder.space().keyword("using").space().keyword(rs.getString("amname")).space().symbol("(");
                String indkey = rs.getString("indkey");
                if (indkey != null) {
                    List split = StringUtil.split((String)indkey, (String)" ");
                    boolean first = true;
                    for (String id : split) {
                        if (first) {
                            first = false;
                        } else {
                            builder.symbol(",").space();
                        }
                        String col = (String)map.get(id);
                        if (col != null) {
                            builder.identifier(col);
                            continue;
                        }
                        if (exprs != null && exprId < exprs.length) {
                            builder.symbol("(").plain(PostgresDialectHelper.normalizeDefaultExpression(exprs[exprId])).symbol(")");
                            ++exprId;
                            continue;
                        }
                        builder.identifier(id);
                    }
                }
                builder.symbol(")");
                if (pred != null) {
                    builder.space().keyword("WHERE").space().plain(PostgresDialectHelper.normalizeDefaultExpression(pred));
                }
                builder.symbol(";");
            }
        }
        if (marker != null) {
            if (!needComma) {
                marker.replace(marker.extract().replaceFirst(",", ""));
            }
            marker.finish();
        }
        PostgresDialectHelper.generateComments(table, connection, tableName, schemaName, builder, columnsComments);
        return builder.getStatement();
    }

    private static void generateComments(DasTable table, DatabaseConnection connection, String tableName, String schemaName, DdlBuilder builder, Map<String, String> columnsComments) throws SQLException {
        String commentQuery = "select  obj_description(cl.oid) as description from pg_class cl  join pg_namespace na on na.oid = cl.relnamespace where     cl.relname = " + PostgresDialectHelper.str(tableName) + "      and na.nspname = " + PostgresDialectHelper.str(schemaName);
        Statement statement = connection.createStatement();
        ResultSet commentRs = statement.executeQuery(commentQuery);
        String description = null;
        if (commentRs.next()) {
            description = commentRs.getString("description");
        }
        if (description != null) {
            builder.newLine().keywords("comment", "on", "table").space().qualifiedRef((DasObject)table).space().keyword("is").space().literal("'" + DbImplUtil.escapeStr(description) + "'").symbol(";");
        }
        for (Map.Entry<String, String> entry : columnsComments.entrySet()) {
            builder.newLine().keywords("comment", "on", "column").space().qualifiedRef((DasObject)table).symbol(".").identifier(entry.getKey()).space().keyword("is").space().literal("'" + DbImplUtil.escapeStr(entry.getValue()) + "'").symbol(";");
        }
    }

    @NotNull
    private static String getAction(@Nullable String delete) {
        String unknown = "Unknown";
        if (delete == null) {
            String string = unknown;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vendors/postgres/PostgresDialectHelper", "getAction"));
            }
            return string;
        }
        String string = delete.equals("a") ? "no action" : (delete.equals("r") ? "restrict" : (delete.equals("c") ? "cascade" : (delete.equals("d") ? "set default" : (delete.equals("n") ? "set null" : unknown))));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vendors/postgres/PostgresDialectHelper", "getAction"));
        }
        return string;
    }

    @NotNull
    public static String normalizeDefaultExpression(@NotNull String expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/database/vendors/postgres/PostgresDialectHelper", "normalizeDefaultExpression"));
        }
        String string = expression.replace("::character varying", "");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vendors/postgres/PostgresDialectHelper", "normalizeDefaultExpression"));
        }
        return string;
    }

    public static String typeArg(String table, String alias, String oid, boolean isPre81) {
        if (!isPre81) {
            return String.format("%1$s.typname AS %2$s, %1$s.oid <> %3$s AS _%2$s", table, alias, oid);
        }
        String shortName = "case when %1$s.typelem = 0 then %1$s.typname else (select tmp.typname from pg_type as tmp where %1$s.typelem = tmp.oid limit 1) end";
        return String.format(shortName + " AS %2$s, %1$s.typelem <> 0 AS _%2$s", table, alias);
    }

    @NotNull
    public static String select(int limit, boolean isPre81) {
        StringBuilder b = new StringBuilder();
        for (int i2 = 1; i2 <= limit; ++i2) {
            b.append(PostgresDialectHelper.typeArg("t" + i2, "arg" + i2, "proargtypes[" + (i2 - 1) + "]", isPre81)).append(", ");
            if (!isPre81) {
                b.append(PostgresDialectHelper.typeArg("at" + i2, "targ" + i2, "proallargtypes[" + i2 + "]", isPre81)).append(", ");
            }
            b.append("proargnames[").append(i2).append("] AS an").append(i2).append(", ");
        }
        String string = b.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vendors/postgres/PostgresDialectHelper", "select"));
        }
        return string;
    }

    @NotNull
    public static String str(@Nullable String s) {
        String string = s == null ? "NULL" : "'" + s.replace("'", "''") + "'";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vendors/postgres/PostgresDialectHelper", "str"));
        }
        return string;
    }

    public static String joinType(String tAlias, String oid, boolean isPre81) {
        return String.format("LEFT JOIN pg_type %1$s ON %1$s.oid = %2$s" + (isPre81 ? "" : " AND %1$s.typelem = 0 OR %1$s.typarray = %2$s"), tAlias, oid);
    }

    @NotNull
    public static String join(int limit, boolean isPre81) {
        StringBuilder b = new StringBuilder();
        for (int i2 = 1; i2 <= limit; ++i2) {
            b.append(PostgresDialectHelper.joinType("t" + i2, "proargtypes[" + (i2 - 1) + "]", isPre81)).append("\n");
            if (isPre81) continue;
            b.append(PostgresDialectHelper.joinType("at" + i2, "proallargtypes[" + i2 + "]", isPre81)).append("\n");
        }
        String string = b.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vendors/postgres/PostgresDialectHelper", "join"));
        }
        return string;
    }

    public static DdlBuilder type(DdlBuilder builder, String type, boolean array) {
        builder.type(type);
        if (array) {
            builder.symbol("[]");
        }
        return builder;
    }

    public static class SignatureBuilder {
        private boolean myPre81;
        private ResultSet myRs;
        private Object[] myModes;
        private int myLen;
        private boolean myRetTable;

        public SignatureBuilder(boolean isPre81, ResultSet rs) {
            this.myPre81 = isPre81;
            this.myRs = rs;
        }

        public DdlBuilder buildArguments(DdlBuilder builder) throws SQLException {
            long numArgs = this.myRs.getLong("pronargs");
            this.myModes = this.myPre81 ? null : (Object[])ObjectUtils.tryCast((Object)this.myRs.getObject("proargmodes"), Object[].class);
            String proargdefaults = this.myPre81 ? null : this.myRs.getString("proargdefaults");
            String[] defaults = proargdefaults == null ? null : proargdefaults.split(",\\s+");
            this.myLen = this.myModes == null ? (int)numArgs : this.myModes.length;
            boolean first = true;
            this.myRetTable = false;
            for (int i2 = 1; i2 <= this.myLen; ++i2) {
                String def;
                boolean typeArr;
                boolean hasDefault;
                Object mode;
                Object object = mode = this.myModes == null ? null : this.myModes[i2 - 1];
                if ("t".equals(mode)) {
                    this.myRetTable = true;
                    continue;
                }
                boolean bl = hasDefault = !"o".equals(mode) && defaults != null && i2 > this.myLen - defaults.length;
                mode = "o".equals(mode) ? "out" : ("i".equals(mode) ? "in" : ("b".equals(mode) ? "inout" : ("v".equals(mode) ? "variadic" : "")));
                String name = this.myRs.getString("an" + i2);
                String type = this.myPre81 ? null : this.myRs.getString("targ" + i2);
                boolean bl2 = typeArr = !this.myPre81 && this.myRs.getBoolean("_targ" + i2) == Boolean.TRUE.booleanValue();
                if (type == null) {
                    type = this.myRs.getString("arg" + i2);
                    typeArr = this.myRs.getBoolean("_arg" + i2) == Boolean.TRUE.booleanValue();
                }
                String string = def = !hasDefault ? null : PostgresDialectHelper.normalizeDefaultExpression(defaults[i2 - 1 - this.myLen + defaults.length]);
                if (first) {
                    first = false;
                } else {
                    builder.symbol(",").space();
                }
                if (!StringUtil.isEmpty((String)String.valueOf(mode))) {
                    builder.keyword(String.valueOf(mode)).space();
                }
                if (!StringUtil.isEmpty((String)name)) {
                    builder.identifier(name).space();
                }
                if (!StringUtil.isEmpty((String)type)) {
                    PostgresDialectHelper.type(builder, type, typeArr);
                }
                if (StringUtil.isEmpty((String)def)) continue;
                builder.space().symbol("=").space().plain(def);
            }
            return builder;
        }

        public DdlBuilder buildReturn(DdlBuilder builder) throws SQLException {
            if (this.myRs.getBoolean("proretset")) {
                if (!this.myRetTable) {
                    builder.keyword("SETOF").space();
                    PostgresDialectHelper.type(builder, this.myRs.getString("rettype"), this.myRs.getBoolean("_rettype") == Boolean.TRUE.booleanValue());
                } else {
                    builder.keyword("TABLE").symbol("(");
                    boolean f = true;
                    for (int i2 = 1; i2 <= this.myLen; ++i2) {
                        boolean typeArr;
                        if (!"t".equals(this.myModes[i2 - 1])) continue;
                        String name = this.myRs.getString("an" + i2);
                        String type = this.myPre81 ? null : this.myRs.getString("targ" + i2);
                        boolean bl = typeArr = this.myRs.getBoolean("_targ" + i2) == Boolean.TRUE.booleanValue();
                        if (type == null) {
                            type = this.myRs.getString("arg" + i2);
                            boolean bl2 = typeArr = this.myRs.getBoolean("_arg" + i2) == Boolean.TRUE.booleanValue();
                        }
                        if (!f) {
                            builder.symbol(",").space();
                        } else {
                            f = false;
                        }
                        builder.identifier((String)ObjectUtils.chooseNotNull((Object)name, (Object)("a" + i2))).space();
                        PostgresDialectHelper.type(builder, (String)ObjectUtils.chooseNotNull((Object)type, (Object)"any"), typeArr);
                    }
                    builder.symbol(")");
                }
            } else {
                PostgresDialectHelper.type(builder, this.myRs.getString("rettype"), this.myRs.getBoolean("_rettype") == Boolean.TRUE.booleanValue());
            }
            return builder;
        }
    }

    static class ForeignKeyWrapper {
        @Nullable
        private final String myConkey;
        @Nullable
        private final String myConfkey;
        @Nullable
        private final String myRefnsp;
        @Nullable
        private final String myReftab;
        @Nullable
        private final String myConfrelid;
        @Nullable
        private final String myUpdate;
        @Nullable
        private final String myDelete;
        @Nullable
        private final String myMatch;

        public ForeignKeyWrapper(@Nullable String conkey, @Nullable String confkey, @Nullable String refnsp, @Nullable String reftab, @Nullable String confrelid, @Nullable String update2, @Nullable String delete, @Nullable String match) {
            this.myConkey = conkey;
            this.myConfkey = confkey;
            this.myRefnsp = refnsp;
            this.myReftab = reftab;
            this.myConfrelid = confrelid;
            this.myUpdate = update2;
            this.myDelete = delete;
            this.myMatch = match;
        }
    }
}

